/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.ComponentProcessor;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelList;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelListRenderer
extends XhtmlRenderer {
    private final GroupingCallback _groupingCallback = new GroupingCallback();
    private final EncoderCallback _encoderCallback = new EncoderCallback();
    private static final int COLUMNS_DEFAULT = 3;
    private PropertyKey _maxColumnsKey;
    private PropertyKey _rowsKey;
    private PropertyKey _listStyleKey;

    public PanelListRenderer() {
        super(CorePanelList.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._maxColumnsKey = type.findKey("maxColumns");
        this._rowsKey = type.findKey("rows");
        this._listStyleKey = type.findKey("listStyle");
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, rc, component, bean, "af|panelList");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Number rowsNumber = this.getRows(component, bean);
        int rows = rowsNumber == null ? Integer.MAX_VALUE : rowsNumber.intValue();
        Number maxColumnsNumber = this.getMaxColumns(component, bean);
        int maxCols = maxColumnsNumber == null ? this._getDefaultColumns(rc) : maxColumnsNumber.intValue();
        String listStyle = this.getListStyle(component, bean);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        ((CoreRenderingContext)rc).setDefaultLinkStyleDisabled(true);
        List children = component.getChildren();
        GroupingCallbackState groupingCallbackState = new GroupingCallbackState(children.size());
        UIXComponent.processFlattenedChildren((FacesContext)context, (ComponentProcessor)this._groupingCallback, (Iterable)children, (Object)groupingCallbackState);
        int bulletCount = groupingCallbackState.bulletCount;
        if (bulletCount <= 0 || rows < 1 || maxCols < 1) {
            writer.endElement("div");
            ((CoreRenderingContext)rc).setDefaultLinkStyleDisabled(false);
            return;
        }
        boolean usesPossiblyMultipleColumnDom = false;
        if (rows < bulletCount) {
            usesPossiblyMultipleColumnDom = true;
            writer.startElement("table", null);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", "100%");
            writer.startElement("tr", null);
        }
        int bulletsPerColumn = bulletCount;
        int columnCount = (int)Math.ceil((double)bulletCount / (double)rows);
        if (columnCount > maxCols) {
            columnCount = maxCols;
        }
        if (columnCount > 1) {
            bulletsPerColumn = (int)Math.ceil((double)bulletCount / (double)columnCount);
        }
        String columnWidth = IntegerUtils.getString((int)(100 / columnCount)) + "%";
        EncodingCallbackState encodingCallbackState = new EncodingCallbackState(groupingCallbackState.groupStates, bulletsPerColumn, columnWidth, listStyle, usesPossiblyMultipleColumnDom);
        UIXComponent.encodeFlattenedChildren((FacesContext)context, (ComponentProcessor)this._encoderCallback, (Iterable)children, (Object)encodingCallbackState);
        if (usesPossiblyMultipleColumnDom) {
            writer.endElement("tr");
            writer.endElement("table");
        }
        writer.endElement("div");
        ((CoreRenderingContext)rc).setDefaultLinkStyleDisabled(false);
    }

    protected Number getRows(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    protected Number getMaxColumns(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._maxColumnsKey);
    }

    protected String getListStyle(UIComponent component, FacesBean bean) {
        return PanelListRenderer.toString((Object)bean.getProperty(this._listStyleKey));
    }

    private void _renderListStyle(FacesContext context, String listStyle) throws IOException {
        if (listStyle != null) {
            context.getResponseWriter().writeAttribute("style", (Object)listStyle, "listStyle");
        }
    }

    private int _getDefaultColumns(RenderingContext rc) {
        Integer defaultColumns = (Integer)rc.getSkin().getProperty((Object)"af|panelList-tr-default-columns");
        return defaultColumns != null ? defaultColumns : 3;
    }

    private class EncoderCallback
    implements ComponentProcessor<EncodingCallbackState> {
        private EncoderCallback() {
        }

        public void processComponent(FacesContext facesContext, ComponentProcessingContext processContext, UIComponent child, EncodingCallbackState encodingState) throws IOException {
            ResponseWriter rw = facesContext.getResponseWriter();
            boolean usesPossiblyMultipleColumnDom = encodingState.usesPossiblyMultipleColumnDom;
            int visitedChildIndex = encodingState.visitedChildIndex++;
            int currentColumnIndex = encodingState.currentColumnIndex;
            int bulletsPerColumn = encodingState.bulletsPerColumn;
            List<GroupState> groupStates = encodingState.groupStates;
            GroupState groupState = groupStates.get(visitedChildIndex);
            boolean isNewLayoutItem = !GroupState.IN_GROUP.equals((Object)groupState);
            int childCount = groupStates.size();
            boolean isLayoutItemEnd = true;
            if (!GroupState.OUTSIDE_GROUP.equals((Object)groupState) && visitedChildIndex < childCount - 1) {
                GroupState nextGroupState = groupStates.get(1 + visitedChildIndex);
                boolean bl = isLayoutItemEnd = GroupState.OUTSIDE_GROUP.equals((Object)nextGroupState) || GroupState.START_GROUP.equals((Object)nextGroupState);
            }
            if (currentColumnIndex >= bulletsPerColumn) {
                currentColumnIndex = 0;
            }
            if (isNewLayoutItem) {
                if (currentColumnIndex == 0) {
                    if (usesPossiblyMultipleColumnDom) {
                        rw.startElement("td", null);
                        rw.writeAttribute("width", (Object)encodingState.columnWidth, null);
                        rw.writeAttribute("valign", (Object)"top", null);
                    }
                    rw.startElement("ul", null);
                    PanelListRenderer.this._renderListStyle(facesContext, encodingState.listStyle);
                }
                rw.startElement("li", null);
                rw.writeAttribute("value", (Object)(1 + visitedChildIndex), null);
            }
            PanelListRenderer.this.encodeChild(facesContext, child);
            if (isLayoutItemEnd) {
                rw.endElement("li");
                if (currentColumnIndex == bulletsPerColumn - 1 || visitedChildIndex == childCount - 1) {
                    rw.endElement("ul");
                    if (usesPossiblyMultipleColumnDom) {
                        rw.endElement("td");
                    }
                }
                encodingState.currentColumnIndex = ++currentColumnIndex;
            }
        }
    }

    private static class EncodingCallbackState {
        protected final List<GroupState> groupStates;
        protected final int bulletsPerColumn;
        protected final String columnWidth;
        protected final String listStyle;
        protected final boolean usesPossiblyMultipleColumnDom;
        protected int visitedChildIndex;
        protected int currentColumnIndex;

        public EncodingCallbackState(List<GroupState> groupStates, int bulletsPerColumn, String columnWidth, String listStyle, boolean usesPossiblyMultipleColumnDom) {
            this.groupStates = groupStates;
            this.bulletsPerColumn = bulletsPerColumn;
            this.columnWidth = columnWidth;
            this.listStyle = listStyle;
            this.usesPossiblyMultipleColumnDom = usesPossiblyMultipleColumnDom;
        }
    }

    private class GroupingCallback
    implements ComponentProcessor<GroupingCallbackState> {
        private GroupingCallback() {
        }

        public void processComponent(FacesContext facesContext, ComponentProcessingContext processContext, UIComponent child, GroupingCallbackState callbackState) throws IOException {
            if (processContext.getGroupDepth() == 0) {
                callbackState.groupStates.add(GroupState.OUTSIDE_GROUP);
                ++callbackState.bulletCount;
            } else if (processContext.getStartDepth() > 0) {
                callbackState.groupStates.add(GroupState.START_GROUP);
                ++callbackState.bulletCount;
            } else {
                callbackState.groupStates.add(GroupState.IN_GROUP);
            }
        }
    }

    private static class GroupingCallbackState {
        protected final List<GroupState> groupStates;
        protected int bulletCount;

        public GroupingCallbackState(int initialSize) {
            this.groupStates = new ArrayList<GroupState>(initialSize);
        }
    }

    private static enum GroupState {
        START_GROUP,
        IN_GROUP,
        OUTSIDE_GROUP;

    }
}

