/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.component.core.data.CoreTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;
import org.apache.myfaces.trinidadinternal.share.util.FastMessageFormat;

public class TreeTableNavRenderer
extends XhtmlRenderer {
    private final boolean _isTop;
    private static final String _PREVIOUS_ALT_KEY = "af_treeTable.PREVIOUS_TIP";
    private static final String _NEXT_ALT_KEY = "af_treeTable.NEXT_TIP";
    private static final int _INCOMPLETE = -1;
    private static final String _PREVIOUS_KEY = "af_treeTable.DISABLED_PREVIOUS";
    private static final String _NEXT_KEY = "af_treeTable.DISABLED_NEXT";
    private static final String _FORMAT_KEY_TC = "af_treeTable.NAV_CELL_FORMAT_T_C_private";
    private static final String _FORMAT_KEY_NTC = "af_treeTable.NAV_CELL_FORMAT_NT_C_private";
    private static final String _FORMAT_KEY_TNC = "af_treeTable.NAV_CELL_FORMAT_T_NC_private";
    private static final String _FORMAT_KEY_NTNC = "af_treeTable.NAV_CELL_FORMAT_NT_NC_private";

    public TreeTableNavRenderer(boolean isTop) {
        super(CoreTreeTable.TYPE);
        this._isTop = isTop;
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        Object childTypeText = null;
        TreeTableRenderingContext ttrc = TreeTableRenderingContext.getInstance();
        UIXTreeTable hgrid = ttrc.getUIXTreeTable();
        int rows = hgrid.getRows();
        int first = hgrid.getFirst();
        int rowCount = hgrid.getRowCount();
        this._renderViewNavBar(context, rc, ttrc, hgrid, first, childTypeText, this._isTop, rows, rowCount);
    }

    private void _renderViewNavBar(FacesContext context, RenderingContext rc, TreeTableRenderingContext ttrc, UIXTreeTable hgrid, int rangeStart, Object text, boolean isTop, int viewSize, int numChildren) throws IOException {
        String direction;
        int nextWindowStart = 0;
        int nextWindowEnd = 0;
        boolean incomplete = numChildren == -1;
        boolean haveText = text != null;
        boolean disabled = true;
        if (isTop) {
            if (rangeStart > 0) {
                disabled = false;
                nextWindowStart = rangeStart - viewSize;
                if (nextWindowStart < 0) {
                    nextWindowStart = 0;
                }
                nextWindowEnd = rangeStart;
            }
        } else if (incomplete) {
            disabled = false;
        } else {
            nextWindowStart = rangeStart + viewSize;
            if (nextWindowStart < numChildren) {
                disabled = false;
                nextWindowEnd = nextWindowStart + viewSize;
                if (nextWindowEnd > numChildren) {
                    nextWindowEnd = numChildren;
                }
            }
        }
        String linkText = direction = rc.getTranslatedString(isTop ? _PREVIOUS_KEY : _NEXT_KEY);
        if (!disabled) {
            String formatKey;
            Object[] srcs = new Object[4];
            int strNum = 0;
            if (haveText) {
                srcs[strNum++] = text;
            }
            srcs[strNum++] = direction;
            if (incomplete) {
                formatKey = haveText ? _FORMAT_KEY_TNC : _FORMAT_KEY_NTNC;
                srcs[strNum] = "" + viewSize;
            } else {
                formatKey = haveText ? _FORMAT_KEY_TC : _FORMAT_KEY_NTC;
                srcs[strNum++] = nextWindowStart + 1 + " - " + nextWindowEnd;
                srcs[strNum] = "" + numChildren;
            }
            String format = rc.getTranslatedString(formatKey);
            if (format != null) {
                FastMessageFormat fmf = new FastMessageFormat(format);
                linkText = fmf.format(srcs);
            }
        }
        this._writeCellContents(context, rc, ttrc, hgrid, linkText, disabled, isTop, nextWindowStart);
    }

    private void _writeCellContents(FacesContext context, RenderingContext rc, TreeTableRenderingContext ttrc, UIXTreeTable hgrid, String text, boolean disabled, boolean isTop, int index) throws IOException {
        String styleClass;
        if (text == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String onclick = TreeUtils.callJSGotoNode((UIXHierarchy)hgrid, ttrc.getJSVarName(), index);
        boolean isRTL = rc.isRightToLeft();
        int depth = hgrid.getDepth() + 1;
        int spacerWidth = this._getSpacerWidth();
        writer.startElement("td", null);
        writer.startElement("div", null);
        if (isRTL) {
            writer.writeAttribute("style", (Object)("margin-right:" + depth * spacerWidth + "px"), null);
        } else {
            writer.writeAttribute("style", (Object)("position:relative;top:0px;left:0px;margin-left:" + depth * spacerWidth + "px"), null);
        }
        Icon icon = this._getIcon(rc, isTop, disabled);
        if (icon != null) {
            writer.startElement("a", null);
            String shortDesc = rc.getTranslatedString(isTop ? _PREVIOUS_ALT_KEY : _NEXT_ALT_KEY);
            if (!disabled) {
                writer.writeURIAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)onclick, null);
                writer.writeAttribute("title", (Object)shortDesc, null);
            }
            String align = OutputUtils.getMiddleIconAlignment(rc);
            OutputUtils.renderIcon(context, rc, icon, shortDesc, align);
            writer.endElement("a");
        }
        writer.startElement("a", null);
        if (disabled) {
            styleClass = "OraHGridNavRowInactiveLink";
        } else {
            styleClass = "OraHGridNavRowActiveLink";
            writer.writeURIAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
            String shortDesc = rc.getTranslatedString(isTop ? _PREVIOUS_ALT_KEY : _NEXT_ALT_KEY);
            writer.writeAttribute("title", (Object)shortDesc, null);
        }
        TreeTableNavRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)styleClass);
        if (text != null) {
            writer.writeText((Object)text, null);
        }
        writer.endElement("a");
        writer.endElement("div");
        writer.endElement("td");
    }

    private Icon _getIcon(RenderingContext rc, boolean isTop, boolean isDisabled) {
        String iconKey = isTop ? (isDisabled ? "af|treeTable::disabled-nav-up-icon" : "af|treeTable::nav-up-icon") : (isDisabled ? "af|treeTable::disabled-nav-down-icon" : "af|treeTable::nav-down-icon");
        return rc.getIcon(iconKey);
    }

    private int _getSpacerWidth() {
        return 18;
    }
}

