/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidad.util.URLUtils;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSDocumentHandler;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSParser;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetNode;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetEntry;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeCompactPropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

class SkinStyleSheetParserUtils {
    private static final String _TR_PROPERTY_PREFIX = "-tr-";
    private static final String _ORA_PROPERTY_PREFIX = "-ora-";
    private static final String _PROPERTY_RULE_REF = "rule-ref";
    private static final String _PROPERTY_INHIBIT = "inhibit";
    private static final String _INCLUDE_PROPERTY = "-tr-property-ref";
    private static final String _PROPERTY_TEXT_ANTIALIAS = "text-antialias";
    private static final Pattern _SPACE_PATTERN = Pattern.compile("\\s");
    private static final Pattern _SELECTOR_PATTERN = Pattern.compile("selector\\(");
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinStyleSheetParserUtils.class);

    SkinStyleSheetParserUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StyleSheetEntry parseCSSSource(ParseContext context, NameResolver resolver, String sourceName, Class<?> expectedType) throws IOException {
        if (expectedType == null) {
            throw new NullPointerException();
        }
        if (resolver == null) {
            throw new NullPointerException();
        }
        if (sourceName == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        InputStreamProvider provider = resolver.getProvider(sourceName);
        Object cached = provider.getCachedResult();
        if (cached != null && expectedType.isInstance(cached)) {
            return (StyleSheetEntry)cached;
        }
        InputStream stream = provider.openInputStream();
        try {
            XMLUtils.setResolver(context, resolver.getResolver(sourceName));
            XMLUtils.setInputStreamProvider(context, provider);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            SkinCSSParser parser = new SkinCSSParser();
            SkinCSSDocumentHandler documentHandler = new SkinCSSDocumentHandler(context);
            parser.parseCSSDocument(reader, documentHandler);
            List<SkinStyleSheetNode> skinSSNodeList = documentHandler.getSkinStyleSheetNodes();
            reader.close();
            StyleSheetEntry styleSheetEntry = SkinStyleSheetParserUtils._createStyleSheetEntry(context, sourceName, skinSSNodeList);
            provider.setCachedResult((Object)styleSheetEntry);
            StyleSheetEntry styleSheetEntry2 = styleSheetEntry;
            return styleSheetEntry2;
        }
        finally {
            stream.close();
        }
    }

    public static String trimQuotes(String in) {
        if (in == null) {
            return in;
        }
        boolean startsWithDoubleQuote = in.startsWith("\"");
        boolean startsWithSingleQuote = in.startsWith("'");
        boolean endsWithDoubleQuote = in.endsWith("\"");
        boolean endsWithSingleQuote = in.endsWith("'");
        if ((startsWithDoubleQuote && endsWithSingleQuote || startsWithSingleQuote && endsWithDoubleQuote) && _LOG.isWarning()) {
            _LOG.warning("ERR_PARSING", (Object)in);
        }
        if (startsWithDoubleQuote && endsWithDoubleQuote) {
            return in.substring(1, in.length() - 1);
        }
        if (startsWithSingleQuote && endsWithSingleQuote) {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }

    private static StyleSheetEntry _createStyleSheetEntry(ParseContext context, String sourceName, List<SkinStyleSheetNode> skinSSNodeList) {
        ArrayList<StyleSheetNode> ssNodeList = new ArrayList<StyleSheetNode>();
        String baseSourceURI = CSSUtils.getBaseSkinStyleSheetURI(sourceName);
        for (SkinStyleSheetNode skinSSNode : skinSSNodeList) {
            List<SkinSelectorPropertiesNode> selectorNodeList = skinSSNode.getSelectorNodeList();
            ArrayList<StyleNode> styleNodeList = new ArrayList<StyleNode>();
            ArrayList<IconNode> iconNodeList = new ArrayList<IconNode>();
            for (SkinSelectorPropertiesNode cssSelector : selectorNodeList) {
                String selectorName = cssSelector.getSelectorName();
                List<PropertyNode> propertyList = cssSelector.getPropertyNodes();
                int direction = skinSSNode.getDirection();
                ResolvedSkinProperties resolvedProperties = SkinStyleSheetParserUtils._resolveProperties(propertyList);
                ArrayList<PropertyNode> trSkinPropertyNodeList = new ArrayList();
                trSkinPropertyNodeList = resolvedProperties.getSkinPropertyNodeList();
                List<PropertyNode> noTrPropertyList = resolvedProperties.getNoTrPropertyList();
                if (StyleUtils.isIcon(selectorName)) {
                    boolean hasContentProperty;
                    if (selectorName.charAt(0) == '.') {
                        selectorName = selectorName.substring(1);
                    }
                    selectorName = selectorName.replaceFirst(":alias", "");
                    if (direction == 2) {
                        selectorName = selectorName.concat(":rtl");
                    }
                    if (hasContentProperty = SkinStyleSheetParserUtils._addIconNode(sourceName, baseSourceURI, selectorName, noTrPropertyList, resolvedProperties.getTrRuleRefList(), resolvedProperties.getInhibitedProperties(), iconNodeList)) continue;
                    if ((resolvedProperties.getTrRuleRefList() == null || resolvedProperties.getTrRuleRefList().isEmpty()) && _LOG.isWarning()) {
                        _LOG.warning("SELECTOR_SHOULD_NOT_END_IN_ICON", (Object)selectorName);
                    }
                    SkinStyleSheetParserUtils._addStyleNode(selectorName, noTrPropertyList, trSkinPropertyNodeList, resolvedProperties.getTrRuleRefList(), resolvedProperties.getIncludedPropertiesList(), resolvedProperties.getIncludedCompactPropertiesList(), resolvedProperties.getInhibitedProperties(), resolvedProperties.isTrTextAntialias(), styleNodeList);
                    continue;
                }
                SkinStyleSheetParserUtils._addStyleNode(selectorName, noTrPropertyList, trSkinPropertyNodeList, resolvedProperties.getTrRuleRefList(), resolvedProperties.getIncludedPropertiesList(), resolvedProperties.getIncludedCompactPropertiesList(), resolvedProperties.getInhibitedProperties(), resolvedProperties.isTrTextAntialias(), styleNodeList);
            }
            if (styleNodeList.size() <= 0 && iconNodeList.size() <= 0) continue;
            StyleNode[] styleNodeArray = styleNodeList.toArray(new StyleNode[0]);
            StyleSheetNode ssNode = new StyleSheetNode(styleNodeArray, iconNodeList, skinSSNode.getLocales(), skinSSNode.getDirection(), skinSSNode.getAgentMatcher(), skinSSNode.getPlatforms(), skinSSNode.getMode(), skinSSNode.getAcessibilityProperties());
            ssNodeList.add(ssNode);
        }
        StyleSheetDocument ssDocument = SkinStyleSheetParserUtils._createStyleSheetDocument(context, ssNodeList);
        return new StyleSheetEntry(sourceName, ssDocument);
    }

    private static ResolvedSkinProperties _resolveProperties(List<PropertyNode> propertyNodeList) {
        ArrayList<PropertyNode> noTrPropertyList = new ArrayList<PropertyNode>();
        ArrayList<String> trRuleRefList = new ArrayList<String>();
        TreeSet<String> inhibitedPropertySet = new TreeSet<String>();
        ArrayList<IncludePropertyNode> includedPropertiesList = new ArrayList<IncludePropertyNode>();
        ArrayList<IncludeCompactPropertyNode> includedCompactPropertiesList = new ArrayList<IncludeCompactPropertyNode>();
        ArrayList<PropertyNode> skinPropertyNodeList = new ArrayList<PropertyNode>();
        boolean trTextAntialias = false;
        for (PropertyNode propertyNode : propertyNodeList) {
            String propertyName = propertyNode.getName();
            String propertyValue = propertyNode.getValue();
            if (propertyName == null || propertyValue == null) continue;
            if (propertyValue.indexOf(_INCLUDE_PROPERTY) != -1) {
                List<String> values = SkinStyleSheetParserUtils.separateCompactValues(propertyValue);
                if (values.size() == 1) {
                    IncludePropertyNode node = SkinStyleSheetParserUtils._createIncludePropertyNode(propertyName, propertyValue.substring(_INCLUDE_PROPERTY.length()));
                    includedPropertiesList.add(node);
                    continue;
                }
                ArrayList<IncludePropertyNode> compactIncludePropNodes = new ArrayList<IncludePropertyNode>();
                StringBuilder builder = new StringBuilder();
                for (String value : values) {
                    if (value.startsWith(_INCLUDE_PROPERTY)) {
                        IncludePropertyNode node = SkinStyleSheetParserUtils._createIncludePropertyNode(propertyName, value.substring(_INCLUDE_PROPERTY.length()));
                        compactIncludePropNodes.add(node);
                        continue;
                    }
                    builder.append(value);
                    builder.append(" ");
                }
                IncludeCompactPropertyNode iCPNode = new IncludeCompactPropertyNode(builder.toString(), compactIncludePropNodes, propertyName);
                includedCompactPropertiesList.add(iCPNode);
                continue;
            }
            boolean oraProperty = propertyName.startsWith(_ORA_PROPERTY_PREFIX);
            boolean trProperty = propertyName.startsWith(_TR_PROPERTY_PREFIX);
            if (oraProperty || trProperty) {
                int suffixIndex = oraProperty ? _ORA_PROPERTY_PREFIX.length() : _TR_PROPERTY_PREFIX.length();
                String propertyNameSuffix = propertyName.substring(suffixIndex);
                if (propertyNameSuffix.equals(_PROPERTY_RULE_REF)) {
                    trRuleRefList.add(propertyValue);
                    continue;
                }
                if (propertyNameSuffix.equals(_PROPERTY_TEXT_ANTIALIAS)) {
                    if (!"true".equals(propertyValue)) continue;
                    trTextAntialias = true;
                    continue;
                }
                if (propertyNameSuffix.equals(_PROPERTY_INHIBIT)) {
                    for (String value : _SPACE_PATTERN.split(propertyValue)) {
                        inhibitedPropertySet.add(value);
                    }
                    continue;
                }
                PropertyNode node = new PropertyNode(propertyName, propertyValue);
                skinPropertyNodeList.add(node);
                continue;
            }
            noTrPropertyList.add(propertyNode);
        }
        return new ResolvedSkinProperties(noTrPropertyList, trRuleRefList, includedPropertiesList, includedCompactPropertiesList, inhibitedPropertySet, skinPropertyNodeList, trTextAntialias);
    }

    private static List<String> separateCompactValues(String propertyValue) {
        String[] test = _SPACE_PATTERN.split(propertyValue);
        ArrayList<String> propertyValueNoSpaces = new ArrayList<String>();
        boolean inTr = false;
        int inTrIndex = 0;
        for (int i = 0; i < test.length; ++i) {
            String string = test[i];
            if (string.startsWith(_INCLUDE_PROPERTY) && !string.endsWith(")")) {
                inTr = true;
                inTrIndex = i;
                continue;
            }
            if (inTr) {
                if (!string.endsWith(")")) continue;
                StringBuilder builder = new StringBuilder();
                for (int j = inTrIndex; j <= i; ++j) {
                    builder.append(test[j]);
                }
                inTr = false;
                propertyValueNoSpaces.add(builder.toString());
                continue;
            }
            propertyValueNoSpaces.add(string);
        }
        return propertyValueNoSpaces;
    }

    private static boolean _addIconNode(String sourceName, String baseSourceURI, String selectorName, List<PropertyNode> noTrPropertyNodeList, List<String> trRuleRefList, Set<String> inhibitedProperties, List<IconNode> iconNodeList) {
        boolean hasContentProperty = false;
        PropertyNode[] propertyNodeArray = new PropertyNode[noTrPropertyNodeList.size()];
        int i = 0;
        for (PropertyNode propertyNode : noTrPropertyNodeList) {
            String propertyName = propertyNode.getName();
            String propertyValue = propertyNode.getValue();
            if (propertyName.equals("content") && propertyValue != null) {
                hasContentProperty = true;
                if (SkinStyleSheetParserUtils._isURLValue(propertyValue)) {
                    String uriString = SkinStyleSheetParserUtils._getURIString(propertyValue);
                    boolean isAbsoluteURI = CSSUtils.isAbsoluteURI(uriString);
                    if (!isAbsoluteURI) {
                        boolean startsWithTwoSlashes = uriString.startsWith("//");
                        uriString = !startsWithTwoSlashes && uriString.startsWith("/") ? uriString.substring(1) : (startsWithTwoSlashes ? uriString.substring(1) : CSSUtils.getAbsoluteURIValue(sourceName, baseSourceURI, uriString));
                    }
                    propertyNodeArray[i] = new PropertyNode(propertyName, SkinStyleSheetParserUtils._wrapWithURLString(uriString));
                } else if (propertyValue.startsWith(_PROPERTY_INHIBIT)) {
                    propertyNodeArray[i] = new PropertyNode(propertyName, propertyValue);
                } else {
                    String text = SkinStyleSheetParserUtils.trimQuotes(propertyValue);
                    propertyNodeArray[i] = new PropertyNode(propertyName, text);
                }
            } else {
                propertyNodeArray[i] = new PropertyNode(propertyName, propertyValue);
            }
            ++i;
        }
        ArrayList<IncludeStyleNode> includeStyleNodes = new ArrayList<IncludeStyleNode>();
        for (String value : trRuleRefList) {
            SkinStyleSheetParserUtils._addIncludeStyleNodes(value, includeStyleNodes);
        }
        if (selectorName != null) {
            StyleNode styleNode = new StyleNode(null, selectorName, propertyNodeArray, null, includeStyleNodes.toArray(new IncludeStyleNode[0]), null, null, inhibitedProperties);
            iconNodeList.add(new IconNode(selectorName, null, styleNode));
        }
        return hasContentProperty;
    }

    private static void _addStyleNode(String selectorName, List<PropertyNode> propertyNodeList, List<PropertyNode> skinPropertyNodeList, List<String> trRuleRefList, List<IncludePropertyNode> includePropertyNodes, List<IncludeCompactPropertyNode> includeCompactPropertyNodes, Set<String> inhibitedProperties, boolean trTextAntialias, List<StyleNode> styleNodeList) {
        StyleNode styleNode = SkinStyleSheetParserUtils._createStyleNode(selectorName, propertyNodeList, skinPropertyNodeList, trRuleRefList, includePropertyNodes, includeCompactPropertyNodes, inhibitedProperties, trTextAntialias);
        styleNodeList.add(styleNode);
    }

    private static StyleNode _createStyleNode(String selectorName, List<PropertyNode> propertyNodeList, List<PropertyNode> skinPropertyNodeList, List<String> trRuleRefList, List<IncludePropertyNode> includePropertyNodes, List<IncludeCompactPropertyNode> includeCompactPropertyNodes, Set<String> inhibitedProperties, boolean trTextAntialias) {
        String name = null;
        String selector = null;
        int aliasIndex = selectorName.indexOf(":alias");
        if (aliasIndex > -1) {
            name = selectorName.substring(1, aliasIndex);
        } else {
            selector = selectorName;
        }
        if (trTextAntialias) {
            propertyNodeList.add(new PropertyNode(_PROPERTY_TEXT_ANTIALIAS, "true"));
        }
        PropertyNode[] propertyArray = propertyNodeList.toArray(new PropertyNode[propertyNodeList.size()]);
        int length = trRuleRefList.size();
        ArrayList<IncludeStyleNode> includeStyleNodes = new ArrayList<IncludeStyleNode>();
        if (length > 0) {
            for (String value : trRuleRefList) {
                SkinStyleSheetParserUtils._addIncludeStyleNodes(value, includeStyleNodes);
            }
        }
        StyleNode styleNode = new StyleNode(name, selector, propertyArray, skinPropertyNodeList.isEmpty() ? null : skinPropertyNodeList.toArray(new PropertyNode[0]), includeStyleNodes.toArray(new IncludeStyleNode[0]), includePropertyNodes.isEmpty() ? null : includePropertyNodes.toArray(new IncludePropertyNode[0]), includeCompactPropertyNodes.isEmpty() ? null : includeCompactPropertyNodes.toArray(new IncludeCompactPropertyNode[0]), inhibitedProperties, false);
        return styleNode;
    }

    private static IncludePropertyNode _createIncludePropertyNode(String propertyName, String propertyValue) {
        if (propertyValue == null || propertyValue.length() < 2) {
            return null;
        }
        if (propertyValue.startsWith("(") && propertyValue.endsWith(")")) {
            String valueString = propertyValue.substring(1, propertyValue.length() - 1);
            String[] values = valueString.split(",");
            String selectorValue = SkinStyleSheetParserUtils.trimQuotes(values[0]);
            String includedProperty = values.length == 1 ? propertyName : SkinStyleSheetParserUtils.trimQuotes(values[1].trim());
            String selector = null;
            String name = null;
            if (selectorValue.endsWith(":alias")) {
                int aliasEndIndex = selectorValue.indexOf(":alias");
                int aliasStartIndex = 0;
                if (selectorValue.startsWith(".")) {
                    aliasStartIndex = 1;
                }
                name = selectorValue.substring(aliasStartIndex, aliasEndIndex);
            } else {
                selector = selectorValue;
            }
            return new IncludePropertyNode(name, selector, includedProperty, propertyName);
        }
        return null;
    }

    private static void _addIncludeStyleNodes(String value, List<IncludeStyleNode> includeStyleNodes) {
        if (value != null) {
            ArrayList<String> selectors = new ArrayList<String>();
            SkinStyleSheetParserUtils._parseValueIntoSelectors(value, selectors);
            for (String includeStyle : selectors) {
                if (includeStyle.endsWith(":alias")) {
                    int endIndex = includeStyle.indexOf(":alias");
                    int startIndex = 0;
                    if (includeStyle.charAt(0) == '.') {
                        startIndex = 1;
                    }
                    includeStyleNodes.add(new IncludeStyleNode(includeStyle.substring(startIndex, endIndex), null));
                    continue;
                }
                includeStyleNodes.add(new IncludeStyleNode(null, includeStyle));
            }
        }
    }

    private static void _parseValueIntoSelectors(String value, List<String> selectors) {
        String[] test = _SELECTOR_PATTERN.split(value);
        for (int i = 0; i < test.length; ++i) {
            int endIndex = test[i].indexOf(")");
            if (endIndex <= -1) continue;
            String selectorValue = test[i].substring(0, endIndex);
            selectorValue = SkinStyleSheetParserUtils.trimQuotes(selectorValue);
            selectors.add(selectorValue);
        }
    }

    private static StyleSheetDocument _createStyleSheetDocument(ParseContext context, List<StyleSheetNode> ssNodeList) {
        long timestamp = SkinStyleSheetParserUtils._getDocumentTimestamp(context);
        return new StyleSheetDocument(ssNodeList.toArray(new StyleSheetNode[0]), null, timestamp);
    }

    private static long _getDocumentTimestamp(ParseContext parseContext) {
        long timestamp = -1L;
        InputStreamProvider provider = XMLUtils.getInputStreamProvider(parseContext);
        if (provider != null) {
            Object identifier = provider.getIdentifier();
            if (identifier instanceof File) {
                timestamp = ((File)identifier).lastModified();
            } else if (identifier instanceof URL) {
                try {
                    timestamp = URLUtils.getLastModified((URL)((URL)identifier));
                }
                catch (IOException io) {
                    _LOG.warning("CANNOT_GET_STYLESHEET_DOCUMENT_TIMESTAMP");
                }
            }
        }
        return timestamp;
    }

    private static boolean _isURLValue(String propertyValue) {
        return propertyValue.startsWith("url(");
    }

    private static String _getURIString(String propertyValue) {
        assert (SkinStyleSheetParserUtils._isURLValue(propertyValue));
        int uriEnd = propertyValue.indexOf(41);
        String uri = propertyValue.substring(4, uriEnd);
        return SkinStyleSheetParserUtils.trimQuotes(uri);
    }

    private static String _wrapWithURLString(String uri) {
        StringBuilder builder = new StringBuilder(5 + uri.length());
        builder.append("url(");
        builder.append(uri);
        builder.append(")");
        return builder.toString();
    }

    private static class ResolvedSkinProperties {
        private Set<String> _inhibitedPropertySet;
        private List<PropertyNode> _noTrPropertyList;
        private List<String> _trRuleRefList;
        private List<IncludePropertyNode> _includedPropertiesList;
        private List<IncludeCompactPropertyNode> _includedCompactPropertiesList;
        private List<PropertyNode> _skinPropertyNodeList;
        private boolean _trTextAntialias;

        ResolvedSkinProperties(List<PropertyNode> noTrPropertyList, List<String> trRuleRefList, List<IncludePropertyNode> includedPropertiesList, List<IncludeCompactPropertyNode> includedCompactPropertiesList, Set<String> inhibitedPropertySet, List<PropertyNode> skinPropertyNodeList, boolean trTextAntialias) {
            this._noTrPropertyList = noTrPropertyList;
            this._trRuleRefList = trRuleRefList;
            this._includedPropertiesList = includedPropertiesList;
            this._includedCompactPropertiesList = includedCompactPropertiesList;
            this._inhibitedPropertySet = inhibitedPropertySet;
            this._skinPropertyNodeList = skinPropertyNodeList;
            this._trTextAntialias = trTextAntialias;
        }

        public List<PropertyNode> getNoTrPropertyList() {
            return this._noTrPropertyList;
        }

        public List<String> getTrRuleRefList() {
            return this._trRuleRefList;
        }

        public List<IncludePropertyNode> getIncludedPropertiesList() {
            return this._includedPropertiesList;
        }

        public List<IncludeCompactPropertyNode> getIncludedCompactPropertiesList() {
            return this._includedCompactPropertiesList;
        }

        public List<PropertyNode> getSkinPropertyNodeList() {
            return this._skinPropertyNodeList;
        }

        public Set<String> getInhibitedProperties() {
            return this._inhibitedPropertySet;
        }

        public boolean isTrTextAntialias() {
            return this._trTextAntialias;
        }
    }
}

