/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.agent.parse;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilitiesNode;
import org.apache.myfaces.trinidadinternal.agent.parse.CapabilityDataDocumentParser;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceComponentNode;
import org.apache.myfaces.trinidadinternal.agent.parse.DeviceNode;
import org.apache.myfaces.trinidadinternal.agent.parse.IncludeNode;

public class CapabilitiesDocument {
    private CapabilitiesNode[] _agents;
    private DeviceNode[] _devices;
    private HashMap<URL, Object> _includeNodeBySrcCaps;
    private Object[][] _defaultAgentCapabilities;
    static final CapabilitiesDocument EMPTY_DOCUMENT = new CapabilitiesDocument();
    private static TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(CapabilitiesDocument.class);

    CapabilitiesDocument(CapabilitiesNode[] agents, DeviceNode[] devices) {
        this._agents = agents;
        this._devices = devices;
        this._includeNodeBySrcCaps = new HashMap();
        this._defaultAgentCapabilities = this._getDefaultAgentCapabilities(this._agents);
    }

    private CapabilitiesDocument() {
        this(null, null);
    }

    public Object[][] getCapabilities(Agent agent) {
        DeviceNode dNode;
        Object[][] agentCaps = null;
        CapabilitiesNode agentMatchedNode = this._getAgentCapabiltiesNode(agent);
        if (agentMatchedNode != null) {
            agentCaps = this._getCapabilities(agent, this._agents, null, agentMatchedNode);
        }
        if ((dNode = this._getDeviceNode(agent)) != null) {
            DeviceComponentNode[] cNodes = dNode.__getComponents();
            if (cNodes == null) {
                return agentCaps;
            }
            Object[][][] deviceCaps = new Object[cNodes.length][][];
            for (int i = 0; i < cNodes.length; ++i) {
                deviceCaps[i] = cNodes[i].__getType() == DeviceComponentNode.TYPE_BROWSER && agent.getAgentName() != null ? agentCaps : this._getCapabilities(agent, this._agents, cNodes[i]);
            }
            return this._mergeCaps(deviceCaps, null);
        }
        if (agentCaps != null) {
            return agentCaps;
        }
        return this._defaultAgentCapabilities;
    }

    private Object[][] _getDefaultAgentCapabilities(CapabilitiesNode[] agents) {
        if (this._agents == null) {
            return null;
        }
        for (int i = 0; i < this._agents.length; ++i) {
            if (!agents[i].__isDefault()) continue;
            return this._getCapabilities(null, this._agents, null, this._agents[i]);
        }
        return null;
    }

    private CapabilitiesNode _getAgentCapabiltiesNode(Agent agent) {
        if (this._agents == null) {
            return null;
        }
        double maxScore = 0.0;
        CapabilitiesNode agentMatchedNode = null;
        for (int i = 0; i < this._agents.length; ++i) {
            double score = this._agents[i].__matches(agent);
            if (!(score > 0.0) || !(score > maxScore)) continue;
            maxScore = score;
            agentMatchedNode = this._agents[i];
        }
        return agentMatchedNode;
    }

    private DeviceNode _getDeviceNode(Agent agent) {
        if (this._devices == null) {
            return null;
        }
        double maxScore = 0.0;
        DeviceNode deviceNode = null;
        for (int i = 0; i < this._devices.length; ++i) {
            double score = this._devices[i].__matches(agent);
            if (!(score > 0.0) || !(score > maxScore)) continue;
            maxScore = score;
            deviceNode = this._devices[i];
        }
        return deviceNode;
    }

    private Object[][] _getCapabilities(Agent agent, CapabilitiesNode[] capNodes, List<String> includedByRefs, CapabilitiesNode matchNode) {
        assert (matchNode != null);
        if (capNodes == null) {
            return new Object[0][0];
        }
        if (includedByRefs == null) {
            includedByRefs = new ArrayList<String>();
        }
        if (matchNode.__getId() != null) {
            if (includedByRefs.contains(matchNode.__getId())) {
                _LOG.warning("INVALID_DEPENDENCY");
                return new Object[0][0];
            }
            includedByRefs.add(matchNode.__getId());
        }
        IncludeNode[] refIncludes = matchNode.__getIncludesByRef();
        Object[][][] refCaps = null;
        if (refIncludes != null) {
            refCaps = new Object[refIncludes.length][][];
            for (int i = 0; i < refIncludes.length; ++i) {
                assert (refIncludes[i].__getRefId() != null);
                refCaps[i] = this._getCapabilities(agent, capNodes, includedByRefs, refIncludes[i].__getRefId());
            }
        }
        IncludeNode[] uriIncludes = matchNode.__getIncludesByUri();
        Object[][] uriCaps = null;
        if (uriIncludes != null) {
            uriCaps = new Object[uriIncludes.length][];
            for (int i = 0; i < uriIncludes.length; ++i) {
                assert (uriIncludes[i].__getSrcUrl() != null);
                uriCaps[i] = this._getCapabilities(uriIncludes[i].__getSrcUrl());
                assert (uriCaps[i] != null);
            }
        }
        return this._mergeCaps(refCaps, uriCaps);
    }

    private Object[][] _getCapabilities(Agent agent, CapabilitiesNode[] capNodes, DeviceComponentNode dcNode) {
        assert (capNodes != null);
        assert (dcNode != null);
        ArrayList<String> includedByRefs = new ArrayList<String>();
        IncludeNode[] refIncludes = dcNode.__getIncludesByRef();
        Object[][][] refCaps = null;
        if (refIncludes != null) {
            refCaps = new Object[refIncludes.length][][];
            for (int i = 0; i < refIncludes.length; ++i) {
                assert (refIncludes[i].__getRefId() != null);
                refCaps[i] = this._getCapabilities(agent, capNodes, includedByRefs, refIncludes[i].__getRefId());
            }
        }
        IncludeNode[] uriIncludes = dcNode.__getIncludesByUri();
        Object[][] uriCaps = null;
        if (uriIncludes != null) {
            uriCaps = new Object[uriIncludes.length][];
            for (int i = 0; i < uriIncludes.length; ++i) {
                assert (uriIncludes[i].__getSrcUrl() != null);
                uriCaps[i] = this._getCapabilities(uriIncludes[i].__getSrcUrl());
                assert (uriCaps[i] != null);
            }
        }
        return this._mergeCaps(refCaps, uriCaps);
    }

    private Object[][] _getCapabilities(Agent agent, CapabilitiesNode[] capNodes, List<String> includedByRefs, String refId) {
        assert (capNodes != null);
        assert (refId != null);
        assert (includedByRefs != null);
        for (int i = 0; i < capNodes.length; ++i) {
            if (!refId.equals(capNodes[i].__getId())) continue;
            Object[][] caps = this._getCapabilities(agent, capNodes, includedByRefs, capNodes[i]);
            return caps;
        }
        _LOG.warning("REFERENCE_ID_NOT_FOUND", (Object)refId);
        return new Object[0][0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] _getCapabilities(URL srcUrl) {
        Object o = this._includeNodeBySrcCaps.get(srcUrl);
        if (o != null) {
            return (Object[])o;
        }
        Object[] caps = null;
        HashMap<URL, Object> hashMap = this._includeNodeBySrcCaps;
        synchronized (hashMap) {
            caps = CapabilityDataDocumentParser.parse(srcUrl);
            this._includeNodeBySrcCaps.put(srcUrl, caps);
        }
        return caps;
    }

    private Object[][] _mergeCaps(Object[][][] caps1, Object[][] caps2) {
        if (caps1 == null) {
            return caps2;
        }
        int len = 0;
        for (int i = 0; i < caps1.length; ++i) {
            len += caps1[i].length;
        }
        Object[][] merged = new Object[len + (caps2 == null ? 0 : caps2.length)][];
        len = 0;
        for (int i = 0; i < caps1.length; ++i) {
            System.arraycopy(caps1[i], 0, merged, len, caps1[i].length);
            len += caps1[i].length;
        }
        if (caps2 != null) {
            System.arraycopy(caps2, 0, merged, len, caps2.length);
        }
        return merged;
    }
}

