/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.xml.parse;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.xml.parse.ImageParseUtils;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class FontParser
extends BaseNodeParser {
    private String _name;
    private int _style = -1;
    private int _size = -1;
    private static final String _DEFAULT_FONT_NAME = "dialog";
    private static final int _DEFAULT_FONT_SIZE = 10;
    private static final int _DEFAULT_FONT_STYLE = 0;
    private static final String _SIZE_ERROR = "Error while parsing font size value.  Font size must be an integer.";
    private static final String _STYLE_ERROR = "Error while parsing font style value.  Valid values are \"plain\", \"bold\" or \"italic\"";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FontParser.class);

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) throws SAXParseException {
        String style;
        this._name = attrs.getValue("name");
        Integer size = ImageParseUtils.getIntegerAttributeValue(context, attrs, "size");
        if (size != null) {
            this._size = size;
        }
        if ((style = attrs.getValue("style")) != null) {
            this._style = this._parseStyle(style);
        }
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        String name = this._name == null ? _DEFAULT_FONT_NAME : this._name;
        int size = this._size == -1 ? 10 : this._size;
        int style = this._style == -1 ? 0 : this._style;
        return new FontProxy(name, style, size);
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("name") || localName.equals("size") || localName.equals("style")) {
            return context.getParser(String.class, namespaceURI, localName);
        }
        return null;
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        int style;
        String value = FontParser._stripWhitespace((String)child);
        if (localName.equals("name")) {
            this._name = value;
        } else if (localName.equals("size")) {
            this._size = this._parseSize(value);
        } else if (localName.equals("style") && (style = this._parseStyle(value)) != -1) {
            this._style = this._style == -1 ? style : (this._style |= style);
        }
    }

    private int _parseSize(String value) {
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            _LOG.warning(_SIZE_ERROR);
            return -1;
        }
    }

    private int _parseStyle(String value) {
        if (value == null) {
            return -1;
        }
        if (value.equalsIgnoreCase("plain")) {
            return 0;
        }
        if (value.equalsIgnoreCase("italic")) {
            return 2;
        }
        if (value.equalsIgnoreCase("bold")) {
            return 1;
        }
        _LOG.warning(_STYLE_ERROR);
        return -1;
    }

    private static String _stripWhitespace(String str) {
        int endIndex;
        int startIndex;
        if (str == null) {
            return null;
        }
        int length = str.length();
        for (startIndex = 0; startIndex < length && Character.isWhitespace(str.charAt(startIndex)); ++startIndex) {
        }
        for (endIndex = length; endIndex > 0 && Character.isWhitespace(str.charAt(endIndex - 1)); --endIndex) {
        }
        if (startIndex == 0 && endIndex == length) {
            return str;
        }
        return str.substring(startIndex, endIndex);
    }
}

