/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.SpecialColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class FocusColumnRenderer
extends SpecialColumnRenderer {
    @Override
    protected String getHeaderText(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        return arc.getTranslatedString("af_treeTable.FOCUS_COLUMN_HEADER");
    }

    @Override
    protected String getHeaderStyleClass(TableRenderingContext tContext) {
        return "af|column::header-icon-format";
    }

    @Override
    protected String getFormatType(UIComponent component, FacesBean bean) {
        return "center";
    }

    @Override
    protected void renderKids(FacesContext context, RenderingContext rc, TableRenderingContext trc, UIComponent column) throws IOException {
        TreeTableRenderingContext ttrc = (TreeTableRenderingContext)trc;
        ResponseWriter writer = context.getResponseWriter();
        UIXTreeTable hGrid = ttrc.getUIXTreeTable();
        Object focusRowKey = hGrid.getFocusRowKey();
        assert (focusRowKey != null);
        int focusPathSize = hGrid.getDepth(focusRowKey) + 1;
        if (hGrid.isContainer() && hGrid.getDepth() >= focusPathSize) {
            writer.startElement("a", null);
            if (FocusColumnRenderer.supportsNavigation(rc)) {
                String onclick = TreeUtils.callJSFocusNode((UIXHierarchy)hGrid, ttrc.getJSVarName());
                writer.writeURIAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            this._renderFocusIcon(context, rc, rc.getTranslatedString("af_treeTable.FOCUS_TIP"));
            writer.endElement("a");
        }
    }

    private void _renderFocusIcon(FacesContext facesContext, RenderingContext rc, String altText) throws IOException {
        Icon icon = rc.getIcon("af|treeTable::focus-icon");
        if (icon != null) {
            OutputUtils.renderIcon(facesContext, rc, icon, altText, null, true);
        }
    }
}

