/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidad.util.URLUtils;
import org.apache.myfaces.trinidadinternal.application.InternalViewHandlingStrategy;
import org.apache.myfaces.trinidadinternal.context.TrinidadPhaseListener;
import org.apache.myfaces.trinidadinternal.skin.pregen.SkinPregenerationService;

public class ViewHandlerImpl
extends ViewHandlerWrapper {
    public static final String ALTERNATE_VIEW_HANDLER = "org.apache.myfaces.trinidad.ALTERNATE_VIEW_HANDLER";
    private Boolean _checkTimestamp;
    private ViewHandler _delegate;
    private final Map<String, Long> _timestamps;
    private boolean _inited;
    private final boolean _skinPregenerationEnabled;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ViewHandlerImpl.class);
    private static final Long _NOT_FOUND = 0L;
    private static final String _RENDER_VIEW_MARKER = "__trRenderViewEntry";

    public ViewHandlerImpl(ViewHandler delegate) {
        this._delegate = delegate;
        this._timestamps = new HashMap<String, Long>();
        this._skinPregenerationEnabled = SkinPregenerationService.isEnabled();
    }

    public ViewHandler getWrapped() {
        return this._delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot createView(FacesContext context, String viewId) {
        this._checkSkinPregeneration(context, viewId);
        this._initIfNeeded(context);
        if (this._checkTimestamp(context, viewId)) {
            try {
                String path = ViewHandlerImpl._getPath(viewId);
                Map<String, Long> map = this._timestamps;
                synchronized (map) {
                    Long ts = this._timestamps.get(path);
                    if (ts != _NOT_FOUND) {
                        URL url = context.getExternalContext().getResource(path);
                        Long modified = this._getLastModified(url);
                        this._timestamps.put(path, modified);
                    }
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
        }
        return super.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        String actionURL = super.getActionURL(context, viewId);
        RequestContext afContext = RequestContext.getCurrentInstance();
        if (afContext != null) {
            actionURL = afContext.getPageResolver().encodeActionURI(actionURL);
            actionURL = afContext.getPageFlowScopeProvider().encodeCurrentPageFlowScopeURL(context, actionURL);
        }
        return actionURL;
    }

    public String getResourceURL(FacesContext context, String path) {
        return super.getResourceURL(context, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        this._initIfNeeded(context);
        Map reqMap = context.getExternalContext().getRequestMap();
        if (reqMap.get(_RENDER_VIEW_MARKER) != null) {
            _LOG.warning("DUPLICATE_VIEWHANDLER_REGISTRATION");
        } else {
            reqMap.put(_RENDER_VIEW_MARKER, Boolean.TRUE);
        }
        ExtendedRenderKitService service = this._getExtendedRenderKitService(context);
        if (service == null || !service.shortCircuitRenderView(context)) {
            try {
                if (service != null) {
                    service.encodeBegin(context);
                }
                super.renderView(context, viewToRender);
                if (service != null) {
                    service.encodeEnd(context);
                }
            }
            finally {
                if (service != null) {
                    service.encodeFinally(context);
                }
            }
        }
        reqMap.remove(_RENDER_VIEW_MARKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (context.getExternalContext().getRequestMap().get("org.apache.myfaces.trinidad.PageFlowSourceView") != null) {
            return super.restoreView(context, viewId);
        }
        boolean uptodate = true;
        if (this._checkTimestamp(context, viewId)) {
            try {
                String path = ViewHandlerImpl._getPath(viewId);
                Map<String, Long> map = this._timestamps;
                synchronized (map) {
                    Long ts = this._timestamps.get(path);
                    if (ts != _NOT_FOUND) {
                        URL url = context.getExternalContext().getResource(path);
                        Long modified = this._getLastModified(url);
                        if (modified == _NOT_FOUND) {
                            this._timestamps.put(path, _NOT_FOUND);
                        } else if (ts == null || modified > ts) {
                            this._timestamps.put(path, modified);
                            if (ts != null) {
                                _LOG.fine("View document \"" + path + "\" has been modified, " + "ignoring postback for view \"" + viewId + "\"");
                            }
                            uptodate = false;
                        }
                    }
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
        }
        if (!uptodate) {
            return null;
        }
        UIViewRoot result = super.restoreView(context, viewId);
        if (result != null) {
            TrinidadPhaseListener.markPostback(context);
        }
        return result;
    }

    public void writeState(FacesContext context) throws IOException {
        InternalViewHandlingStrategy strategy;
        String viewId = context.getViewRoot().getViewId();
        ViewDeclarationLanguage vdl = this.getViewDeclarationLanguage(context, viewId);
        if (vdl instanceof InternalViewHandlingStrategy && (strategy = (InternalViewHandlingStrategy)vdl).__isStateless(context, viewId)) {
            return;
        }
        ExtendedRenderKitService service = this._getExtendedRenderKitService(context);
        if (service != null && service.isStateless(context)) {
            return;
        }
        super.writeState(context);
    }

    private synchronized void _initIfNeeded(FacesContext context) {
        if (!this._inited) {
            this._inited = true;
            String alternateViewHandler = context.getExternalContext().getInitParameter(ALTERNATE_VIEW_HANDLER);
            if (alternateViewHandler != null) {
                ViewHandler viewHandlerInstance = null;
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = loader.loadClass(alternateViewHandler);
                    try {
                        Constructor<?> constructor = c.getConstructor(ViewHandler.class);
                        viewHandlerInstance = (ViewHandler)constructor.newInstance(this._delegate);
                    }
                    catch (NoSuchMethodException nsme) {
                        viewHandlerInstance = (ViewHandler)c.newInstance();
                    }
                }
                catch (Exception e) {
                    _LOG.warning("CANNOT_LOAD_VIEWHANDLER", (Object)alternateViewHandler);
                    _LOG.warning((Throwable)e);
                }
                if (viewHandlerInstance != null) {
                    this._delegate = viewHandlerInstance;
                }
            }
        }
    }

    private ExtendedRenderKitService _getExtendedRenderKitService(FacesContext context) {
        return (ExtendedRenderKitService)Service.getService((Object)context.getRenderKit(), ExtendedRenderKitService.class);
    }

    private boolean _checkTimestamp(FacesContext context, String viewId) {
        boolean check;
        if (this._checkTimestamp == null) {
            String checkTimestamp = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
            boolean checkTimestampParam = checkTimestamp != null ? "true".equals(checkTimestamp) : !context.isProjectStage(ProjectStage.Production);
            boolean developmentStage = context.isProjectStage(ProjectStage.Development);
            boolean productionStage = developmentStage || context.isProjectStage(ProjectStage.Production);
            boolean performCheck = checkTimestampParam || developmentStage;
            this._checkTimestamp = performCheck;
            if (checkTimestampParam) {
                if (productionStage) {
                    _LOG.warning("TIMESTAMP_CHECKING_ENABLED_SHOULDNOT_IN_PRODUCTION", (Object)"org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
                } else {
                    _LOG.info("TIMESTAMP_CHECKING_ENABLED_SHOULDNOT_IN_PRODUCTION", (Object)"org.apache.myfaces.trinidad.CHECK_FILE_MODIFICATION");
                }
            }
        }
        if ((check = this._checkTimestamp.booleanValue()) && this.getViewDeclarationLanguage(context, viewId) instanceof InternalViewHandlingStrategy) {
            return false;
        }
        return check;
    }

    private static String _getPath(String uri) {
        RequestContext afc = RequestContext.getCurrentInstance();
        if (afc != null) {
            return afc.getPageResolver().getPhysicalURI(uri);
        }
        return uri;
    }

    private Long _getLastModified(URL url) throws IOException {
        if (url == null) {
            return _NOT_FOUND;
        }
        return URLUtils.getLastModified((URL)url);
    }

    private void _checkSkinPregeneration(FacesContext context, String viewId) {
        if (this._skinPregenerationEnabled && !SkinPregenerationService.isPregenerationRequest(viewId)) {
            ExternalContext external = context.getExternalContext();
            String message = _LOG.getMessage("SKIN_PREGEN_ENABLED");
            _LOG.severe(message);
            ViewHandlerImpl._sendError(external, message);
            context.responseComplete();
        }
    }

    private static void _sendError(ExternalContext external, String message) {
        try {
            external.responseSendError(500, message);
        }
        catch (IOException e) {
            _LOG.warning((Throwable)e);
        }
    }
}

