/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveFacetComponentChange
extends ComponentChange
implements DocumentChange {
    private final String _facetName;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RemoveFacetComponentChange.class);
    private static final long serialVersionUID = 1L;

    public RemoveFacetComponentChange(String facetName) {
        if (facetName == null || facetName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_CONSTRUCT_REMOVEFACETCHANGE_WITH_NULL_FACETNAME"));
        }
        this._facetName = facetName;
    }

    public String getFacetName() {
        return this._facetName;
    }

    @Override
    public void changeComponent(UIComponent uiComponent) {
        Map facets = uiComponent.getFacets();
        facets.remove(this._facetName);
    }

    @Override
    public void changeDocument(Node componentNode) {
        Element facetElement = ChangeUtils.__getFacetElement(componentNode, this._facetName);
        if (facetElement != null) {
            componentNode.removeChild(facetElement);
        }
    }

    @Override
    public boolean getForcesDocumentReload() {
        return false;
    }
}

