/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.text.BreakIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputText;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleInputTextRenderer
extends FormInputRenderer {
    private PropertyKey _columnsKey;
    private PropertyKey _rowsKey;
    private PropertyKey _wrapKey;
    private PropertyKey _secretKey;
    private PropertyKey _maximumLengthKey;
    private PropertyKey _autoCompleteKey;
    private PropertyKey _onselectKey;
    private static final Integer _DEFAULT_PDA_COLUMNS = 11;
    private static final Integer _DEFAULT_COLUMNS = 30;
    private static final String _SECRET_KEYDOWN_SCRIPT = "return _clearPassword(this, event);";
    private static final int _MAX_COLUMNS = 500;
    private static final int _MAX_ROWS = 500;

    public SimpleInputTextRenderer() {
        this(CoreInputText.TYPE);
    }

    public SimpleInputTextRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._columnsKey = type.findKey("columns");
        this._rowsKey = type.findKey("rows");
        this._wrapKey = type.findKey("wrap");
        this._secretKey = type.findKey("secret");
        this._maximumLengthKey = type.findKey("maximumLength");
        this._autoCompleteKey = type.findKey("autoComplete");
        this._onselectKey = type.findKey("onselect");
    }

    @Override
    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        Object submitted = super.getSubmittedValue(context, component, clientId);
        if (submitted == null || "".equals(submitted)) {
            return submitted;
        }
        FacesBean bean = this.getFacesBean(component);
        if (this.getSecret(component, bean)) {
            if ("******".equals(submitted)) {
                return this.getSubmittedValue(component, bean);
            }
        } else if (this.isTextArea(component, bean)) {
            submitted = SimpleInputTextRenderer._normalizeWhitespace((String)submitted);
        }
        return submitted;
    }

    @Override
    protected void encodeAllAsElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.isAutoSubmit(component, bean)) {
            AutoSubmitUtils.writeDependencies(context, rc);
        }
        ResponseWriter rw = context.getResponseWriter();
        this.addOnSubmitConverterValidators(context, rc, component, bean);
        if (this.isSimpleInputText(component, bean)) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, rc, component, bean);
        }
        if (this.isTextArea(component, bean)) {
            rw.startElement("textarea", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, rc, component, bean, false);
            this.renderContent(context, rc, component, bean, true, true);
            rw.endElement("textarea");
        } else {
            rw.startElement("input", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, rc, component, bean, false);
            String value = this.getConvertedString(context, component, bean);
            boolean secret = this.getSecret(component, bean);
            if (secret) {
                rw.writeAttribute("type", (Object)"password", "secret");
                if (value != null && !"".equals(value)) {
                    value = "******";
                }
            } else {
                rw.writeAttribute("type", (Object)this.getDefaultInputType(), null);
            }
            rw.writeAttribute("value", (Object)value, "value");
            rw.endElement("input");
        }
        if (this.isHiddenLabelRequired(rc)) {
            this.renderShortDescAsHiddenLabel(context, rc, component, bean);
        }
        if (this.isSimpleInputText(component, bean)) {
            rw.endElement("span");
        }
    }

    @Override
    protected void renderAllAttributes(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean renderStyleAttrs) throws IOException {
        int intCol;
        super.renderAllAttributes(context, rc, component, bean, false);
        ResponseWriter rw = context.getResponseWriter();
        boolean isTextArea = this.isTextArea(component, bean);
        Number columns = this.getColumns(component, bean);
        if (columns == null) {
            columns = this.getDefaultColumns(rc, component, bean);
        } else if (columns instanceof Number && (intCol = columns.intValue()) > 500) {
            intCol = 500;
            columns = intCol;
        }
        rw.writeAttribute(isTextArea ? "cols" : "size", (Object)columns, "columns");
        if (isTextArea) {
            int intRow;
            Number rows = this.getRows(component, bean);
            if (rows == null) {
                rows = this.getDefaultRows();
            } else if (rows instanceof Number && (intRow = rows.intValue()) > 500) {
                rows = 500;
            }
            rw.writeAttribute("rows", (Object)rows, "rows");
            rw.writeAttribute("wrap", this.getWrap(component, bean), "wrap");
            if ((this.getReadOnly(context, component, bean) || !SimpleInputTextRenderer.supportsEditing(rc)) && SimpleInputTextRenderer.supportsReadonlyFormElements(rc)) {
                rw.writeAttribute("readonly", (Object)Boolean.TRUE, "readOnly");
            }
        } else {
            Number maximumLength;
            String autocomplete;
            if (SimpleInputTextRenderer.supportsAutoCompleteFormElements(rc) && (autocomplete = this.getAutoComplete(component, bean)).equalsIgnoreCase("off")) {
                rw.writeAttribute("autocomplete", (Object)"off", "autoComplete");
            }
            if ((maximumLength = this.getMaximumLength(component, bean)) != null && maximumLength.intValue() > 0) {
                rw.writeAttribute("maxlength", (Object)maximumLength, "maximumLength");
            }
        }
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|inputText";
    }

    protected int getDefaultRows() {
        return 5;
    }

    protected Integer getDefaultColumns(RenderingContext rc, UIComponent component, FacesBean bean) {
        if (SimpleInputTextRenderer.isPDA((RenderingContext)rc)) {
            return _DEFAULT_PDA_COLUMNS;
        }
        return _DEFAULT_COLUMNS;
    }

    protected String getDefaultInputType() {
        return "text";
    }

    @Override
    protected void renderEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        super.renderEventHandlers(context, component, bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.writeAttribute("onselect", (Object)this.getOnselect(component, bean), "onselect");
        rw.writeAttribute("onpaste", (Object)this.getOnpaste(component, bean), "onpaste");
    }

    @Override
    protected void encodeAllAsNonElement(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (this.isTextArea(component, bean)) {
            this.renderContent(context, rc, component, bean, false, true);
        } else {
            ResponseWriter rw = context.getResponseWriter();
            boolean isSimple = this.isSimpleInputText(component, bean);
            if (isSimple) {
                rw.startElement("span", component);
                this.renderRootDomElementStyles(context, rc, component, bean);
                this.renderId(context, component);
            }
            rw.startElement("div", component);
            if (!isSimple) {
                this.renderId(context, component);
            }
            SimpleInputTextRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)this.getContentStyleClass(component, bean));
            SimpleInputTextRenderer.renderInlineStyleAttribute(context, rc, component, this.getContentStyle(component, bean));
            rw.writeAttribute("title", (Object)this.getShortDesc(component, bean), "shortDesc");
            this.renderContent(context, rc, component, bean, false, false);
            rw.endElement("div");
            if (this.isSimpleInputText(component, bean)) {
                rw.endElement("span");
            }
        }
    }

    @Override
    protected void renderNonElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        throw new IllegalStateException("UNUSED");
    }

    protected void renderContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, boolean renderAsElement, boolean isTextArea) throws IOException {
        String textValue = this.getConvertedString(context, component, bean);
        if (textValue == null || "".equals(textValue)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        if (isTextArea) {
            if (!renderAsElement) {
                String textString;
                int textLength;
                rw.startElement("pre", component);
                this.renderId(context, component);
                rw.writeAttribute("title", (Object)this.getShortDesc(component, bean), "shortDesc");
                this.renderStyleAttributes(context, rc, component, bean, this.getContentStyleClass(component, bean));
                if (textValue != null && (textLength = (textString = textValue).length()) > 0) {
                    Object wrap = this.getWrap(component, bean);
                    if ("soft".equals(wrap) || "hard".equals(wrap)) {
                        int columns;
                        Number columnsObj = this.getColumns(component, bean);
                        if (columnsObj == null) {
                            columnsObj = this.getDefaultColumns(rc, component, bean);
                        }
                        int n = columns = columnsObj == null ? 0 : columnsObj.intValue();
                        if (columns <= 1 || columns > textLength) {
                            rw.writeText((Object)textString, "value");
                        } else {
                            BreakIterator breaks = BreakIterator.getLineInstance(context.getViewRoot().getLocale());
                            breaks.setText(textString);
                            this._writeTextWithBreaks(context, breaks, textString, columns);
                        }
                    } else {
                        rw.writeText((Object)textString, "value");
                    }
                }
                rw.endElement("pre");
            } else if (textValue != null) {
                rw.writeText((Object)textValue, "value");
            }
        } else if (!this.getSecret(component, bean) && textValue != null) {
            rw.writeText((Object)textValue, "value");
        }
    }

    private void _writeTextWithBreaks(FacesContext context, BreakIterator breaks, String textString, int columns) throws IOException {
        int start = 0;
        while (true) {
            int nextLineBreak;
            String substring = (nextLineBreak = textString.indexOf(10, start)) >= 0 ? textString.substring(start, nextLineBreak) : textString.substring(start);
            this._writeTextLineWithBreaks(context, breaks, substring, columns);
            if (nextLineBreak < 0) break;
            start = nextLineBreak + 1;
            char[] chars = new char[10];
            context.getResponseWriter().write(chars, 0, 1);
        }
    }

    private void _writeTextLineWithBreaks(FacesContext context, BreakIterator breaks, String textString, int columns) throws IOException {
        if (textString.length() < columns) {
            context.getResponseWriter().writeText((Object)textString, "value");
            return;
        }
        breaks.setText(textString);
        int lastStart = 0;
        int previous = 0;
        while (true) {
            int next;
            if ((next = breaks.next()) == -1) break;
            if (next - lastStart > columns) {
                if (previous == lastStart) {
                    previous = next;
                }
                String sub = textString.substring(lastStart, previous);
                char[] chars = new char[10];
                context.getResponseWriter().writeText((Object)sub, null);
                context.getResponseWriter().write(chars, 0, 1);
                lastStart = previous;
            }
            previous = next;
        }
        context.getResponseWriter().writeText((Object)textString.substring(lastStart), null);
    }

    @Override
    protected String getOnkeyup(UIComponent component, FacesBean bean) {
        Number maximumLength;
        String onKeyUp = super.getOnkeyup(component, bean);
        if (this.isTextArea(component, bean) && (maximumLength = this.getMaximumLength(component, bean)) != null && maximumLength.intValue() > 0) {
            onKeyUp = SimpleInputTextRenderer._getMaxLengthFunction(onKeyUp, maximumLength.intValue());
        }
        return onKeyUp;
    }

    @Override
    protected String getOnkeydown(UIComponent component, FacesBean bean) {
        String onKeydown = super.getOnkeydown(component, bean);
        if (this.getSecret(component, bean)) {
            onKeydown = XhtmlUtils.getChainedJS(_SECRET_KEYDOWN_SCRIPT, onKeydown, false);
        }
        return onKeydown;
    }

    @Override
    protected String getOnfocus(UIComponent component, FacesBean bean) {
        RenderingContext arc;
        String onfocus = super.getOnfocus(component, bean);
        if (this.isTextArea(component, bean) && this.getReadOnly(FacesContext.getCurrentInstance(), component, bean) && !SimpleInputTextRenderer.supportsReadonlyFormElements(arc = RenderingContext.getCurrentInstance())) {
            onfocus = XhtmlUtils.getChainedJS("this.blur()", onfocus, true);
        }
        return onfocus;
    }

    @Override
    protected String getOnchange(UIComponent component, FacesBean bean) {
        Number maxLength;
        String onchange = super.getOnchange(component, bean);
        if (this.isAutoSubmit(component, bean)) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            String source = LabelAndMessageRenderer.__getCachedClientId(rc);
            boolean immediate = this.isImmediate(component, bean);
            String auto = AutoSubmitUtils.getSubmitScript(rc, source, "autosub", immediate);
            if (onchange == null) {
                onchange = auto;
            } else if (auto != null) {
                onchange = XhtmlUtils.getChainedJS(onchange, auto, true);
            }
        }
        if (this.isTextArea(component, bean) && (maxLength = this.getMaximumLength(component, bean)) != null && maxLength.intValue() > 0) {
            onchange = SimpleInputTextRenderer._getMaxLengthFunction(onchange, maxLength.intValue());
        }
        return onchange;
    }

    protected String getOnpaste(UIComponent component, FacesBean bean) {
        Number maximumLength;
        String onpaste = null;
        if (this.isTextArea(component, bean) && (maximumLength = this.getMaximumLength(component, bean)) != null && maximumLength.intValue() > 0) {
            onpaste = SimpleInputTextRenderer._getMaxLengthFunction(null, maximumLength.intValue());
        }
        return XhtmlUtils.getClientEventHandler(FacesContext.getCurrentInstance(), component, "paste", null, null, onpaste);
    }

    protected String getOnselect(UIComponent component, FacesBean bean) {
        if (this._onselectKey == null) {
            return null;
        }
        return XhtmlUtils.getClientEventHandler(FacesContext.getCurrentInstance(), component, "select", null, SimpleInputTextRenderer.toString((Object)bean.getProperty(this._onselectKey)), null);
    }

    protected Number getColumns(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._columnsKey);
    }

    protected Number getRows(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    protected Number getMaximumLength(UIComponent component, FacesBean bean) {
        return (Number)bean.getProperty(this._maximumLengthKey);
    }

    protected Object getWrap(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._wrapKey);
    }

    protected boolean getSecret(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._secretKey);
        if (o == null) {
            o = this._secretKey.getDefault();
        }
        assert (o != null);
        return !Boolean.FALSE.equals(o);
    }

    public boolean isTextArea(UIComponent component, FacesBean bean) {
        Number rows = this.getRows(component, bean);
        return rows != null && rows.intValue() > 1;
    }

    @Override
    protected boolean renderReadOnlyAsElement(RenderingContext rc, UIComponent component, FacesBean bean) {
        if (!this.isTextArea(component, bean)) {
            return false;
        }
        return SimpleInputTextRenderer.supportsReadonlyFormElements(rc);
    }

    protected String getAutoComplete(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._autoCompleteKey);
        if (o == null) {
            o = this._autoCompleteKey.getDefault();
        }
        return o.toString();
    }

    protected boolean isSimpleInputText(UIComponent component, FacesBean bean) {
        return this.getSimple(component, bean);
    }

    private static String _getMaxLengthFunction(String userFunc, int length) {
        String functionCall = "return _checkLength(this," + IntegerUtils.getString((int)length) + ",event)";
        if (userFunc == null) {
            return functionCall;
        }
        return XhtmlUtils.getChainedJS(functionCall, userFunc, true);
    }

    private static final String _normalizeWhitespace(String str) {
        int rIndex;
        int from = 0;
        int length = str.length();
        StringBuffer buffer = null;
        do {
            if ((rIndex = str.indexOf(13, from)) < 0) {
                if (from == 0) {
                    return str;
                }
                assert (buffer != null);
                buffer.append(str.substring(from));
                return buffer.toString();
            }
            if (buffer == null) {
                buffer = new StringBuffer(length);
            }
            buffer.append(str.substring(from, rIndex));
            if (rIndex > 0 && str.charAt(rIndex - 1) == '\n' || rIndex + 1 < length && str.charAt(rIndex + 1) == '\n') continue;
            buffer.append('\n');
        } while ((from = rIndex + 1) < length);
        assert (buffer != null);
        return buffer.toString();
    }
}

