/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.myfaces.trinidad.util.Args;

public final class CopyOnWriteArrayMap<K, V>
implements ConcurrentMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient EntryFactory<ConcurrentEntry<K, V>, K, V> _entryFactory;
    private final transient ReentrantLock _writeLock;
    private volatile transient ConcurrentEntry<K, V>[] _entries;

    public static <K, V> CopyOnWriteArrayMap<K, V> newConcurrentMap() {
        ConcurrentEntryFactory factory = ConcurrentEntryFactory.getInstance();
        return new CopyOnWriteArrayMap<K, V>(factory);
    }

    public static <K, V> CopyOnWriteArrayMap<K, V> newLRUConcurrentMap(int maxSize) {
        if (maxSize < 0) {
            maxSize = 0;
        }
        LRUEntryFactory entryFactory = new LRUEntryFactory(maxSize, System.nanoTime());
        return new CopyOnWriteArrayMap<K, V>(entryFactory);
    }

    private CopyOnWriteArrayMap(EntryFactory<?, K, V> entryFactory) {
        this(entryFactory, new ReentrantLock(), entryFactory.getEmptyEntries());
    }

    private CopyOnWriteArrayMap(EntryFactory<?, K, V> entryFactory, ReentrantLock writeLock, ConcurrentEntry<K, V>[] entries) {
        this._entryFactory = entryFactory;
        this._writeLock = writeLock;
        this._entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        V oldValue;
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            ConcurrentEntry<K, V>[] entries = this._entries;
            int entryIndex = CopyOnWriteArrayMap._getEntryIndex(entries, key);
            if (entryIndex >= 0) {
                ConcurrentEntry<K, V> entry = entries[entryIndex];
                oldValue = entry.getValue();
            } else {
                int insertIndex = -(entryIndex + 1);
                this._entries = CopyOnWriteArrayMap._insertEntryAt(entries, key, value, insertIndex, this._entryFactory);
                oldValue = null;
            }
        }
        finally {
            writeLock.unlock();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = false;
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            ConcurrentEntry<K, V>[] entries = this._entries;
            int removeIndex = CopyOnWriteArrayMap._getEntryIndex(entries, key);
            if (removeIndex >= 0) {
                boolean valuesEqual;
                ConcurrentEntry<K, V> entry = entries[removeIndex];
                V entryValue = entry.getValue();
                boolean bl = entryValue != null ? entryValue.equals(value) : (valuesEqual = value == null);
                if (valuesEqual) {
                    this._entries = CopyOnWriteArrayMap._removeEntryByIndex(entries, removeIndex);
                    removed = true;
                }
            }
        }
        finally {
            writeLock.unlock();
        }
        return removed;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        ConcurrentEntry<K, V>[] entries = this._entries;
        ConcurrentEntry<K, V> entry = CopyOnWriteArrayMap._getEntry(entries, key);
        if (entry != null) {
            return entry.compareAndSetValue(oldValue, newValue);
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        ConcurrentEntry<K, V>[] entries = this._entries;
        ConcurrentEntry<K, V> entry = CopyOnWriteArrayMap._getEntry(entries, key);
        if (entry != null) {
            return entry.setValue(value);
        }
        return null;
    }

    @Override
    public int size() {
        return this._entries.length;
    }

    @Override
    public boolean isEmpty() {
        return this._entries.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return CopyOnWriteArrayMap._getEntry(this._entries, key) != null;
    }

    private static <K, V> ConcurrentEntry<K, V> _getEntry(ConcurrentEntry<K, V>[] entries, Object key) {
        if (key == null) {
            return null;
        }
        int entryIndex = CopyOnWriteArrayMap._getEntryIndex(entries, key);
        if (entryIndex >= 0) {
            return entries[entryIndex];
        }
        return null;
    }

    private static <K, V> int _getHashCollsionMatchingEntryIndex(ConcurrentEntry<K, V>[] entries, Object key, int keyHashCode, int startIndex) {
        int afterIndex;
        int beforeIndex;
        for (beforeIndex = startIndex - 1; beforeIndex >= 0; --beforeIndex) {
            ConcurrentEntry<K, V> entry = entries[beforeIndex];
            if (keyHashCode != entry.keyHashCode) break;
            if (!key.equals(entry.getKey())) continue;
            return beforeIndex;
        }
        int entryCount = entries.length;
        for (afterIndex = startIndex + 1; afterIndex < entryCount; ++afterIndex) {
            ConcurrentEntry<K, V> entry = entries[afterIndex];
            if (keyHashCode != entry.keyHashCode) break;
            if (!key.equals(entry.getKey())) continue;
            return afterIndex;
        }
        int insertIndex = beforeIndex == -1 ? 0 : afterIndex;
        return -(insertIndex + 1);
    }

    private static <K, V> int _getEntryIndex(ConcurrentEntry<K, V>[] entries, Object key) {
        int keyHashCode = key.hashCode();
        int lowIndex = 0;
        int highIndex = entries.length - 1;
        while (lowIndex <= highIndex) {
            int midIndex = lowIndex + highIndex >>> 1;
            ConcurrentEntry<K, V> entry = entries[midIndex];
            int midVal = entry.keyHashCode;
            if (midVal < keyHashCode) {
                lowIndex = midIndex + 1;
                continue;
            }
            if (midVal > keyHashCode) {
                highIndex = midIndex - 1;
                continue;
            }
            if (key.equals(entry.getKey())) {
                return midIndex;
            }
            return CopyOnWriteArrayMap._getHashCollsionMatchingEntryIndex(entries, key, keyHashCode, midIndex);
        }
        return -(lowIndex + 1);
    }

    private static <K, V> ConcurrentEntry<K, V>[] _removeEntryByIndex(ConcurrentEntry<K, V>[] entries, int removeIndex) {
        int originalSize = entries.length;
        int newSize = originalSize - 1;
        ConcurrentEntry[] newEntries = (ConcurrentEntry[])Array.newInstance(entries.getClass().getComponentType(), newSize);
        if (removeIndex == 0 || removeIndex == newSize) {
            int srcStart = removeIndex == 0 ? 1 : 0;
            System.arraycopy(entries, srcStart, newEntries, 0, newSize);
        } else {
            System.arraycopy(entries, 0, newEntries, 0, removeIndex);
            System.arraycopy(entries, removeIndex + 1, newEntries, removeIndex, newSize - removeIndex);
        }
        return newEntries;
    }

    private static <K, V> ConcurrentEntry<K, V>[] _addEntryAtIndex(ConcurrentEntry<K, V>[] entries, ConcurrentEntry<K, V> entry, int insertIndex, int removeIndex) {
        int originalSize;
        int newSize = originalSize = entries.length;
        if (removeIndex < 0) {
            ++newSize;
        }
        ConcurrentEntry[] newEntries = (ConcurrentEntry[])Array.newInstance(entry.getClass(), newSize);
        if (removeIndex >= 0) {
            if (removeIndex == insertIndex) {
                System.arraycopy(entries, 0, newEntries, 0, originalSize);
            } else if (removeIndex < insertIndex) {
                System.arraycopy(entries, 0, newEntries, 0, removeIndex);
                System.arraycopy(entries, removeIndex + 1, newEntries, removeIndex, insertIndex - removeIndex - 1);
                if (insertIndex < originalSize) {
                    System.arraycopy(entries, insertIndex, newEntries, insertIndex, originalSize - insertIndex);
                }
                --insertIndex;
            } else {
                System.arraycopy(entries, 0, newEntries, 0, insertIndex);
                System.arraycopy(entries, insertIndex, newEntries, insertIndex + 1, removeIndex - insertIndex);
                int afterRemoveIndex = removeIndex + 1;
                if (afterRemoveIndex < originalSize) {
                    System.arraycopy(entries, afterRemoveIndex, newEntries, afterRemoveIndex, originalSize - afterRemoveIndex);
                }
            }
        } else if (insertIndex == 0 || insertIndex == originalSize) {
            int destStart = insertIndex == 0 ? 1 : 0;
            System.arraycopy(entries, 0, newEntries, destStart, originalSize);
        } else {
            System.arraycopy(entries, 0, newEntries, 0, insertIndex);
            System.arraycopy(entries, insertIndex, newEntries, insertIndex + 1, originalSize - insertIndex);
        }
        newEntries[insertIndex] = entry;
        return newEntries;
    }

    @Override
    public boolean containsValue(Object value) {
        return CopyOnWriteArrayMap._containsValue(this._entries, value);
    }

    private static boolean _containsValue(ConcurrentEntry[] entries, Object value) {
        int entryCount = entries.length;
        if (value == null) {
            for (int i = 0; i < entryCount; ++i) {
                if (entries[i].getValueWithoutTouching() != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < entryCount; ++i) {
                if (!value.equals(entries[i].getValueWithoutTouching())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ConcurrentEntry<K, V> entry = CopyOnWriteArrayMap._getEntry(this._entries, key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    private static <K, V> ConcurrentEntry<K, V>[] _insertEntryAt(ConcurrentEntry<K, V>[] entries, K key, V value, int insertIndex, EntryFactory<ConcurrentEntry<K, V>, K, V> entryFactory) {
        ConcurrentEntry<K, V> entry = entryFactory.newEntry(key, value);
        int removeIndex = entryFactory.getIndexOfEntryToPurge(entries);
        return CopyOnWriteArrayMap._addEntryAtIndex(entries, entry, insertIndex, removeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        V oldValue;
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            ConcurrentEntry<K, V>[] entries = this._entries;
            int entryIndex = CopyOnWriteArrayMap._getEntryIndex(entries, key);
            if (entryIndex >= 0) {
                ConcurrentEntry<K, V> entry = entries[entryIndex];
                oldValue = entry.setValue(value);
            } else {
                int insertIndex = -(entryIndex + 1);
                this._entries = CopyOnWriteArrayMap._insertEntryAt(entries, key, value, insertIndex, this._entryFactory);
                oldValue = null;
            }
        }
        finally {
            writeLock.unlock();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        V oldValue;
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            ConcurrentEntry<K, V>[] entries = this._entries;
            int removeIndex = CopyOnWriteArrayMap._getEntryIndex(entries, key);
            if (removeIndex >= 0) {
                ConcurrentEntry<K, V> entry = entries[removeIndex];
                oldValue = entry.getValue();
                this._entries = CopyOnWriteArrayMap._removeEntryByIndex(entries, removeIndex);
            } else {
                oldValue = null;
            }
        }
        finally {
            writeLock.unlock();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            for (Map.Entry<K, V> e : m.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock writeLock = this._writeLock;
        writeLock.lock();
        try {
            this._entries = this._entryFactory.getEmptyEntries();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean __removeOrRetainAll(Iterable<?> ourIterable, Collection<?> c, boolean retain) {
        boolean modified = false;
        this._writeLock.lock();
        try {
            Iterator<?> it = ourIterable.iterator();
            while (it.hasNext()) {
                Object entry = it.next();
                if (!(retain ^ c.contains(entry))) continue;
                it.remove();
                modified = true;
            }
        }
        finally {
            this._writeLock.unlock();
        }
        return modified;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        ConcurrentEntry<K, V>[] entries = this._entries;
        int entryCount = entries.length;
        Map otherMap = (Map)o;
        if (entryCount != otherMap.size()) {
            return false;
        }
        for (int i = 0; i < entryCount; ++i) {
            Object otherValue;
            ConcurrentEntry<K, V> entry = entries[i];
            K entryKey = entry.getKey();
            V entryValue = entry.getValue();
            if (!(entryValue != null ? !entryValue.equals(otherValue = otherMap.get(entryKey)) : (otherValue = otherMap.get(entryKey)) != null || !otherMap.containsKey(entryKey))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        ConcurrentEntry<K, V>[] entries;
        int hash = 0;
        for (ConcurrentEntry<K, V> entry : entries = this._entries) {
            hash += entry.hashCode();
        }
        return hash;
    }

    public String toString() {
        ConcurrentEntry<K, V>[] entries = this._entries;
        if (entries.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirstEntry = true;
        for (ConcurrentEntry<K, V> entry : entries) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                sb.append(", ");
            }
            Object key = entry.getKey();
            Object value = entry.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
        }
        sb.append('}');
        return sb.toString();
    }

    public CopyOnWriteArrayMap<K, V> clone() {
        ConcurrentEntry[] entries = this._entryFactory.cloneEntries(this._entries);
        return new CopyOnWriteArrayMap<K, V>(this._entryFactory, new ReentrantLock(), entries);
    }

    private void readObject(ObjectInputStream inStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy Required");
    }

    private Object writeReplace() {
        return this._entryFactory.newSerializationProxy(this._entries);
    }

    static /* synthetic */ ConcurrentEntry[] access$302(CopyOnWriteArrayMap x0, ConcurrentEntry[] x1) {
        x0._entries = x1;
        return x1;
    }

    private static final class LRUEntry<K, V>
    extends ConcurrentEntry<K, V> {
        private final LRUEntryFactory<K, V> _nanoCalculator;
        private volatile long _lastAccessed;

        public LRUEntry(K key, V value, LRUEntryFactory<K, V> nanoCalculator) {
            super(key, value);
            this._nanoCalculator = nanoCalculator;
            this._lastAccessed = this._nanoCalculator.nanosSinceCreated();
        }

        public long getLastAccessed() {
            return this._lastAccessed;
        }

        @Override
        public V getValue() {
            this._lastAccessed = this._nanoCalculator.nanosSinceCreated();
            return super.getValue();
        }

        @Override
        public V setValue(V newValue) {
            this._lastAccessed = this._nanoCalculator.nanosSinceCreated();
            return super.setValue(newValue);
        }
    }

    protected static class ConcurrentEntry<K, V>
    implements Map.Entry<K, V> {
        private volatile V _value;
        private final K _key;
        public final int keyHashCode;
        private static final AtomicReferenceFieldUpdater<ConcurrentEntry, Object> _VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcurrentEntry.class, Object.class, "_value");

        protected ConcurrentEntry(K key, V value) {
            Args.notNull(key, (String)"key");
            this._key = key;
            this._value = value;
            this.keyHashCode = key.hashCode();
        }

        @Override
        public final K getKey() {
            return this._key;
        }

        public V getValueWithoutTouching() {
            return this._value;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        public boolean compareAndSetValue(V expected, V newValue) {
            return _VALUE_UPDATER.compareAndSet(this, expected, newValue);
        }

        @Override
        public V setValue(V newValue) {
            return (V)_VALUE_UPDATER.getAndSet(this, newValue);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Map.Entry otherEntry = (Map.Entry)o;
                if (this.getKey().equals(otherEntry.getKey())) {
                    Object otherValue = otherEntry.getValue();
                    V value = this._value;
                    return value != null ? value.equals(otherValue) : otherValue == null;
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            V value = this._value;
            int valueHashCode = value != null ? value.hashCode() : 0;
            return this.keyHashCode ^ valueHashCode;
        }

        public String toString() {
            return this.getKey() + "=" + this._value;
        }
    }

    private static final class LRUEntryFactory<K, V>
    extends EntryFactory<LRUEntry<K, V>, K, V> {
        private static final ConcurrentEntry[] _EMPTY_LRU_ENTRIES = new LRUEntry[0];
        private final int _maxEntries;
        private final long _baseNanos;

        public LRUEntryFactory(int maxEntries, long baseNanos) {
            this._maxEntries = maxEntries;
            this._baseNanos = baseNanos;
        }

        @Override
        public LRUEntry<K, V> newEntry(K key, V value) {
            return new LRUEntry<K, V>(key, value, this);
        }

        public int getIndexOfEntryToPurge(LRUEntry<K, V>[] entries) {
            if (this._maxEntries <= entries.length) {
                return LRUEntryFactory._getOldestAccessesedEntryIndex(entries);
            }
            return -1;
        }

        private static <K, V> int _getOldestAccessesedEntryIndex(LRUEntry<K, V>[] entries) {
            int entryCount = entries.length;
            int oldestIndex = -1;
            long oldestAccessedNanos = Long.MAX_VALUE;
            for (int i = 0; i < entryCount; ++i) {
                LRUEntry<K, V> entry = entries[i];
                long currAccessedNanos = entry.getLastAccessed();
                if (currAccessedNanos > oldestAccessedNanos) continue;
                oldestIndex = i;
                oldestAccessedNanos = currAccessedNanos;
            }
            return oldestIndex;
        }

        public LRUEntry<K, V>[] getEmptyEntries() {
            return (LRUEntry[])_EMPTY_LRU_ENTRIES;
        }

        public SerializationProxy<LRUEntry<K, V>, K, V> newSerializationProxy(LRUEntry<K, V>[] entries) {
            return new LRUSerializationProxy<K, V>(this._maxEntries, this._baseNanos, entries);
        }

        public long nanosSinceCreated() {
            long nanos = System.nanoTime();
            long delta = nanos - this._baseNanos;
            if (delta >= 0L) {
                return delta;
            }
            return Long.MAX_VALUE;
        }

        protected static final class LRUSerializationProxy<K, V>
        extends SerializationProxy<LRUEntry<K, V>, K, V> {
            private static final long serialVersionUID = 1L;
            private final int _maxEntries;
            private final long _baseNanos;

            protected LRUSerializationProxy(int maxEntries, long baseNanos, ConcurrentEntry<K, V>[] entries) {
                super(entries);
                this._maxEntries = maxEntries;
                this._baseNanos = baseNanos;
            }

            @Override
            public EntryFactory<LRUEntry<K, V>, K, V> instantiateEntryFactory() {
                return new LRUEntryFactory(this._maxEntries, this._baseNanos);
            }

            protected LRUEntry<K, V>[] instantiateEntries(Object[] keyValues, EntryFactory<LRUEntry<K, V>, K, V> entryFactory) {
                int entryCount = keyValues.length / 2;
                LRUEntry[] entries = new LRUEntry[entryCount];
                int keyValueIndex = 0;
                for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                    LRUEntry<Object, Object> entry;
                    Object key = keyValues[keyValueIndex++];
                    Object value = keyValues[keyValueIndex++];
                    entries[entryIndex] = entry = new LRUEntry<Object, Object>(key, value, (LRUEntryFactory)entryFactory);
                }
                return entries;
            }
        }
    }

    private static final class ConcurrentEntryFactory<K, V>
    extends EntryFactory<ConcurrentEntry<K, V>, K, V> {
        private static final EntryFactory<?, ?, ?> _INSTANCE = new ConcurrentEntryFactory();
        private static final ConcurrentEntry[] _EMPTY_ENTRIES = new ConcurrentEntry[0];

        private ConcurrentEntryFactory() {
        }

        public static <K, V> ConcurrentEntryFactory<K, V> getInstance() {
            return (ConcurrentEntryFactory)_INSTANCE;
        }

        @Override
        public ConcurrentEntry<K, V> newEntry(K key, V value) {
            return new ConcurrentEntry<K, V>(key, value);
        }

        public int getIndexOfEntryToPurge(ConcurrentEntry<K, V>[] entries) {
            return -1;
        }

        public ConcurrentEntry<K, V>[] getEmptyEntries() {
            return _EMPTY_ENTRIES;
        }

        public SerializationProxy<ConcurrentEntry<K, V>, K, V> newSerializationProxy(ConcurrentEntry<K, V>[] entries) {
            return new ConcurrentSerializationProxy<K, V>(entries);
        }

        protected static final class ConcurrentSerializationProxy<K, V>
        extends SerializationProxy<ConcurrentEntry<K, V>, K, V> {
            private static final long serialVersionUID = 1L;

            protected ConcurrentSerializationProxy(ConcurrentEntry<K, V>[] entries) {
                super(entries);
            }

            @Override
            public EntryFactory<ConcurrentEntry<K, V>, K, V> instantiateEntryFactory() {
                return ConcurrentEntryFactory.getInstance();
            }

            protected ConcurrentEntry<K, V>[] instantiateEntries(Object[] keyValues, EntryFactory<ConcurrentEntry<K, V>, K, V> entryFactory) {
                int entryCount = keyValues.length / 2;
                ConcurrentEntry[] entries = new ConcurrentEntry[entryCount];
                int keyValueIndex = 0;
                for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                    ConcurrentEntry<Object, Object> entry;
                    Object key = keyValues[keyValueIndex++];
                    Object value = keyValues[keyValueIndex++];
                    entries[entryIndex] = entry = new ConcurrentEntry<Object, Object>(key, value);
                }
                return entries;
            }
        }
    }

    private static abstract class EntryFactory<E extends ConcurrentEntry<K, V>, K, V> {
        private EntryFactory() {
        }

        public abstract E newEntry(K var1, V var2);

        public abstract int getIndexOfEntryToPurge(E[] var1);

        public abstract E[] getEmptyEntries();

        public abstract SerializationProxy<E, K, V> newSerializationProxy(E[] var1);

        public final E[] cloneEntries(E[] entries) {
            ConcurrentEntry[] clonedEntries = (ConcurrentEntry[])entries.clone();
            int entryCount = entries.length;
            for (int i = 0; i < entryCount; ++i) {
                ConcurrentEntry originalEntry = clonedEntries[i];
                E clonedEntry = this.newEntry(originalEntry.getKey(), originalEntry.getValue());
                clonedEntries[i] = clonedEntry;
            }
            return clonedEntries;
        }
    }

    protected static abstract class SerializationProxy<E extends ConcurrentEntry<K, V>, K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Serializable[] _keyValues;

        protected SerializationProxy(ConcurrentEntry<K, V>[] entries) {
            this._keyValues = SerializationProxy._createKeyValues(entries);
        }

        private Object readResolve() {
            ReentrantLock writeLock = new ReentrantLock();
            EntryFactory<E, K, V> entryFactory = this.instantiateEntryFactory();
            ConcurrentEntry[] entries = this.instantiateEntries(this._keyValues, entryFactory);
            return new CopyOnWriteArrayMap(entryFactory, writeLock, entries);
        }

        protected abstract E[] instantiateEntries(Object[] var1, EntryFactory<E, K, V> var2);

        protected abstract EntryFactory<E, K, V> instantiateEntryFactory();

        private static <K, V> Serializable[] _createKeyValues(ConcurrentEntry<K, V>[] entries) {
            int entryCount = entries.length;
            Serializable[] keyValues = new Serializable[entryCount * 2];
            int keyValueIndex = 0;
            for (int entryIndex = 0; entryIndex < entryCount; ++entryIndex) {
                ConcurrentEntry<K, V> entry = entries[entryIndex];
                keyValues[keyValueIndex++] = (Serializable)entry.getKey();
                keyValues[keyValueIndex++] = (Serializable)entry.getValue();
            }
            return keyValues;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry theirEntry = (Map.Entry)o;
            ConcurrentEntry ourEntry = CopyOnWriteArrayMap._getEntry(CopyOnWriteArrayMap.this._entries, theirEntry.getKey());
            if (ourEntry != null) {
                Object ourValue = ourEntry.getValue();
                Object theirValue = theirEntry.getValue();
                return ourValue != null ? ourValue.equals(theirValue) : theirValue == null;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry removeEntry = (Map.Entry)o;
            return CopyOnWriteArrayMap.this.remove(removeEntry.getKey(), removeEntry.getValue());
        }

        @Override
        public int size() {
            return CopyOnWriteArrayMap.this.size();
        }

        @Override
        public void clear() {
            CopyOnWriteArrayMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ConcurrentEntry[] entries = CopyOnWriteArrayMap.this._entries;
            return Arrays.copyOf(entries, entries.length);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ConcurrentEntry[] entries = CopyOnWriteArrayMap.this._entries;
            int entryCount = entries.length;
            if (a.length < entryCount) {
                return Arrays.copyOf(entries, entryCount, a.getClass());
            }
            System.arraycopy(entries, 0, a, 0, entryCount);
            if (a.length > entryCount) {
                a[entryCount] = null;
            }
            return a;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, true);
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private ConcurrentEntry<K, V>[] _entries;
        private int _cursorIndex;
        private int _lastReturnedIndex;

        EntryIterator() {
            this._entries = CopyOnWriteArrayMap.this._entries;
            this._cursorIndex = 0;
            this._lastReturnedIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this._cursorIndex < this._entries.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            try {
                ConcurrentEntry entry = this._entries[this._cursorIndex];
                this._lastReturnedIndex = this._cursorIndex++;
                return entry;
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new NoSuchElementException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this._lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            ReentrantLock writeLock = CopyOnWriteArrayMap.this._writeLock;
            writeLock.lock();
            try {
                ConcurrentEntry[] ourEntries = this._entries;
                ConcurrentEntry[] baseEntries = CopyOnWriteArrayMap.this._entries;
                if (ourEntries != baseEntries) {
                    throw new ConcurrentModificationException();
                }
                this._entries = CopyOnWriteArrayMap._removeEntryByIndex(ourEntries, this._lastReturnedIndex);
                CopyOnWriteArrayMap.access$302(CopyOnWriteArrayMap.this, this._entries);
            }
            finally {
                writeLock.unlock();
            }
            --this._cursorIndex;
            this._lastReturnedIndex = -1;
        }
    }

    private final class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private final Iterator<Map.Entry<K, V>> _i;
                {
                    this._i = CopyOnWriteArrayMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._i.hasNext();
                }

                @Override
                public V next() {
                    ConcurrentEntry entry = (ConcurrentEntry)this._i.next();
                    return entry.getValueWithoutTouching();
                }

                @Override
                public void remove() {
                    this._i.remove();
                }
            };
        }

        @Override
        public int size() {
            return CopyOnWriteArrayMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CopyOnWriteArrayMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CopyOnWriteArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object v) {
            return CopyOnWriteArrayMap.this.containsValue(v);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, true);
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private final Iterator<Map.Entry<K, V>> _i;
                {
                    this._i = CopyOnWriteArrayMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._i.hasNext();
                }

                @Override
                public K next() {
                    return this._i.next().getKey();
                }

                @Override
                public void remove() {
                    this._i.remove();
                }
            };
        }

        @Override
        public int size() {
            return CopyOnWriteArrayMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CopyOnWriteArrayMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CopyOnWriteArrayMap.this.clear();
        }

        @Override
        public boolean contains(Object k) {
            return CopyOnWriteArrayMap.this.containsKey(k);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, false);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return CopyOnWriteArrayMap.this.__removeOrRetainAll(this, c, true);
        }
    }
}

