/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.reduce;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.WholeNumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.reduce.ReduceEvaluator;
import org.apache.nifi.expression.AttributeExpression;

public class CountEvaluator
extends WholeNumberEvaluator
implements ReduceEvaluator<Long> {
    private final Evaluator<?> subjectEvaluator;

    public CountEvaluator(Evaluator<?> subjectEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(EvaluationContext evaluationContext) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(evaluationContext);
        Long count = evaluationContext.getEvaluatorState().getState(this, Long.class);
        if (count == null) {
            count = 0L;
        }
        if (result.getValue() == null) {
            return new WholeNumberQueryResult(count);
        }
        if (result.getResultType() == AttributeExpression.ResultType.BOOLEAN && ((Boolean)result.getValue()).equals(Boolean.FALSE)) {
            return new WholeNumberQueryResult(count);
        }
        Long l = count;
        count = count + 1L;
        evaluationContext.getEvaluatorState().putState(this, count);
        return new WholeNumberQueryResult(count);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

