/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;

public class ConnectionSchema
extends BaseSchemaWithIdAndName {
    public static final String SOURCE_ID_KEY = "source id";
    public static final String SOURCE_RELATIONSHIP_NAMES_KEY = "source relationship names";
    public static final String DESTINATION_ID_KEY = "destination id";
    public static final String MAX_WORK_QUEUE_SIZE_KEY = "max work queue size";
    public static final String MAX_WORK_QUEUE_DATA_SIZE_KEY = "max work queue data size";
    public static final String FLOWFILE_EXPIRATION__KEY = "flowfile expiration";
    public static final String QUEUE_PRIORITIZER_CLASS_KEY = "queue prioritizer class";
    public static final long DEFAULT_MAX_WORK_QUEUE_SIZE = 0L;
    public static final String DEFAULT_MAX_QUEUE_DATA_SIZE = "0 MB";
    public static final String DEFAULT_FLOWFILE_EXPIRATION = "0 sec";
    private String sourceId;
    private boolean needsSourceRelationships = true;
    private List<String> sourceRelationshipNames;
    private String destinationId;
    private Number maxWorkQueueSize = 0L;
    private String maxWorkQueueDataSize = "0 MB";
    private String flowfileExpiration = "0 sec";
    private String queuePrioritizerClass;

    public ConnectionSchema(Map map) {
        super(map, "Connection(id: {id}, name: {name})");
        String wrapperName = this.getWrapperName();
        this.sourceId = this.getOptionalKeyAsType(map, SOURCE_ID_KEY, String.class, wrapperName, "");
        this.destinationId = this.getOptionalKeyAsType(map, DESTINATION_ID_KEY, String.class, wrapperName, "");
        this.sourceRelationshipNames = this.getOptionalKeyAsType(map, SOURCE_RELATIONSHIP_NAMES_KEY, List.class, wrapperName, new ArrayList());
        this.maxWorkQueueSize = this.getOptionalKeyAsType(map, MAX_WORK_QUEUE_SIZE_KEY, Number.class, wrapperName, 0L);
        this.maxWorkQueueDataSize = this.getOptionalKeyAsType(map, MAX_WORK_QUEUE_DATA_SIZE_KEY, String.class, wrapperName, DEFAULT_MAX_QUEUE_DATA_SIZE);
        this.flowfileExpiration = this.getOptionalKeyAsType(map, FLOWFILE_EXPIRATION__KEY, String.class, wrapperName, DEFAULT_FLOWFILE_EXPIRATION);
        this.queuePrioritizerClass = this.getOptionalKeyAsType(map, QUEUE_PRIORITIZER_CLASS_KEY, String.class, wrapperName, "");
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put(SOURCE_ID_KEY, this.sourceId);
        result.put(SOURCE_RELATIONSHIP_NAMES_KEY, this.sourceRelationshipNames);
        result.put(DESTINATION_ID_KEY, this.destinationId);
        result.put(MAX_WORK_QUEUE_SIZE_KEY, this.maxWorkQueueSize);
        result.put(MAX_WORK_QUEUE_DATA_SIZE_KEY, this.maxWorkQueueDataSize);
        result.put(FLOWFILE_EXPIRATION__KEY, this.flowfileExpiration);
        result.put(QUEUE_PRIORITIZER_CLASS_KEY, this.queuePrioritizerClass);
        return result;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public List<String> getSourceRelationshipNames() {
        return this.sourceRelationshipNames;
    }

    public Number getMaxWorkQueueSize() {
        return this.maxWorkQueueSize;
    }

    public String getMaxWorkQueueDataSize() {
        return this.maxWorkQueueDataSize;
    }

    public String getFlowfileExpiration() {
        return this.flowfileExpiration;
    }

    public String getQueuePrioritizerClass() {
        return this.queuePrioritizerClass;
    }

    public void setNeedsSourceRelationships(boolean needsSourceRelationships) {
        this.needsSourceRelationships = needsSourceRelationships;
    }

    @Override
    public List<String> getValidationIssues() {
        String wrapperName = this.getWrapperName();
        List<String> validationIssues = super.getValidationIssues();
        StringUtil.doIfNullOrEmpty(this.getSourceId(), id -> validationIssues.add(ConnectionSchema.getIssueText(SOURCE_ID_KEY, wrapperName, "it was not found and it is required")));
        StringUtil.doIfNullOrEmpty(this.getDestinationId(), id -> validationIssues.add(ConnectionSchema.getIssueText(DESTINATION_ID_KEY, wrapperName, "it was not found and it is required")));
        if (this.needsSourceRelationships && this.sourceRelationshipNames.isEmpty()) {
            validationIssues.add("Expected at least one value in source relationship names for " + wrapperName + " " + this.getName());
        }
        return Collections.unmodifiableList(validationIssues);
    }
}

