/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

@Internal
public class EmptyLinePreprocessorStream
extends FilterObjectStream<String, String> {
    private boolean lastLineWasEmpty = true;

    public EmptyLinePreprocessorStream(ObjectStream<String> in) {
        super(in);
    }

    private static boolean isLineEmpty(String line) {
        return line.trim().length() == 0;
    }

    public String read() throws IOException {
        String line = (String)this.samples.read();
        if (this.lastLineWasEmpty) {
            this.lastLineWasEmpty = false;
            while (line != null && EmptyLinePreprocessorStream.isLineEmpty(line)) {
                line = (String)this.samples.read();
            }
        }
        if (line != null && EmptyLinePreprocessorStream.isLineEmpty(line)) {
            this.lastLineWasEmpty = true;
            line = "";
        }
        return line;
    }
}

