/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.XmlUtil;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.AggregatedFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorResourceProvider;
import opennlp.tools.util.model.ArtifactSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class GeneratorFactory {
    public static AdaptiveFeatureGenerator create(InputStream xmlDescriptorIn, FeatureGeneratorResourceProvider resourceManager) throws IOException {
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        Element generatorElement = xmlDescriptorDOM.getDocumentElement();
        return GeneratorFactory.createGenerator(generatorElement, resourceManager);
    }

    private static AdaptiveFeatureGenerator buildGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        if (generatorElement == null) {
            throw new IllegalArgumentException("generatorElement must not be NULL");
        }
        String className = generatorElement.getAttribute("class");
        if (className.isBlank()) {
            throw new InvalidFormatException("generator must have class attribute");
        }
        try {
            Class<?> factoryClass = Class.forName(className);
            try {
                Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                AbstractXmlFeatureGeneratorFactory factory = (AbstractXmlFeatureGeneratorFactory)constructor.newInstance(new Object[0]);
                factory.init(generatorElement, resourceManager);
                return factory.create();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | InvalidFormatException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static AdaptiveFeatureGenerator createGenerator(Element generatorElement, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
        if (generatorElement == null) {
            throw new IllegalArgumentException("generatorElement must not be NULL");
        }
        String elementName = generatorElement.getTagName();
        if ("featureGenerators".equals(elementName)) {
            AdaptiveFeatureGenerator featureGenerator;
            ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
            NodeList childNodes = generatorElement.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element elem = (Element)childNode;
                String type = elem.getTagName();
                if ("generator".equals(type)) {
                    generators.add(GeneratorFactory.buildGenerator(elem, resourceManager));
                    continue;
                }
                throw new InvalidFormatException("Unexpected element: " + elementName);
            }
            if (generators.size() == 1) {
                featureGenerator = (AdaptiveFeatureGenerator)generators.get(0);
            } else if (generators.size() > 1) {
                featureGenerator = new AggregatedFeatureGenerator(generators.toArray(new AdaptiveFeatureGenerator[0]));
            } else {
                throw new InvalidFormatException("featureGenerators must have one or more generators");
            }
            if (featureGenerator instanceof CachedFeatureGenerator) {
                throw new InvalidFormatException("CachedFeatureGeneratorFactory cannot be specified manually.Use cache=\"true\" attribute in featureGenerators element instead.");
            }
            if (Boolean.parseBoolean(generatorElement.getAttribute("cache"))) {
                return new CachedFeatureGenerator(featureGenerator);
            }
            return featureGenerator;
        }
        throw new IllegalArgumentException("[OPENNLP-1174] - Classic configuration format is no longer supported!");
    }

    private static Document createDOM(InputStream xmlDescriptorIn) throws IOException {
        Document xmlDescriptorDOM;
        DocumentBuilder documentBuilder = XmlUtil.createDocumentBuilder();
        try {
            xmlDescriptorDOM = documentBuilder.parse(xmlDescriptorIn);
        }
        catch (SAXException e) {
            throw new InvalidFormatException("Descriptor is not valid XML!", (Throwable)e);
        }
        return xmlDescriptorDOM;
    }

    public static Map<String, ArtifactSerializer<?>> extractArtifactSerializerMappings(InputStream xmlDescriptorIn) throws IOException {
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        Element element = xmlDescriptorDOM.getDocumentElement();
        String elementName = element.getTagName();
        if ("featureGenerators".equals(elementName)) {
            return GeneratorFactory.addMappingsFromXmlChildren(element.getChildNodes(), new HashMap());
        }
        throw new IllegalArgumentException("[OPENNLP-1174] - Classic configuration format is no longer supported!");
    }

    private static void extractArtifactSerializerMappings(Map<String, ArtifactSerializer<?>> mapping, Element element) {
        String className = element.getAttribute("class");
        if (!className.isBlank()) {
            try {
                Class<?> factoryClass = Class.forName(className);
                try {
                    Constructor<?> constructor = factoryClass.getConstructor(new Class[0]);
                    AbstractXmlFeatureGeneratorFactory factory = (AbstractXmlFeatureGeneratorFactory)constructor.newInstance(new Object[0]);
                    factory.init(element, null);
                    Map<String, ArtifactSerializer<?>> map = factory.getArtifactSerializerMapping();
                    if (map != null) {
                        mapping.putAll(map);
                    }
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (InvalidFormatException invalidFormatException) {
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        GeneratorFactory.addMappingsFromXmlChildren(element.getChildNodes(), mapping);
    }

    private static Map<String, ArtifactSerializer<?>> addMappingsFromXmlChildren(NodeList nodes, Map<String, ArtifactSerializer<?>> mapping) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element childElem;
            Node node = nodes.item(i);
            if (!(node instanceof Element) || !"generator".equals((childElem = (Element)node).getTagName())) continue;
            GeneratorFactory.extractArtifactSerializerMappings(mapping, childElem);
        }
        return mapping;
    }

    public static List<Element> getDescriptorElements(InputStream xmlDescriptorIn) throws IOException {
        NodeList allElements;
        ArrayList<Element> elements = new ArrayList<Element>();
        Document xmlDescriptorDOM = GeneratorFactory.createDOM(xmlDescriptorIn);
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            XPathExpression exp = xPath.compile("//*");
            allElements = (NodeList)exp.evaluate(xmlDescriptorDOM.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new InvalidFormatException("The hard coded XPath expression should always be valid!");
        }
        for (int i = 0; i < allElements.getLength(); ++i) {
            Node node = allElements.item(i);
            if (!(node instanceof Element)) continue;
            Element customElement = (Element)node;
            elements.add(customElement);
        }
        return elements;
    }

    public static abstract class AbstractXmlFeatureGeneratorFactory {
        protected Element generatorElement;
        protected FeatureGeneratorResourceProvider resourceManager;
        protected LinkedHashMap<String, Object> args = new LinkedHashMap();

        public Map<String, ArtifactSerializer<?>> getArtifactSerializerMapping() throws InvalidFormatException {
            return null;
        }

        final void init(Element element, FeatureGeneratorResourceProvider resourceManager) throws InvalidFormatException {
            this.generatorElement = element;
            this.resourceManager = resourceManager;
            ArrayList<AdaptiveFeatureGenerator> generators = new ArrayList<AdaptiveFeatureGenerator>();
            NodeList childNodes = this.generatorElement.getChildNodes();
            block16: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element elem = (Element)childNode;
                String type = elem.getTagName();
                if (type.equals("generator")) {
                    String key = "generator#" + generators.size();
                    AdaptiveFeatureGenerator afg = GeneratorFactory.buildGenerator(elem, resourceManager);
                    if (afg == null) continue;
                    generators.add(afg);
                    this.args.put(key, afg);
                    continue;
                }
                String name = elem.getAttribute("name");
                Node cn = elem.getFirstChild();
                Text text = (Text)cn;
                switch (type) {
                    case "int": {
                        this.args.put(name, Integer.parseInt(text.getWholeText()));
                        continue block16;
                    }
                    case "long": {
                        this.args.put(name, Long.parseLong(text.getWholeText()));
                        continue block16;
                    }
                    case "float": {
                        this.args.put(name, Float.valueOf(Float.parseFloat(text.getWholeText())));
                        continue block16;
                    }
                    case "double": {
                        this.args.put(name, Double.parseDouble(text.getWholeText()));
                        continue block16;
                    }
                    case "str": {
                        this.args.put(name, text.getWholeText());
                        continue block16;
                    }
                    case "bool": {
                        this.args.put(name, Boolean.parseBoolean(text.getWholeText()));
                        continue block16;
                    }
                    default: {
                        throw new InvalidFormatException("child element must be one of generator, int, long, float, double, str or bool");
                    }
                }
            }
            if (generators.size() > 1) {
                AggregatedFeatureGenerator aggregatedFeatureGenerator = new AggregatedFeatureGenerator(generators.toArray(new AdaptiveFeatureGenerator[0]));
                this.args.put("generator#0", aggregatedFeatureGenerator);
            }
        }

        public int getInt(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be integer!");
        }

        public int getInt(String name, int defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be integer!");
        }

        public long getLong(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be long!");
        }

        public long getLong(String name, long defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be long!");
        }

        public float getFloat(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            throw new InvalidFormatException("parameter " + name + " must be float!");
        }

        public float getFloat(String name, float defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            throw new InvalidFormatException("parameter " + name + " must be float!");
        }

        public double getDouble(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public double getDouble(String name, double defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public String getStr(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be double!");
        }

        public String getStr(String name, String defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof String) {
                return (String)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be String!");
        }

        public boolean getBool(String name) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                throw new InvalidFormatException("parameter " + name + " must be set!");
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be boolean!");
        }

        public boolean getBool(String name, boolean defValue) throws InvalidFormatException {
            Object value = this.args.get(name);
            if (value == null) {
                return defValue;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new InvalidFormatException("parameter " + name + " must be boolean!");
        }

        public abstract AdaptiveFeatureGenerator create() throws InvalidFormatException;
    }
}

