/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.InjectableConstructor;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.InjectionTargetImpl;

public class AbstractDecoratorInjectionTarget<T>
extends InjectionTargetImpl<T> {
    private Class<T> proxySubClass = null;

    public AbstractDecoratorInjectionTarget(AnnotatedType<T> annotatedType, Set<InjectionPoint> points, WebBeansContext webBeansContext, List<AnnotatedMethod<?>> postConstructMethods, List<AnnotatedMethod<?>> preDestroyMethods) {
        super(annotatedType, points, webBeansContext, postConstructMethods, preDestroyMethods);
    }

    @Override
    protected AnnotatedConstructor<T> createConstructor() {
        Constructor parentCtor;
        Class classToProxy = this.annotatedType.getJavaClass();
        ClassLoader classLoader = this.webBeansContext.getApplicationBoundaryService().getBoundaryClassLoader(classToProxy);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.proxySubClass = this.webBeansContext.getSubclassProxyFactory().createImplementedSubclass(classLoader, this.annotatedType);
        Constructor ct = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructors(this.proxySubClass)[0];
        try {
            parentCtor = classToProxy.getConstructor(ct.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return new SubClassAnnotatedConstructorImpl(this.webBeansContext, parentCtor, ct, this.annotatedType);
    }

    @Override
    protected SubClassAnnotatedConstructorImpl<T> getConstructor() {
        if (this.constructor == null) {
            this.constructor = this.createConstructor();
        }
        return (SubClassAnnotatedConstructorImpl)this.constructor;
    }

    @Override
    protected T newInstance(CreationalContextImpl<T> creationalContext) {
        return new AbstractDecoratorInjectableConstructor<T>(((SubClassAnnotatedConstructorImpl)this.getConstructor()).parentConstructor, this.getConstructor().getJavaMember(), this, creationalContext).doInjection();
    }

    public static class AbstractDecoratorInjectableConstructor<T>
    extends InjectableConstructor<T> {
        private final Constructor<T> parent;

        public AbstractDecoratorInjectableConstructor(Constructor<T> parentConstructor, Constructor<T> cons, InjectionTarget<T> owner, CreationalContextImpl<T> creationalContext) {
            super(cons, owner, creationalContext);
            this.parent = parentConstructor;
        }

        @Override
        protected List<InjectionPoint> getInjectionPoints(Member member) {
            ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
            for (InjectionPoint injectionPoint : this.owner.getInjectionPoints()) {
                if (!injectionPoint.getMember().equals(this.parent)) continue;
                injectionPoints.add(injectionPoint);
            }
            return injectionPoints;
        }
    }

    public static class SubClassAnnotatedConstructorImpl<T>
    extends AnnotatedConstructorImpl<T> {
        private final Constructor<T> parentConstructor;

        public SubClassAnnotatedConstructorImpl(WebBeansContext webBeansContext, Constructor<T> parentConstructor, Constructor<T> javaMember, AnnotatedType<T> declaringType) {
            super(webBeansContext, javaMember, declaringType);
            this.parentConstructor = parentConstructor;
        }
    }
}

