/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.hiverc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class HiveRCRecordReader
extends RecordReader<LongWritable, BytesRefArrayWritable> {
    LongWritable key;
    BytesRefArrayWritable value;
    RCFileRecordReader<LongWritable, BytesRefArrayWritable> rcFileRecordReader;
    Path splitPath = null;

    public void close() throws IOException {
        this.rcFileRecordReader.close();
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public BytesRefArrayWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.rcFileRecordReader.getProgress();
    }

    public Path getSplitPath() {
        return this.splitPath;
    }

    public void initialize(InputSplit split, TaskAttemptContext ctx) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        Configuration conf = ctx.getConfiguration();
        this.splitPath = fileSplit.getPath();
        this.rcFileRecordReader = new RCFileRecordReader(conf, new org.apache.hadoop.mapred.FileSplit(this.splitPath, fileSplit.getStart(), fileSplit.getLength(), new JobConf(conf)));
        this.key = this.rcFileRecordReader.createKey();
        this.value = this.rcFileRecordReader.createValue();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.rcFileRecordReader.next(this.key, this.value);
    }
}

