/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.Arrays;
import java.util.Comparator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.ObjectToBeSorted;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class SortedIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private final SequenceIterator base;
    protected SortKeyEvaluator sortKeyEvaluator;
    protected AtomicComparer[] comparators;
    protected ObjectToBeSorted[] values;
    protected int count = -1;
    protected int position = 0;
    protected final XPathContext context;
    private HostLanguage hostLanguage;

    protected SequenceIterator getBaseIterator() {
        return this.base;
    }

    public SortedIterator(XPathContext context, SequenceIterator base, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] comparators, boolean createNewContext) {
        if (createNewContext) {
            this.context = context.newMinorContext();
            this.context.setTemporaryOutputState(203);
            this.base = this.context.trackFocus(base);
        } else {
            this.context = context;
            this.base = base;
        }
        this.sortKeyEvaluator = sortKeyEvaluator;
        this.comparators = new AtomicComparer[comparators.length];
        for (int n = 0; n < comparators.length; ++n) {
            this.comparators[n] = comparators[n].provideContext(context);
        }
    }

    public void setHostLanguage(HostLanguage language) {
        this.hostLanguage = language;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.position < 0) {
            return false;
        }
        if (this.count < 0) {
            if (this.base instanceof LookaheadIterator && ((LookaheadIterator)this.base).supportsHasNext()) {
                return ((LookaheadIterator)this.base).hasNext();
            }
            try {
                this.doSort();
                return this.count > 0;
            }
            catch (XPathException err) {
                throw new UncheckedXPathException(err);
            }
        }
        return this.position < this.count;
    }

    @Override
    public Item next() {
        if (this.position < 0) {
            return null;
        }
        if (this.count < 0) {
            try {
                this.doSort();
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
        }
        if (this.position < this.count) {
            return this.values[this.position++].value;
        }
        this.position = -1;
        return null;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        if (this.count < 0) {
            try {
                this.doSort();
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
        }
        return this.count;
    }

    protected void buildArray() throws XPathException {
        ObjectToBeSorted[] nk2;
        Item item;
        int allocated = SequenceTool.supportsGetLength(this.base) ? SequenceTool.getLength(this.base) : 100;
        this.values = new ItemToBeSorted[allocated];
        this.count = 0;
        while ((item = this.base.next()) != null) {
            if (this.count == allocated) {
                nk2 = new ObjectToBeSorted[allocated *= 2];
                System.arraycopy(this.values, 0, nk2, 0, this.count);
                this.values = nk2;
            }
            ItemToBeSorted itbs = new ItemToBeSorted(this.comparators.length);
            this.values[this.count] = itbs;
            itbs.value = item;
            for (int n = 0; n < this.comparators.length; ++n) {
                itbs.sortKeyValues[n] = this.sortKeyEvaluator.evaluateSortKey(n, this.context);
            }
            ++this.count;
            itbs.originalPosition = itbs.originalPosition;
        }
        if (allocated * 2 < this.count || allocated - this.count > 2000) {
            nk2 = new ObjectToBeSorted[this.count];
            System.arraycopy(this.values, 0, nk2, 0, this.count);
            this.values = nk2;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            Arrays.sort(this.values, 0, this.count, new SortComparer(this.comparators));
        }
        catch (ClassCastException e) {
            throw new XPathException("Non-comparable types found while sorting: " + e.getMessage()).withErrorCode(this.hostLanguage == HostLanguage.XSLT ? "XTDE1030" : "XPTY0004");
        }
    }

    private static class SortComparer
    implements Comparator<ObjectToBeSorted> {
        private AtomicComparer[] comparators;

        public SortComparer(AtomicComparer[] comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(ObjectToBeSorted a, ObjectToBeSorted b) {
            try {
                for (int i = 0; i < this.comparators.length; ++i) {
                    int comp = this.comparators[i].compareAtomicValues(a.sortKeyValues[i], b.sortKeyValues[i]);
                    if (comp == 0) continue;
                    return comp;
                }
            }
            catch (NoDynamicContextException e) {
                throw new AssertionError((Object)("Sorting without dynamic context: " + e.getMessage()));
            }
            return a.originalPosition - b.originalPosition;
        }
    }
}

