/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The method "normalize" puts all Text nodes in the full depth of the sub-tree underneath
 * this Node, including attribute nodes, into a "normal" form where only structure
 * (e.g., elements, comments, processing instructions, CDATA sections, and entity references)
 * separates Text nodes, i.e., there are neither adjacent Text nodes nor empty Text nodes.
 * Create a dom tree consisting of elements, comments, processing instructions, CDATA sections,
 * and entity references nodes seperated by text nodes.  Check the length of the node list of each
 * before and after normalize has been called.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-normalize">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-normalize</a>
 */
public class nodenormalize01 {
    @Test
    @Disabled("entity reference")
    public void testRun() throws Throwable {
        DocumentType docTypeNull = null;

        Document doc = load("staffNS", true);
        DOMImplementation domImpl = doc.getImplementation();
        Document newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "dom:root", docTypeNull);
        Element element1 = newDoc.createElement("element1");
        Element element2 = newDoc.createElement("element2");
        Element element3 = newDoc.createElement("element3");
        Element element4 = newDoc.createElement("element4");
        Element element5 = newDoc.createElement("element5");
        Element element6 = newDoc.createElement("element6");
        Element element7 = newDoc.createElement("element7");
        Text text1 = newDoc.createTextNode("text1");
        Text text2 = newDoc.createTextNode("text2");
        Text text3 = newDoc.createTextNode("text3");
        CDATASection cData = newDoc.createCDATASection("Cdata");
        Comment comment = newDoc.createComment("comment");
        ProcessingInstruction pi = newDoc.createProcessingInstruction("PITarget", "PIData");
        EntityReference entRef = newDoc.createEntityReference("EntRef");
        Element documentElement = newDoc.getDocumentElement();
        documentElement.appendChild(element1);
        element2.appendChild(text1);
        element2.appendChild(text2);
        element2.appendChild(text3);
        element1.appendChild(element2);
        text1 = (Text) text1.cloneNode(false);
        text2 = (Text) text2.cloneNode(false);
        element3.appendChild(entRef);
        element3.appendChild(text1);
        element3.appendChild(text2);
        element1.appendChild(element3);
        text1 = (Text) text1.cloneNode(false);
        text2 = (Text) text2.cloneNode(false);
        element4.appendChild(cData);
        element4.appendChild(text1);
        element4.appendChild(text2);
        element1.appendChild(element4);
        text2 = (Text) text2.cloneNode(false);
        text3 = (Text) text3.cloneNode(false);
        element5.appendChild(comment);
        element5.appendChild(text2);
        element5.appendChild(text3);
        element1.appendChild(element5);
        text2 = (Text) text2.cloneNode(false);
        text3 = (Text) text3.cloneNode(false);
        element6.appendChild(pi);
        element6.appendChild(text2);
        element6.appendChild(text3);
        element1.appendChild(element6);
        entRef = (EntityReference) entRef.cloneNode(false);
        text1 = (Text) text1.cloneNode(false);
        text2 = (Text) text2.cloneNode(false);
        text3 = (Text) text3.cloneNode(false);
        element7.appendChild(entRef);
        element7.appendChild(text1);
        element7.appendChild(text2);
        element7.appendChild(text3);
        element1.appendChild(element7);
        NodeList elementList = element1.getChildNodes();
        assertEquals(6, elementList.getLength(), "nodeNormalize01_1Bef");
        elementList = element2.getChildNodes();
        assertEquals(3, elementList.getLength(), "nodeNormalize01_2Bef");
        elementList = element3.getChildNodes();
        assertEquals(3, elementList.getLength(), "nodeNormalize01_3Bef");
        elementList = element4.getChildNodes();
        assertEquals(3, elementList.getLength(), "nodeNormalize01_4Bef");
        elementList = element5.getChildNodes();
        assertEquals(3, elementList.getLength(), "nodeNormalize01_5Bef");
        elementList = element6.getChildNodes();
        assertEquals(3, elementList.getLength(), "nodeNormalize01_6Bef");
        elementList = element7.getChildNodes();
        assertEquals(4, elementList.getLength(), "nodeNormalize01_7Bef");
        newDoc.normalize();
        elementList = element1.getChildNodes();
        assertEquals(6, elementList.getLength(), "nodeNormalize01_1Aft");
        elementList = element2.getChildNodes();
        assertEquals(1, elementList.getLength(), "nodeNormalize01_2Aft");
        elementList = element3.getChildNodes();
        assertEquals(2, elementList.getLength(), "nodeNormalize01_3Aft");
        elementList = element4.getChildNodes();
        assertEquals(2, elementList.getLength(), "nodeNormalize01_4Aft");
        elementList = element5.getChildNodes();
        assertEquals(2, elementList.getLength(), "nodeNormalize01_5Aft");
        elementList = element6.getChildNodes();
        assertEquals(2, elementList.getLength(), "nodeNormalize01_6Aft");
        elementList = element7.getChildNodes();
        assertEquals(2, elementList.getLength(), "nodeNormalize01_7Aft");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/nodenormalize01";
    }

}
