/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletException;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.impl.PortletRequestImpl;

public abstract class ClientDataRequestImpl
extends PortletRequestImpl
implements ClientDataRequest {
    protected boolean readerAccessed = false;

    public ClientDataRequestImpl(PortletRequestContext requestContext, PortletResponseContext responseContext, String lifecyclePhase) {
        super(requestContext, responseContext, lifecyclePhase);
    }

    private void checkPostedFormData() {
        String contentType;
        if (this.getMethod().equals("POST") && ((contentType = this.getContentType()) == null || contentType.equals("application/x-www-form-urlencoded"))) {
            throw new IllegalStateException("User request HTTP POST data is of type application/x-www-form-urlencoded. This data has been already processed by the portlet-container and is available as request parameters.");
        }
    }

    public String getCharacterEncoding() {
        return this.getServletRequest().getCharacterEncoding();
    }

    public int getContentLength() {
        return this.getServletRequest().getContentLength();
    }

    public long getContentLengthLong() {
        return this.getServletRequest().getContentLengthLong();
    }

    public Part getPart(String name) throws IOException, PortletException {
        try {
            return this.getServletRequest().getPart(name);
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public Collection<Part> getParts() throws IOException, PortletException {
        try {
            return this.getServletRequest().getParts();
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public String getContentType() {
        return this.getServletRequest().getContentType();
    }

    public String getMethod() {
        return this.getServletRequest().getMethod();
    }

    public InputStream getPortletInputStream() throws IOException {
        this.checkPostedFormData();
        return this.getServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        this.checkPostedFormData();
        BufferedReader reader = this.getServletRequest().getReader();
        this.readerAccessed = true;
        return reader;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this.readerAccessed) {
            throw new IllegalStateException("Cannot set character encoding after HTTP body reader is accessed.");
        }
        this.getServletRequest().setCharacterEncoding(encoding);
    }
}

