/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery.jandex;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.FileSystemBeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Files;

public class JandexFileSystemBeanArchiveHandler
extends FileSystemBeanArchiveHandler {
    private final Indexer indexer = new Indexer();

    @Override
    public BeanArchiveBuilder handle(String path) {
        BeanArchiveBuilder builder = super.handle(path);
        if (builder == null) {
            return null;
        }
        builder.setAttribute(JandexDiscoveryStrategy.INDEX_ATTRIBUTE_NAME, this.buildIndex());
        return builder;
    }

    @Override
    protected void add(FileSystemBeanArchiveHandler.Entry entry, BeanArchiveBuilder builder) throws MalformedURLException {
        super.add(entry, builder);
        if (Files.isClass(entry.getName())) {
            this.addToIndex(entry.getUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndex(URL url) {
        InputStream fs = null;
        try {
            fs = url.openStream();
            this.indexer.index(fs);
        }
        catch (IOException ex) {
            CommonLogger.LOG.couldNotOpenStreamForURL(url, ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ex) {
                CommonLogger.LOG.couldNotCloseStreamForURL(url, ex);
            }
        }
    }

    private Index buildIndex() {
        return this.indexer.complete();
    }
}

