/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.impl.DescriptionImpl;

public class CustomPortletModeImpl
implements CustomPortletMode {
    private String pm;
    private boolean managed;
    private final List<Description> descs = new ArrayList<Description>();

    public CustomPortletModeImpl(String cpm) {
        this.pm = cpm;
        this.managed = true;
    }

    public CustomPortletModeImpl(CustomPortletMode cpm) {
        this.pm = cpm.getPortletMode();
        this.managed = cpm.isPortalManaged();
        for (Description desc : cpm.getDescriptions()) {
            this.descs.add(new DescriptionImpl(desc));
        }
    }

    public CustomPortletModeImpl(String pm, boolean mngd, List<Description> descs) {
        this.pm = pm;
        this.managed = mngd;
        this.descs.addAll(descs);
    }

    public String getPortletMode() {
        return this.pm;
    }

    public boolean isPortalManaged() {
        return this.managed;
    }

    public void setPortalManaged(boolean portalManaged) {
        this.managed = portalManaged;
    }

    public Description getDescription(Locale locale) {
        DescriptionImpl ret = null;
        for (Description item : this.descs) {
            if (!item.getLocale().equals(locale)) continue;
            ret = new DescriptionImpl(item);
        }
        return ret;
    }

    public List<Description> getDescriptions() {
        return new ArrayList<Description>(this.descs);
    }

    public void addDescription(Description desc) {
        this.descs.add(desc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pm == null ? 0 : this.pm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomPortletModeImpl other = (CustomPortletModeImpl)obj;
        return !(this.pm == null ? other.pm != null : !this.pm.equals(other.pm));
    }
}

