/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.common.KubernetesType;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.util.ProxyContentTypeRequestBody;
import io.kubernetes.client.util.Strings;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.generic.KubernetesApiResponse;
import io.kubernetes.client.util.generic.options.CreateOptions;
import io.kubernetes.client.util.generic.options.DeleteOptions;
import io.kubernetes.client.util.generic.options.GetOptions;
import io.kubernetes.client.util.generic.options.ListOptions;
import io.kubernetes.client.util.generic.options.PatchOptions;
import io.kubernetes.client.util.generic.options.UpdateOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;

public class GenericKubernetesApi<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> {
    private static final String PARTIAL_OBJECT_METADATA_HEADER = "application/json;as=PartialObjectMetadata;g=meta.k8s.io;v=v1,application/json";
    private static final String PARTIAL_OBJECT_METADATA_LIST_HEADER = "application/json;as=PartialObjectMetadataList;g=meta.k8s.io;v=v1,application/json";
    private final Class<ApiType> apiTypeClass;
    private final Class<ApiListType> apiListTypeClass;
    private final String apiGroup;
    private final String apiVersion;
    private final String resourcePlural;
    private final CustomObjectsApi customObjectsApi;

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural) {
        this(apiTypeClass, apiListTypeClass, apiGroup, apiVersion, resourcePlural, new CustomObjectsApi(Configuration.getDefaultApiClient()));
    }

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural, ApiClient apiClient) {
        this(apiTypeClass, apiListTypeClass, apiGroup, apiVersion, resourcePlural, new CustomObjectsApi(apiClient));
    }

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural, CustomObjectsApi customObjectsApi) {
        this.apiGroup = apiGroup;
        this.apiVersion = apiVersion;
        this.resourcePlural = resourcePlural;
        this.apiTypeClass = apiTypeClass;
        this.apiListTypeClass = apiListTypeClass;
        this.customObjectsApi = customObjectsApi;
    }

    ApiClient getApiClient() {
        return this.customObjectsApi.getApiClient();
    }

    public KubernetesApiResponse<ApiType> get(String name) {
        return this.get(name, new GetOptions());
    }

    public KubernetesApiResponse<ApiType> get(String namespace, String name) {
        return this.get(namespace, name, new GetOptions());
    }

    public Future<KubernetesApiResponse<ApiType>> getAsync(String name, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.getAsync(name, new GetOptions(), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> getAsync(String namespace, String name, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.getAsync(namespace, name, new GetOptions(), callback);
    }

    public KubernetesApiResponse<ApiListType> list() {
        return this.list(new ListOptions());
    }

    public KubernetesApiResponse<ApiListType> list(String namespace) {
        return this.list(namespace, new ListOptions());
    }

    public Future<KubernetesApiResponse<ApiListType>> listAsync(@Nonnull Consumer<KubernetesApiResponse<ApiListType>> callback) {
        return this.listAsync(new ListOptions(), callback);
    }

    public Future<KubernetesApiResponse<ApiListType>> listAsync(String namespace, @Nonnull Consumer<KubernetesApiResponse<ApiListType>> callback) {
        return this.listAsync(namespace, new ListOptions(), callback);
    }

    public KubernetesApiResponse<ApiType> create(ApiType object) {
        return this.create(object, new CreateOptions());
    }

    public Future<KubernetesApiResponse<ApiType>> createAsync(ApiType object, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.createAsync(object, new CreateOptions(), callback);
    }

    public KubernetesApiResponse<ApiType> update(ApiType object) {
        return this.update(object, new UpdateOptions());
    }

    public Future<KubernetesApiResponse<ApiType>> updateAsync(ApiType object, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.updateAsync(object, new UpdateOptions(), callback);
    }

    public KubernetesApiResponse<ApiType> patch(String name, String patchType, V1Patch patch) {
        return this.patch(name, patchType, patch, new PatchOptions());
    }

    public KubernetesApiResponse<ApiType> patch(String namespace, String name, String patchType, V1Patch patch) {
        return this.patch(namespace, name, patchType, patch, new PatchOptions());
    }

    public Future<KubernetesApiResponse<ApiType>> patchAsync(String name, String patchType, V1Patch patch, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.patchAsync(name, patchType, patch, new PatchOptions(), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> patchAsync(String namespace, String name, String patchType, V1Patch patch, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.patchAsync(namespace, name, patchType, patch, new PatchOptions(), callback);
    }

    public KubernetesApiResponse<ApiType> delete(String name) {
        return this.delete(name, new DeleteOptions());
    }

    public KubernetesApiResponse<ApiType> delete(String namespace, String name) {
        return this.delete(namespace, name, new DeleteOptions());
    }

    public Future<KubernetesApiResponse<ApiType>> deleteAsync(String name, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.deleteAsync(name, new DeleteOptions(), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> deleteAsync(String namespace, String name, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.deleteAsync(namespace, name, new DeleteOptions(), callback);
    }

    public Watchable<ApiType> watch() throws ApiException {
        return this.watch(new ListOptions());
    }

    public Watchable<ApiType> watch(String namespace) throws ApiException {
        return this.watch(namespace, new ListOptions());
    }

    public KubernetesApiResponse<ApiType> get(String name, GetOptions getOptions) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterGetCallBuilder(name, getOptions));
    }

    private CallBuilder makeClusterGetCallBuilder(String name, GetOptions getOptions) {
        return () -> this.adaptGetCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.getClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, null), getOptions);
    }

    private Call adaptGetCall(ApiClient apiClient, Call call, GetOptions getOptions) {
        if (Optional.ofNullable(getOptions).map(GetOptions::isPartialObjectMetadataRequest).orElse(Boolean.FALSE).booleanValue()) {
            Request request = call.request();
            return apiClient.getHttpClient().newCall(request.newBuilder().header("Accept", PARTIAL_OBJECT_METADATA_HEADER).build());
        }
        return call;
    }

    public Future<KubernetesApiResponse<ApiType>> getAsync(String name, GetOptions getOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterGetCallBuilder(name, getOptions), callback);
    }

    public KubernetesApiResponse<ApiType> get(String namespace, String name, GetOptions getOptions) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedGetCallBuilder(namespace, name, getOptions));
    }

    private CallBuilder makeNamespacedGetCallBuilder(String namespace, String name, GetOptions getOptions) {
        return () -> this.adaptGetCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.getNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, null), getOptions);
    }

    public Future<KubernetesApiResponse<ApiType>> getAsync(String namespace, String name, GetOptions getOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedGetCallBuilder(namespace, name, getOptions), callback);
    }

    public KubernetesApiResponse<ApiListType> list(ListOptions listOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiListTypeClass, this.makeClusterListCallBuilder(listOptions));
    }

    private CallBuilder makeClusterListCallBuilder(ListOptions listOptions) {
        return () -> this.adaptListCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.listClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, null, Boolean.valueOf(false), listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), null, listOptions.getTimeoutSeconds(), Boolean.valueOf(false), null), listOptions);
    }

    private Call adaptListCall(ApiClient apiClient, Call call, ListOptions listOptions) {
        if (Optional.ofNullable(listOptions).map(ListOptions::isPartialObjectMetadataListRequest).orElse(Boolean.FALSE).booleanValue()) {
            Request request = call.request();
            return apiClient.getHttpClient().newCall(request.newBuilder().header("Accept", PARTIAL_OBJECT_METADATA_LIST_HEADER).build());
        }
        return call;
    }

    public KubernetesApiResponse<ApiListType> list(String namespace, ListOptions listOptions) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiListTypeClass, this.makeNamespacedListCallBuilder(namespace, listOptions));
    }

    private CallBuilder makeNamespacedListCallBuilder(String namespace, ListOptions listOptions) {
        return () -> this.adaptListCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.listNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, null, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), null, listOptions.getTimeoutSeconds(), Boolean.valueOf(false), null), listOptions);
    }

    public Future<KubernetesApiResponse<ApiListType>> listAsync(ListOptions listOptions, @Nonnull Consumer<KubernetesApiResponse<ApiListType>> callback) {
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiListTypeClass, this.makeClusterListCallBuilder(listOptions), callback);
    }

    public Future<KubernetesApiResponse<ApiListType>> listAsync(String namespace, ListOptions listOptions, @Nonnull Consumer<KubernetesApiResponse<ApiListType>> callback) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiListTypeClass, this.makeNamespacedListCallBuilder(namespace, listOptions), callback);
    }

    public KubernetesApiResponse<ApiType> create(ApiType object, CreateOptions createOptions) {
        boolean isNamespaced;
        V1ObjectMeta objectMeta = object.getMetadata();
        boolean bl = isNamespaced = !Strings.isNullOrEmpty(objectMeta.getNamespace());
        if (isNamespaced) {
            return this.create(objectMeta.getNamespace(), object, createOptions);
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterCreateCallBuilder(object, createOptions));
    }

    private CallBuilder makeClusterCreateCallBuilder(ApiType object, CreateOptions createOptions) {
        return () -> this.customObjectsApi.createClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, (Object)object, null, createOptions.getDryRun(), createOptions.getFieldManager(), null);
    }

    public KubernetesApiResponse<ApiType> create(String namespace, ApiType object, CreateOptions createOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedCreateCallBuilder(namespace, object, createOptions));
    }

    private CallBuilder makeNamespacedCreateCallBuilder(String namespace, ApiType object, CreateOptions createOptions) {
        return () -> this.customObjectsApi.createNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, (Object)object, null, createOptions.getDryRun(), createOptions.getFieldManager(), null);
    }

    public Future<KubernetesApiResponse<ApiType>> createAsync(ApiType object, CreateOptions createOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        boolean isNamespaced;
        V1ObjectMeta objectMeta = object.getMetadata();
        boolean bl = isNamespaced = !Strings.isNullOrEmpty(objectMeta.getNamespace());
        if (isNamespaced) {
            return this.createAsync(objectMeta.getNamespace(), object, createOptions, callback);
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterCreateCallBuilder(object, createOptions), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> createAsync(String namespace, ApiType object, CreateOptions createOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedCreateCallBuilder(namespace, object, createOptions), callback);
    }

    public KubernetesApiResponse<ApiType> update(ApiType object, UpdateOptions updateOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeUpdateCallBuilder(object, updateOptions));
    }

    private CallBuilder makeUpdateCallBuilder(ApiType object, UpdateOptions updateOptions) {
        V1ObjectMeta objectMeta = object.getMetadata();
        boolean isNamespaced = !Strings.isNullOrEmpty(objectMeta.getNamespace());
        return () -> isNamespaced ? this.customObjectsApi.replaceNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, objectMeta.getNamespace(), this.resourcePlural, objectMeta.getName(), (Object)object, updateOptions.getDryRun(), updateOptions.getFieldManager(), null) : this.customObjectsApi.replaceClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, objectMeta.getName(), (Object)object, updateOptions.getDryRun(), updateOptions.getFieldManager(), null);
    }

    public Future<KubernetesApiResponse<ApiType>> updateAsync(ApiType object, UpdateOptions updateOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeUpdateCallBuilder(object, updateOptions), callback);
    }

    public KubernetesApiResponse<ApiType> updateStatus(ApiType object, Function<ApiType, Object> status) {
        return this.updateStatus(object, status, new UpdateOptions());
    }

    public KubernetesApiResponse<ApiType> updateStatus(ApiType object, Function<ApiType, Object> status, UpdateOptions updateOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeUpdateStatusCallBuilder(object, status, updateOptions));
    }

    private CallBuilder makeUpdateStatusCallBuilder(ApiType object, Function<ApiType, Object> status, UpdateOptions updateOptions) {
        V1ObjectMeta objectMeta = object.getMetadata();
        boolean isNamespaced = !Strings.isNullOrEmpty(objectMeta.getNamespace());
        return () -> isNamespaced ? this.customObjectsApi.patchNamespacedCustomObjectStatusCall(this.apiGroup, this.apiVersion, objectMeta.getNamespace(), this.resourcePlural, objectMeta.getName(), Arrays.asList(new StatusPatch(status.apply(object))), updateOptions.getDryRun(), updateOptions.getFieldManager(), null, null) : this.customObjectsApi.patchClusterCustomObjectStatusCall(this.apiGroup, this.apiVersion, this.resourcePlural, objectMeta.getName(), Arrays.asList(new StatusPatch(status.apply(object))), updateOptions.getDryRun(), updateOptions.getFieldManager(), null, null);
    }

    public Future<KubernetesApiResponse<ApiType>> updateStatusAsync(ApiType object, Function<ApiType, Object> status, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.updateStatusAsync(object, status, new UpdateOptions(), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> updateStatusAsync(ApiType object, Function<ApiType, Object> status, UpdateOptions updateOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeUpdateStatusCallBuilder(object, status, updateOptions), callback);
    }

    private Call adaptPatchCall(ApiClient apiClient, Call call, String patchType) {
        Request request = call.request();
        return apiClient.getHttpClient().newCall(request.newBuilder().patch((RequestBody)new ProxyContentTypeRequestBody(request.body(), patchType)).build());
    }

    public KubernetesApiResponse<ApiType> patch(String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterPatchCallBuilder(name, patchType, patch, patchOptions));
    }

    private CallBuilder makeClusterPatchCallBuilder(String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        return () -> this.adaptPatchCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.patchClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, (Object)patch, patchOptions.getDryRun(), patchOptions.getFieldManager(), patchOptions.getForce(), null), patchType);
    }

    public KubernetesApiResponse<ApiType> patch(String namespace, String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedPatchCallBuilder(namespace, name, patchType, patch, patchOptions));
    }

    private CallBuilder makeNamespacedPatchCallBuilder(String namespace, String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        return () -> this.adaptPatchCall(this.customObjectsApi.getApiClient(), this.customObjectsApi.patchNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, (Object)patch, patchOptions.getDryRun(), patchOptions.getFieldManager(), patchOptions.getForce(), null), patchType);
    }

    public Future<KubernetesApiResponse<ApiType>> patchAsync(String name, String patchType, V1Patch patch, PatchOptions patchOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterPatchCallBuilder(name, patchType, patch, patchOptions), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> patchAsync(String namespace, String name, String patchType, V1Patch patch, PatchOptions patchOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedPatchCallBuilder(namespace, name, patchType, patch, patchOptions), callback);
    }

    public KubernetesApiResponse<ApiType> delete(String name, DeleteOptions deleteOptions) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterDeleteCallBuilder(name, deleteOptions));
    }

    private CallBuilder makeClusterDeleteCallBuilder(String name, DeleteOptions deleteOptions) {
        return () -> this.customObjectsApi.deleteClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, null, null, null, null, (V1DeleteOptions)deleteOptions, null);
    }

    public KubernetesApiResponse<ApiType> delete(String namespace, String name, DeleteOptions deleteOptions) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedDeleteCallBuilder(namespace, name, deleteOptions));
    }

    private CallBuilder makeNamespacedDeleteCallBuilder(String namespace, String name, DeleteOptions deleteOptions) {
        return () -> this.customObjectsApi.deleteNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, null, null, null, null, (V1DeleteOptions)deleteOptions, null);
    }

    public Future<KubernetesApiResponse<ApiType>> deleteAsync(String name, DeleteOptions deleteOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeClusterDeleteCallBuilder(name, deleteOptions), callback);
    }

    public Future<KubernetesApiResponse<ApiType>> deleteAsync(String namespace, String name, DeleteOptions deleteOptions, @Nonnull Consumer<KubernetesApiResponse<ApiType>> callback) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCallAsync(this.customObjectsApi.getApiClient(), this.apiTypeClass, this.makeNamespacedDeleteCallBuilder(namespace, name, deleteOptions), callback);
    }

    public Watchable<ApiType> watch(ListOptions listOptions) throws ApiException {
        Call call = this.customObjectsApi.listClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, null, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), null, listOptions.getTimeoutSeconds(), Boolean.valueOf(true), null);
        call = this.tweakCallForCoreV1Group(call);
        return Watch.createWatch(this.customObjectsApi.getApiClient(), call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{this.apiTypeClass}).getType());
    }

    public Watchable<ApiType> watch(String namespace, ListOptions listOptions) throws ApiException {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        Call call = this.customObjectsApi.listNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, null, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), null, listOptions.getTimeoutSeconds(), Boolean.valueOf(true), null);
        call = this.tweakCallForCoreV1Group(call);
        return Watch.createWatch(this.customObjectsApi.getApiClient(), call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{this.apiTypeClass}).getType());
    }

    private static <DataType extends KubernetesType> KubernetesApiResponse<DataType> getKubernetesApiResponse(Class<DataType> dataClass, JsonElement element, Gson gson) {
        return GenericKubernetesApi.getKubernetesApiResponse(dataClass, element, gson, 200);
    }

    private static <DataType extends KubernetesType> KubernetesApiResponse<DataType> getKubernetesApiResponse(Class<DataType> dataClass, JsonElement element, Gson gson, int httpStatusCode) {
        boolean isStatus;
        JsonElement kindElement = element.getAsJsonObject().get("kind");
        boolean bl = isStatus = kindElement != null && "Status".equals(kindElement.getAsString());
        if (isStatus) {
            return new KubernetesApiResponse((V1Status)gson.fromJson(element, V1Status.class), httpStatusCode);
        }
        return new KubernetesApiResponse<KubernetesType>((KubernetesType)gson.fromJson(element, dataClass));
    }

    private Call prepareCall(CallBuilder callBuilder) throws ApiException {
        Call call = callBuilder.build();
        return this.tweakCallForCoreV1Group(call);
    }

    private void checkForIOException(ApiException e) {
        if (e.getCause() instanceof IOException) {
            throw new IllegalStateException(e.getCause());
        }
    }

    private <DataType extends KubernetesType> KubernetesApiResponse<DataType> responseFromApiException(ApiClient apiClient, ApiException e) {
        V1Status status;
        this.checkForIOException(e);
        try {
            status = (V1Status)apiClient.getJSON().deserialize(e.getResponseBody(), V1Status.class);
        }
        catch (JsonSyntaxException jsonEx) {
            return new KubernetesApiResponse(new V1Status().code(Integer.valueOf(e.getCode())).message(e.getResponseBody()), e.getCode());
        }
        if (null == status) {
            throw new RuntimeException(e);
        }
        return new KubernetesApiResponse(status, e.getCode());
    }

    private <DataType extends KubernetesType> KubernetesApiResponse<DataType> executeCall(ApiClient apiClient, Class<DataType> dataClass, CallBuilder callBuilder) {
        try {
            Call call = this.prepareCall(callBuilder);
            JsonElement element = (JsonElement)apiClient.execute(call, JsonElement.class).getData();
            return GenericKubernetesApi.getKubernetesApiResponse(dataClass, element, apiClient.getJSON().getGson());
        }
        catch (ApiException e) {
            return this.responseFromApiException(apiClient, e);
        }
    }

    private <DataType extends KubernetesType> Call prepareCall(CallBuilder callBuilder, @Nonnull Consumer<KubernetesApiResponse<DataType>> callback) throws ApiException {
        Call call = this.prepareCall(callBuilder);
        if (callback instanceof CallAdapter) {
            call = (Call)((CallAdapter)((Object)callback)).apply(call);
        }
        return call;
    }

    private <DataType extends KubernetesType> Future<KubernetesApiResponse<DataType>> executeCallAsync(final ApiClient apiClient, final Class<DataType> dataClass, CallBuilder callBuilder, final @Nonnull Consumer<KubernetesApiResponse<DataType>> callback) {
        try {
            final Call call = this.prepareCall(callBuilder, callback);
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference result = new AtomicReference();
            apiClient.executeAsync(call, JsonElement.class, (ApiCallback)new ApiCallback<JsonElement>(){

                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    if (latch.getCount() > 0L) {
                        KubernetesApiResponse r = GenericKubernetesApi.this.responseFromApiException(apiClient, e);
                        result.set(r);
                        latch.countDown();
                        callback.accept(r);
                    }
                }

                public void onSuccess(JsonElement element, int statusCode, Map<String, List<String>> responseHeaders) {
                    KubernetesApiResponse r = GenericKubernetesApi.getKubernetesApiResponse(dataClass, element, apiClient.getJSON().getGson());
                    if (latch.getCount() > 0L) {
                        result.set(r);
                        latch.countDown();
                        callback.accept(r);
                    }
                }

                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                }

                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                }
            });
            return new Future<KubernetesApiResponse<DataType>>(){
                private final AtomicBoolean isCanceled = new AtomicBoolean(false);

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    if (this.isDone()) {
                        return false;
                    }
                    call.cancel();
                    this.isCanceled.set(true);
                    latch.countDown();
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return this.isCanceled.get();
                }

                @Override
                public boolean isDone() {
                    return latch.getCount() == 0L;
                }

                @Override
                public KubernetesApiResponse<DataType> get() throws InterruptedException {
                    latch.await();
                    if (this.isCancelled()) {
                        throw new CancellationException();
                    }
                    return (KubernetesApiResponse)result.get();
                }

                @Override
                public KubernetesApiResponse<DataType> get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, TimeoutException {
                    if (latch.await(timeout, unit)) {
                        if (this.isCancelled()) {
                            throw new CancellationException();
                        }
                        return (KubernetesApiResponse)result.get();
                    }
                    throw new TimeoutException();
                }
            };
        }
        catch (ApiException e) {
            this.checkForIOException(e);
            throw new RuntimeException(e);
        }
    }

    private Call tweakCallForCoreV1Group(Call call) {
        if (!this.apiGroup.equals("")) {
            return call;
        }
        HttpUrl url = call.request().url();
        String basePath = this.customObjectsApi.getApiClient().getBasePath();
        int offset = 0;
        for (int i = basePath.indexOf("://") + 3; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != '/') continue;
            ++offset;
        }
        HttpUrl tweakedUrl = url.newBuilder().removePathSegment(offset + 1).setPathSegment(offset, "api").build();
        return this.customObjectsApi.getApiClient().getHttpClient().newCall(call.request().newBuilder().url(tweakedUrl).build());
    }

    private static interface CallBuilder {
        public Call build() throws ApiException;
    }

    static interface CallAdapter
    extends UnaryOperator<Call> {
    }

    public static class StatusPatch {
        private String op = "replace";
        private String path = "/status";
        private Object value;

        public StatusPatch(Object value) {
            this.value = value;
        }

        public String getOp() {
            return this.op;
        }

        public void setOp(String op) {
            this.op = op;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

