/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.TopicExchange;
import org.apache.qpid.server.exchange.topic.TopicExchangeResult;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicNormalizer;
import org.apache.qpid.server.exchange.topic.TopicParser;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.FilterSupport;
import org.apache.qpid.server.filter.Filterable;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicExchangeImpl
extends AbstractExchange<TopicExchangeImpl>
implements TopicExchange<TopicExchangeImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicExchangeImpl.class);
    private final TopicParser _parser = new TopicParser();
    private final Map<String, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<String, TopicExchangeResult>();
    private final Map<AbstractExchange.BindingIdentifier, Map<String, Object>> _bindings = new HashMap<AbstractExchange.BindingIdentifier, Map<String, Object>>();

    @ManagedObjectFactoryConstructor
    public TopicExchangeImpl(Map<String, Object> attributes, QueueManagingVirtualHost<?> vhost) {
        super(attributes, vhost);
    }

    @Override
    protected synchronized void onBindingUpdated(AbstractExchange.BindingIdentifier binding, Map<String, Object> newArguments) throws AMQInvalidArgumentException {
        String bindingKey = binding.getBindingKey();
        MessageDestination destination = binding.getDestination();
        LOGGER.debug("Updating binding of queue {} with routing key {}", (Object)destination.getName(), (Object)bindingKey);
        String routingKey = TopicNormalizer.normalize(bindingKey);
        if (this._bindings.containsKey(binding)) {
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            this.updateTopicExchangeResult(result, binding, newArguments);
        }
    }

    private synchronized void bind(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        String bindingKey = binding.getBindingKey();
        MessageDestination messageDestination = binding.getDestination();
        LOGGER.debug("Registering messageDestination {} with routing key {}", (Object)messageDestination.getName(), (Object)bindingKey);
        String routingKey = TopicNormalizer.normalize(bindingKey);
        TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
        if (this._bindings.containsKey(binding)) {
            this.updateTopicExchangeResult(result, binding, arguments);
        } else {
            if (result == null) {
                result = new TopicExchangeResult();
                if (FilterSupport.argumentsContainFilter(arguments)) {
                    result.addFilteredDestination(messageDestination, FilterSupport.createMessageFilter(arguments, messageDestination));
                } else {
                    result.addUnfilteredDestination(messageDestination);
                }
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else if (FilterSupport.argumentsContainFilter(arguments)) {
                result.addFilteredDestination(messageDestination, FilterSupport.createMessageFilter(arguments, messageDestination));
            } else {
                result.addUnfilteredDestination(messageDestination);
            }
            this._bindings.put(binding, arguments);
            result.addBinding(binding, arguments);
        }
    }

    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> void doRoute(M payload, String routingAddress, InstanceProperties instanceProperties, RoutingResult<M> result) {
        String routingKey = routingAddress == null ? "" : routingAddress;
        Map<MessageDestination, Set<String>> matchedDestinations = this.getMatchedDestinations(Filterable.Factory.newInstance(payload, instanceProperties), routingKey);
        if (!matchedDestinations.isEmpty()) {
            for (Map.Entry<MessageDestination, Set<String>> entry : matchedDestinations.entrySet()) {
                MessageDestination destination = entry.getKey();
                entry.getValue().forEach(key -> result.add(destination.route(payload, (String)key, instanceProperties)));
            }
        }
    }

    private synchronized boolean unbind(AbstractExchange.BindingIdentifier binding) {
        if (this._bindings.containsKey(binding)) {
            Map<String, Object> bindingArgs = this._bindings.remove(binding);
            LOGGER.debug("deregisterQueue args: {}", bindingArgs);
            String bindingKey = TopicNormalizer.normalize(binding.getBindingKey());
            TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
            result.removeBinding(binding);
            if (FilterSupport.argumentsContainFilter(bindingArgs)) {
                try {
                    result.removeFilteredDestination(binding.getDestination(), FilterSupport.createMessageFilter(bindingArgs, binding.getDestination()));
                }
                catch (AMQInvalidArgumentException e) {
                    return false;
                }
            } else {
                result.removeUnfilteredDestination(binding.getDestination());
            }
            return true;
        }
        return false;
    }

    private Map<MessageDestination, Set<String>> getMatchedDestinations(Filterable message, String routingKey) {
        Collection<TopicMatcherResult> results = this._parser.parse(routingKey);
        if (!results.isEmpty()) {
            HashMap<MessageDestination, Set<String>> matchedDestinations = new HashMap<MessageDestination, Set<String>>();
            for (TopicMatcherResult result : results) {
                if (!(result instanceof TopicExchangeResult)) continue;
                ((TopicExchangeResult)result).processMessage(message, matchedDestinations, routingKey);
            }
            return matchedDestinations;
        }
        return Collections.emptyMap();
    }

    @Override
    protected void onBind(AbstractExchange.BindingIdentifier binding, Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this.bind(binding, arguments);
    }

    @Override
    protected void onUnbind(AbstractExchange.BindingIdentifier binding) {
        this.unbind(binding);
    }

    private void updateTopicExchangeResult(TopicExchangeResult result, AbstractExchange.BindingIdentifier binding, Map<String, Object> newArguments) throws AMQInvalidArgumentException {
        Map<String, Object> oldArgs = this._bindings.put(binding, newArguments);
        MessageDestination destination = binding.getDestination();
        if (FilterSupport.argumentsContainFilter(newArguments)) {
            if (FilterSupport.argumentsContainFilter(oldArgs)) {
                result.replaceDestinationFilter(destination, FilterSupport.createMessageFilter(oldArgs, destination), FilterSupport.createMessageFilter(newArguments, destination));
            } else {
                result.addFilteredDestination(destination, FilterSupport.createMessageFilter(newArguments, destination));
                result.removeUnfilteredDestination(destination);
            }
        } else if (FilterSupport.argumentsContainFilter(oldArgs)) {
            result.addUnfilteredDestination(destination);
            result.removeFilteredDestination(destination, FilterSupport.createMessageFilter(oldArgs, destination));
        }
        result.addBinding(binding, newArguments);
    }
}

