/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.TypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;

public class ULongTypeConstructor
implements TypeConstructor<UnsignedLong> {
    private static final ULongTypeConstructor INSTANCE = new ULongTypeConstructor();

    public static ULongTypeConstructor getInstance() {
        return INSTANCE;
    }

    private ULongTypeConstructor() {
    }

    @Override
    public UnsignedLong construct(QpidByteBuffer in, ValueHandler handler) throws AmqpErrorException {
        if (in.hasRemaining(8)) {
            long l = in.getLong();
            return UnsignedLong.valueOf(l);
        }
        throw new AmqpErrorException(AmqpError.DECODE_ERROR, "Cannot construct ulong: insufficient input data", new Object[0]);
    }
}

