/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ranger.authorization.atlas.authorizer;

import org.apache.atlas.authorize.AtlasResourceTypes;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAtlasResource extends RangerAccessResourceImpl {
    public static final String KEY_TYPE = "type";
    public static final String KEY_ENTITY = "entity";
    public static final String KEY_OPERATION = "operation";
    public static final String KEY_TAXONOMY = "taxonomy";
    public static final String KEY_TERM = "term";

    private static final Logger LOG = LoggerFactory.getLogger(RangerAtlasResource.class);

    public RangerAtlasResource(AtlasResourceTypes resourceType, String atlasResource) {
        switch (resourceType) {
            case TYPE:
                setValue(KEY_TYPE, atlasResource);
                break;
            case ENTITY:
                setValue(KEY_ENTITY, atlasResource);
                break;
            case OPERATION:
                setValue(KEY_OPERATION, atlasResource);
                break;
            case TAXONOMY:
                setValue(KEY_TAXONOMY, atlasResource);
                break;
            case TERM:
                setValue(KEY_TERM, atlasResource);
                break;
            default:
                LOG.warn("Invalid Resource : " + atlasResource);
                break;
        }

    }

}
