/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.filestructurefinder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.elasticsearch.client.ml.filestructurefinder.FieldStats;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class FileStructure
implements ToXContentObject {
    public static final ParseField NUM_LINES_ANALYZED = new ParseField("num_lines_analyzed", new String[0]);
    public static final ParseField NUM_MESSAGES_ANALYZED = new ParseField("num_messages_analyzed", new String[0]);
    public static final ParseField SAMPLE_START = new ParseField("sample_start", new String[0]);
    public static final ParseField CHARSET = new ParseField("charset", new String[0]);
    public static final ParseField HAS_BYTE_ORDER_MARKER = new ParseField("has_byte_order_marker", new String[0]);
    public static final ParseField FORMAT = new ParseField("format", new String[0]);
    public static final ParseField MULTILINE_START_PATTERN = new ParseField("multiline_start_pattern", new String[0]);
    public static final ParseField EXCLUDE_LINES_PATTERN = new ParseField("exclude_lines_pattern", new String[0]);
    public static final ParseField COLUMN_NAMES = new ParseField("column_names", new String[0]);
    public static final ParseField HAS_HEADER_ROW = new ParseField("has_header_row", new String[0]);
    public static final ParseField DELIMITER = new ParseField("delimiter", new String[0]);
    public static final ParseField QUOTE = new ParseField("quote", new String[0]);
    public static final ParseField SHOULD_TRIM_FIELDS = new ParseField("should_trim_fields", new String[0]);
    public static final ParseField GROK_PATTERN = new ParseField("grok_pattern", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField JODA_TIMESTAMP_FORMATS = new ParseField("joda_timestamp_formats", new String[0]);
    public static final ParseField JAVA_TIMESTAMP_FORMATS = new ParseField("java_timestamp_formats", new String[0]);
    public static final ParseField NEED_CLIENT_TIMEZONE = new ParseField("need_client_timezone", new String[0]);
    public static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    public static final ParseField INGEST_PIPELINE = new ParseField("ingest_pipeline", new String[0]);
    public static final ParseField FIELD_STATS = new ParseField("field_stats", new String[0]);
    public static final ParseField EXPLANATION = new ParseField("explanation", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("file_structure", true, Builder::new);
    private final int numLinesAnalyzed;
    private final int numMessagesAnalyzed;
    private final String sampleStart;
    private final String charset;
    private final Boolean hasByteOrderMarker;
    private final Format format;
    private final String multilineStartPattern;
    private final String excludeLinesPattern;
    private final List<String> columnNames;
    private final Boolean hasHeaderRow;
    private final Character delimiter;
    private final Character quote;
    private final Boolean shouldTrimFields;
    private final String grokPattern;
    private final List<String> jodaTimestampFormats;
    private final List<String> javaTimestampFormats;
    private final String timestampField;
    private final boolean needClientTimezone;
    private final SortedMap<String, Object> mappings;
    private final Map<String, Object> ingestPipeline;
    private final SortedMap<String, FieldStats> fieldStats;
    private final List<String> explanation;

    private FileStructure(int numLinesAnalyzed, int numMessagesAnalyzed, String sampleStart, String charset, Boolean hasByteOrderMarker, Format format, String multilineStartPattern, String excludeLinesPattern, List<String> columnNames, Boolean hasHeaderRow, Character delimiter, Character quote, Boolean shouldTrimFields, String grokPattern, String timestampField, List<String> jodaTimestampFormats, List<String> javaTimestampFormats, boolean needClientTimezone, Map<String, Object> mappings, Map<String, Object> ingestPipeline, Map<String, FieldStats> fieldStats, List<String> explanation) {
        this.numLinesAnalyzed = numLinesAnalyzed;
        this.numMessagesAnalyzed = numMessagesAnalyzed;
        this.sampleStart = Objects.requireNonNull(sampleStart);
        this.charset = Objects.requireNonNull(charset);
        this.hasByteOrderMarker = hasByteOrderMarker;
        this.format = Objects.requireNonNull(format);
        this.multilineStartPattern = multilineStartPattern;
        this.excludeLinesPattern = excludeLinesPattern;
        this.columnNames = columnNames == null ? null : Collections.unmodifiableList(new ArrayList<String>(columnNames));
        this.hasHeaderRow = hasHeaderRow;
        this.delimiter = delimiter;
        this.quote = quote;
        this.shouldTrimFields = shouldTrimFields;
        this.grokPattern = grokPattern;
        this.timestampField = timestampField;
        this.jodaTimestampFormats = jodaTimestampFormats == null ? null : Collections.unmodifiableList(new ArrayList<String>(jodaTimestampFormats));
        this.javaTimestampFormats = javaTimestampFormats == null ? null : Collections.unmodifiableList(new ArrayList<String>(javaTimestampFormats));
        this.needClientTimezone = needClientTimezone;
        this.mappings = Collections.unmodifiableSortedMap(new TreeMap<String, Object>(mappings));
        this.ingestPipeline = ingestPipeline == null ? null : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(ingestPipeline));
        this.fieldStats = Collections.unmodifiableSortedMap(new TreeMap<String, FieldStats>(fieldStats));
        this.explanation = explanation == null ? null : Collections.unmodifiableList(new ArrayList<String>(explanation));
    }

    public int getNumLinesAnalyzed() {
        return this.numLinesAnalyzed;
    }

    public int getNumMessagesAnalyzed() {
        return this.numMessagesAnalyzed;
    }

    public String getSampleStart() {
        return this.sampleStart;
    }

    public String getCharset() {
        return this.charset;
    }

    public Boolean getHasByteOrderMarker() {
        return this.hasByteOrderMarker;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getMultilineStartPattern() {
        return this.multilineStartPattern;
    }

    public String getExcludeLinesPattern() {
        return this.excludeLinesPattern;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public Character getQuote() {
        return this.quote;
    }

    public Boolean getShouldTrimFields() {
        return this.shouldTrimFields;
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public List<String> getJodaTimestampFormats() {
        return this.jodaTimestampFormats;
    }

    public List<String> getJavaTimestampFormats() {
        return this.javaTimestampFormats;
    }

    public boolean needClientTimezone() {
        return this.needClientTimezone;
    }

    public SortedMap<String, Object> getMappings() {
        return this.mappings;
    }

    public Map<String, Object> getIngestPipeline() {
        return this.ingestPipeline;
    }

    public SortedMap<String, FieldStats> getFieldStats() {
        return this.fieldStats;
    }

    public List<String> getExplanation() {
        return this.explanation;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_LINES_ANALYZED.getPreferredName(), this.numLinesAnalyzed);
        builder.field(NUM_MESSAGES_ANALYZED.getPreferredName(), this.numMessagesAnalyzed);
        builder.field(SAMPLE_START.getPreferredName(), this.sampleStart);
        builder.field(CHARSET.getPreferredName(), this.charset);
        if (this.hasByteOrderMarker != null) {
            builder.field(HAS_BYTE_ORDER_MARKER.getPreferredName(), this.hasByteOrderMarker.booleanValue());
        }
        builder.field(FORMAT.getPreferredName(), (Object)this.format);
        if (this.multilineStartPattern != null && !this.multilineStartPattern.isEmpty()) {
            builder.field(MULTILINE_START_PATTERN.getPreferredName(), this.multilineStartPattern);
        }
        if (this.excludeLinesPattern != null && !this.excludeLinesPattern.isEmpty()) {
            builder.field(EXCLUDE_LINES_PATTERN.getPreferredName(), this.excludeLinesPattern);
        }
        if (this.columnNames != null && !this.columnNames.isEmpty()) {
            builder.field(COLUMN_NAMES.getPreferredName(), this.columnNames);
        }
        if (this.hasHeaderRow != null) {
            builder.field(HAS_HEADER_ROW.getPreferredName(), this.hasHeaderRow.booleanValue());
        }
        if (this.delimiter != null) {
            builder.field(DELIMITER.getPreferredName(), String.valueOf(this.delimiter));
        }
        if (this.quote != null) {
            builder.field(QUOTE.getPreferredName(), String.valueOf(this.quote));
        }
        if (this.shouldTrimFields != null) {
            builder.field(SHOULD_TRIM_FIELDS.getPreferredName(), this.shouldTrimFields.booleanValue());
        }
        if (this.grokPattern != null && !this.grokPattern.isEmpty()) {
            builder.field(GROK_PATTERN.getPreferredName(), this.grokPattern);
        }
        if (this.timestampField != null && !this.timestampField.isEmpty()) {
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
        }
        if (this.jodaTimestampFormats != null && !this.jodaTimestampFormats.isEmpty()) {
            builder.field(JODA_TIMESTAMP_FORMATS.getPreferredName(), this.jodaTimestampFormats);
        }
        if (this.javaTimestampFormats != null && !this.javaTimestampFormats.isEmpty()) {
            builder.field(JAVA_TIMESTAMP_FORMATS.getPreferredName(), this.javaTimestampFormats);
        }
        builder.field(NEED_CLIENT_TIMEZONE.getPreferredName(), this.needClientTimezone);
        builder.field(MAPPINGS.getPreferredName(), this.mappings);
        if (this.ingestPipeline != null) {
            builder.field(INGEST_PIPELINE.getPreferredName(), this.ingestPipeline);
        }
        if (!this.fieldStats.isEmpty()) {
            builder.startObject(FIELD_STATS.getPreferredName());
            for (Map.Entry<String, FieldStats> entry : this.fieldStats.entrySet()) {
                builder.field(entry.getKey(), (ToXContent)entry.getValue());
            }
            builder.endObject();
        }
        if (this.explanation != null && !this.explanation.isEmpty()) {
            builder.field(EXPLANATION.getPreferredName(), this.explanation);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numLinesAnalyzed, this.numMessagesAnalyzed, this.sampleStart, this.charset, this.hasByteOrderMarker, this.format, this.multilineStartPattern, this.excludeLinesPattern, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.timestampField, this.jodaTimestampFormats, this.javaTimestampFormats, this.needClientTimezone, this.mappings, this.fieldStats, this.explanation});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileStructure that = (FileStructure)other;
        return this.numLinesAnalyzed == that.numLinesAnalyzed && this.numMessagesAnalyzed == that.numMessagesAnalyzed && Objects.equals(this.sampleStart, that.sampleStart) && Objects.equals(this.charset, that.charset) && Objects.equals(this.hasByteOrderMarker, that.hasByteOrderMarker) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.multilineStartPattern, that.multilineStartPattern) && Objects.equals(this.excludeLinesPattern, that.excludeLinesPattern) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.hasHeaderRow, that.hasHeaderRow) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.quote, that.quote) && Objects.equals(this.shouldTrimFields, that.shouldTrimFields) && Objects.equals(this.grokPattern, that.grokPattern) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.jodaTimestampFormats, that.jodaTimestampFormats) && Objects.equals(this.javaTimestampFormats, that.javaTimestampFormats) && this.needClientTimezone == that.needClientTimezone && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.fieldStats, that.fieldStats) && Objects.equals(this.explanation, that.explanation);
    }

    static {
        PARSER.declareInt(Builder::setNumLinesAnalyzed, NUM_LINES_ANALYZED);
        PARSER.declareInt(Builder::setNumMessagesAnalyzed, NUM_MESSAGES_ANALYZED);
        PARSER.declareString(Builder::setSampleStart, SAMPLE_START);
        PARSER.declareString(Builder::setCharset, CHARSET);
        PARSER.declareBoolean(Builder::setHasByteOrderMarker, HAS_BYTE_ORDER_MARKER);
        PARSER.declareString((p, c) -> p.setFormat(Format.fromString(c)), FORMAT);
        PARSER.declareString(Builder::setMultilineStartPattern, MULTILINE_START_PATTERN);
        PARSER.declareString(Builder::setExcludeLinesPattern, EXCLUDE_LINES_PATTERN);
        PARSER.declareStringArray(Builder::setColumnNames, COLUMN_NAMES);
        PARSER.declareBoolean(Builder::setHasHeaderRow, HAS_HEADER_ROW);
        PARSER.declareString((p, c) -> p.setDelimiter(Character.valueOf(c.charAt(0))), DELIMITER);
        PARSER.declareString((p, c) -> p.setQuote(Character.valueOf(c.charAt(0))), QUOTE);
        PARSER.declareBoolean(Builder::setShouldTrimFields, SHOULD_TRIM_FIELDS);
        PARSER.declareString(Builder::setGrokPattern, GROK_PATTERN);
        PARSER.declareString(Builder::setTimestampField, TIMESTAMP_FIELD);
        PARSER.declareStringArray(Builder::setJodaTimestampFormats, JODA_TIMESTAMP_FORMATS);
        PARSER.declareStringArray(Builder::setJavaTimestampFormats, JAVA_TIMESTAMP_FORMATS);
        PARSER.declareBoolean(Builder::setNeedClientTimezone, NEED_CLIENT_TIMEZONE);
        PARSER.declareObject(Builder::setMappings, (p, c) -> new TreeMap(p.map()), MAPPINGS);
        PARSER.declareObject(Builder::setIngestPipeline, (p, c) -> p.mapOrdered(), INGEST_PIPELINE);
        PARSER.declareObject(Builder::setFieldStats, (p, c) -> {
            TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
            while (p.nextToken() == XContentParser.Token.FIELD_NAME) {
                fieldStats.put(p.currentName(), (FieldStats)FieldStats.PARSER.apply(p, c));
            }
            return fieldStats;
        }, FIELD_STATS);
        PARSER.declareStringArray(Builder::setExplanation, EXPLANATION);
    }

    public static enum Format {
        NDJSON,
        XML,
        DELIMITED,
        SEMI_STRUCTURED_TEXT;


        public static Format fromString(String name) {
            return Format.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private int numLinesAnalyzed;
        private int numMessagesAnalyzed;
        private String sampleStart;
        private String charset;
        private Boolean hasByteOrderMarker;
        private Format format;
        private String multilineStartPattern;
        private String excludeLinesPattern;
        private List<String> columnNames;
        private Boolean hasHeaderRow;
        private Character delimiter;
        private Character quote;
        private Boolean shouldTrimFields;
        private String grokPattern;
        private String timestampField;
        private List<String> jodaTimestampFormats;
        private List<String> javaTimestampFormats;
        private boolean needClientTimezone;
        private Map<String, Object> mappings = Collections.emptyMap();
        private Map<String, Object> ingestPipeline;
        private Map<String, FieldStats> fieldStats = Collections.emptyMap();
        private List<String> explanation;

        Builder() {
            this(Format.SEMI_STRUCTURED_TEXT);
        }

        Builder(Format format) {
            this.setFormat(format);
        }

        Builder setNumLinesAnalyzed(int numLinesAnalyzed) {
            this.numLinesAnalyzed = numLinesAnalyzed;
            return this;
        }

        Builder setNumMessagesAnalyzed(int numMessagesAnalyzed) {
            this.numMessagesAnalyzed = numMessagesAnalyzed;
            return this;
        }

        Builder setSampleStart(String sampleStart) {
            this.sampleStart = Objects.requireNonNull(sampleStart);
            return this;
        }

        Builder setCharset(String charset) {
            this.charset = Objects.requireNonNull(charset);
            return this;
        }

        Builder setHasByteOrderMarker(Boolean hasByteOrderMarker) {
            this.hasByteOrderMarker = hasByteOrderMarker;
            return this;
        }

        Builder setFormat(Format format) {
            this.format = Objects.requireNonNull(format);
            return this;
        }

        Builder setMultilineStartPattern(String multilineStartPattern) {
            this.multilineStartPattern = multilineStartPattern;
            return this;
        }

        Builder setExcludeLinesPattern(String excludeLinesPattern) {
            this.excludeLinesPattern = excludeLinesPattern;
            return this;
        }

        Builder setColumnNames(List<String> columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        Builder setHasHeaderRow(Boolean hasHeaderRow) {
            this.hasHeaderRow = hasHeaderRow;
            return this;
        }

        Builder setDelimiter(Character delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        Builder setQuote(Character quote) {
            this.quote = quote;
            return this;
        }

        Builder setShouldTrimFields(Boolean shouldTrimFields) {
            this.shouldTrimFields = shouldTrimFields;
            return this;
        }

        Builder setGrokPattern(String grokPattern) {
            this.grokPattern = grokPattern;
            return this;
        }

        Builder setTimestampField(String timestampField) {
            this.timestampField = timestampField;
            return this;
        }

        Builder setJodaTimestampFormats(List<String> jodaTimestampFormats) {
            this.jodaTimestampFormats = jodaTimestampFormats;
            return this;
        }

        Builder setJavaTimestampFormats(List<String> javaTimestampFormats) {
            this.javaTimestampFormats = javaTimestampFormats;
            return this;
        }

        Builder setNeedClientTimezone(boolean needClientTimezone) {
            this.needClientTimezone = needClientTimezone;
            return this;
        }

        Builder setMappings(Map<String, Object> mappings) {
            this.mappings = Objects.requireNonNull(mappings);
            return this;
        }

        Builder setIngestPipeline(Map<String, Object> ingestPipeline) {
            this.ingestPipeline = ingestPipeline;
            return this;
        }

        Builder setFieldStats(Map<String, FieldStats> fieldStats) {
            this.fieldStats = Objects.requireNonNull(fieldStats);
            return this;
        }

        Builder setExplanation(List<String> explanation) {
            this.explanation = explanation;
            return this;
        }

        public FileStructure build() {
            return new FileStructure(this.numLinesAnalyzed, this.numMessagesAnalyzed, this.sampleStart, this.charset, this.hasByteOrderMarker, this.format, this.multilineStartPattern, this.excludeLinesPattern, this.columnNames, this.hasHeaderRow, this.delimiter, this.quote, this.shouldTrimFields, this.grokPattern, this.timestampField, this.jodaTimestampFormats, this.javaTimestampFormats, this.needClientTimezone, this.mappings, this.ingestPipeline, this.fieldStats, this.explanation);
        }
    }
}

