/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClassificationConfig
implements InferenceConfig {
    public static final ParseField NAME = new ParseField("classification", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    public static final ParseField NUM_TOP_CLASSES = new ParseField("num_top_classes", new String[0]);
    public static final ParseField TOP_CLASSES_RESULTS_FIELD = new ParseField("top_classes_results_field", new String[0]);
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    private final Integer numTopClasses;
    private final String topClassesResultsField;
    private final String resultsField;
    private final Integer numTopFeatureImportanceValues;
    private static final ConstructingObjectParser<ClassificationConfig, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, args -> new ClassificationConfig((Integer)args[0], (String)args[1], (String)args[2], (Integer)args[3]));

    public static ClassificationConfig fromXContent(XContentParser parser) {
        return (ClassificationConfig)PARSER.apply(parser, null);
    }

    public ClassificationConfig() {
        this(null, null, null, null);
    }

    public ClassificationConfig(Integer numTopClasses, String resultsField, String topClassesResultsField, Integer featureImportance) {
        this.numTopClasses = numTopClasses;
        this.topClassesResultsField = topClassesResultsField;
        this.resultsField = resultsField;
        this.numTopFeatureImportanceValues = featureImportance;
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    public String getTopClassesResultsField() {
        return this.topClassesResultsField;
    }

    public String getResultsField() {
        return this.resultsField;
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationConfig that = (ClassificationConfig)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.topClassesResultsField, that.topClassesResultsField) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues);
    }

    public int hashCode() {
        return Objects.hash(this.numTopClasses, this.topClassesResultsField, this.resultsField, this.numTopFeatureImportanceValues);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numTopClasses != null) {
            builder.field(NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.topClassesResultsField != null) {
            builder.field(TOP_CLASSES_RESULTS_FIELD.getPreferredName(), this.topClassesResultsField);
        }
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_CLASSES);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TOP_CLASSES_RESULTS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUM_TOP_FEATURE_IMPORTANCE_VALUES);
    }
}

