/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.slm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class SnapshotLifecycleStats
implements ToXContentObject {
    private final long retentionRunCount;
    private final long retentionFailedCount;
    private final long retentionTimedOut;
    private final long retentionTimeMs;
    private final Map<String, SnapshotPolicyStats> policyStats;
    public static final ParseField RETENTION_RUNS = new ParseField("retention_runs", new String[0]);
    public static final ParseField RETENTION_FAILED = new ParseField("retention_failed", new String[0]);
    public static final ParseField RETENTION_TIMED_OUT = new ParseField("retention_timed_out", new String[0]);
    public static final ParseField RETENTION_TIME = new ParseField("retention_deletion_time", new String[0]);
    public static final ParseField RETENTION_TIME_MILLIS = new ParseField("retention_deletion_time_millis", new String[0]);
    public static final ParseField POLICY_STATS = new ParseField("policy_stats", new String[0]);
    public static final ParseField TOTAL_TAKEN = new ParseField("total_snapshots_taken", new String[0]);
    public static final ParseField TOTAL_FAILED = new ParseField("total_snapshots_failed", new String[0]);
    public static final ParseField TOTAL_DELETIONS = new ParseField("total_snapshots_deleted", new String[0]);
    public static final ParseField TOTAL_DELETION_FAILURES = new ParseField("total_snapshot_deletion_failures", new String[0]);
    private static final ConstructingObjectParser<SnapshotLifecycleStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
        long runs = (Long)a[0];
        long failed = (Long)a[1];
        long timedOut = (Long)a[2];
        long timeMs = (Long)a[3];
        Map<String, SnapshotPolicyStats> policyStatsMap = ((List)a[4]).stream().collect(Collectors.toMap(m -> ((SnapshotPolicyStats)m).policyId, Function.identity()));
        return new SnapshotLifecycleStats(runs, failed, timedOut, timeMs, policyStatsMap);
    });

    private SnapshotLifecycleStats(long retentionRuns, long retentionFailed, long retentionTimedOut, long retentionTimeMs, Map<String, SnapshotPolicyStats> policyStats) {
        this.retentionRunCount = retentionRuns;
        this.retentionFailedCount = retentionFailed;
        this.retentionTimedOut = retentionTimedOut;
        this.retentionTimeMs = retentionTimeMs;
        this.policyStats = policyStats;
    }

    public static SnapshotLifecycleStats parse(XContentParser parser) {
        return (SnapshotLifecycleStats)PARSER.apply(parser, null);
    }

    public long getRetentionRunCount() {
        return this.retentionRunCount;
    }

    public long getRetentionFailedCount() {
        return this.retentionFailedCount;
    }

    public long getRetentionTimedOut() {
        return this.retentionTimedOut;
    }

    public long getRetentionTimeMillis() {
        return this.retentionTimeMs;
    }

    public Map<String, SnapshotPolicyStats> getMetrics() {
        return Collections.unmodifiableMap(this.policyStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RETENTION_RUNS.getPreferredName(), this.retentionRunCount);
        builder.field(RETENTION_FAILED.getPreferredName(), this.retentionFailedCount);
        builder.field(RETENTION_TIMED_OUT.getPreferredName(), this.retentionTimedOut);
        TimeValue retentionTime = TimeValue.timeValueMillis((long)this.retentionTimeMs);
        builder.field(RETENTION_TIME.getPreferredName(), (Object)retentionTime);
        builder.field(RETENTION_TIME_MILLIS.getPreferredName(), retentionTime.millis());
        Map<String, SnapshotPolicyStats> metrics = this.getMetrics();
        long totalTaken = metrics.values().stream().mapToLong(s -> ((SnapshotPolicyStats)s).snapshotsTaken).sum();
        long totalFailed = metrics.values().stream().mapToLong(s -> ((SnapshotPolicyStats)s).snapshotsFailed).sum();
        long totalDeleted = metrics.values().stream().mapToLong(s -> ((SnapshotPolicyStats)s).snapshotsDeleted).sum();
        long totalDeleteFailures = metrics.values().stream().mapToLong(s -> ((SnapshotPolicyStats)s).snapshotDeleteFailures).sum();
        builder.field(TOTAL_TAKEN.getPreferredName(), totalTaken);
        builder.field(TOTAL_FAILED.getPreferredName(), totalFailed);
        builder.field(TOTAL_DELETIONS.getPreferredName(), totalDeleted);
        builder.field(TOTAL_DELETION_FAILURES.getPreferredName(), totalDeleteFailures);
        builder.startObject(POLICY_STATS.getPreferredName());
        for (Map.Entry<String, SnapshotPolicyStats> policy : metrics.entrySet()) {
            SnapshotPolicyStats perPolicyMetrics = policy.getValue();
            builder.startObject(perPolicyMetrics.policyId);
            perPolicyMetrics.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.retentionRunCount, this.retentionFailedCount, this.retentionTimedOut, this.retentionTimeMs, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecycleStats other = (SnapshotLifecycleStats)obj;
        return this.retentionRunCount == other.retentionRunCount && this.retentionFailedCount == other.retentionFailedCount && this.retentionTimedOut == other.retentionTimedOut && this.retentionTimeMs == other.retentionTimeMs && Objects.equals(this.policyStats, other.policyStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_RUNS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_FAILED);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIMED_OUT);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), RETENTION_TIME_MILLIS);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (ContextParser)SnapshotPolicyStats.PARSER, POLICY_STATS);
    }

    public static class SnapshotPolicyStats
    implements ToXContentFragment {
        private final String policyId;
        private final long snapshotsTaken;
        private final long snapshotsFailed;
        private final long snapshotsDeleted;
        private final long snapshotDeleteFailures;
        public static final ParseField POLICY_ID = new ParseField("policy", new String[0]);
        static final ParseField SNAPSHOTS_TAKEN = new ParseField("snapshots_taken", new String[0]);
        static final ParseField SNAPSHOTS_FAILED = new ParseField("snapshots_failed", new String[0]);
        static final ParseField SNAPSHOTS_DELETED = new ParseField("snapshots_deleted", new String[0]);
        static final ParseField SNAPSHOT_DELETION_FAILURES = new ParseField("snapshot_deletion_failures", new String[0]);
        private static final ConstructingObjectParser<SnapshotPolicyStats, Void> PARSER = new ConstructingObjectParser("snapshot_policy_stats", true, a -> {
            String id = (String)a[0];
            long taken = (Long)a[1];
            long failed = (Long)a[2];
            long deleted = (Long)a[3];
            long deleteFailed = (Long)a[4];
            return new SnapshotPolicyStats(id, taken, failed, deleted, deleteFailed);
        });

        public SnapshotPolicyStats(String policyId, long snapshotsTaken, long snapshotsFailed, long deleted, long failedDeletes) {
            this.policyId = policyId;
            this.snapshotsTaken = snapshotsTaken;
            this.snapshotsFailed = snapshotsFailed;
            this.snapshotsDeleted = deleted;
            this.snapshotDeleteFailures = failedDeletes;
        }

        public static SnapshotPolicyStats parse(XContentParser parser, String policyId) {
            return (SnapshotPolicyStats)PARSER.apply(parser, null);
        }

        public String getPolicyId() {
            return this.policyId;
        }

        public long getSnapshotsTaken() {
            return this.snapshotsTaken;
        }

        public long getSnapshotsFailed() {
            return this.snapshotsFailed;
        }

        public long getSnapshotsDeleted() {
            return this.snapshotsDeleted;
        }

        public long getSnapshotDeleteFailures() {
            return this.snapshotDeleteFailures;
        }

        public int hashCode() {
            return Objects.hash(this.policyId, this.snapshotsTaken, this.snapshotsFailed, this.snapshotsDeleted, this.snapshotDeleteFailures);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SnapshotPolicyStats other = (SnapshotPolicyStats)obj;
            return Objects.equals(this.policyId, other.policyId) && this.snapshotsTaken == other.snapshotsTaken && this.snapshotsFailed == other.snapshotsFailed && this.snapshotsDeleted == other.snapshotsDeleted && this.snapshotDeleteFailures == other.snapshotDeleteFailures;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(SNAPSHOTS_TAKEN.getPreferredName(), this.snapshotsTaken);
            builder.field(SNAPSHOTS_FAILED.getPreferredName(), this.snapshotsFailed);
            builder.field(SNAPSHOTS_DELETED.getPreferredName(), this.snapshotsDeleted);
            builder.field(SNAPSHOT_DELETION_FAILURES.getPreferredName(), this.snapshotDeleteFailures);
            return builder;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY_ID);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_TAKEN);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_FAILED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOTS_DELETED);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), SNAPSHOT_DELETION_FAILURES);
        }
    }
}

