/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;

public class StringTerms
extends InternalMappedTerms<StringTerms, Bucket> {
    public static final String NAME = "sterms";

    public StringTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError) {
        super(name, reduceOrder, order, requiredSize, minDocCount, metadata, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public StringTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public StringTerms create(List<Bucket> buckets) {
        return new StringTerms(this.name, this.reduceOrder, this.order, this.requiredSize, this.minDocCount, (Map<String, Object>)this.metadata, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.termBytes, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    Bucket createBucket(long docCount, InternalAggregations aggs, long docCountError, Bucket prototype) {
        return new Bucket(prototype.termBytes, docCount, aggs, prototype.showDocCountError, docCountError, this.format);
    }

    @Override
    protected StringTerms create(String name, List<Bucket> buckets, BucketOrder reduceOrder, long docCountError, long otherDocCount) {
        return new StringTerms(name, reduceOrder, this.order, this.requiredSize, this.minDocCount, this.getMetadata(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.termBytes = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.termBytes = in.readBytesRef();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.termBytes);
        }

        @Override
        public Object getKey() {
            return this.getKeyAsString();
        }

        @Override
        public Number getKeyAsNumber() {
            try {
                return Long.parseLong(this.termBytes.utf8ToString());
            }
            catch (NumberFormatException ignored) {
                return Double.parseDouble(this.termBytes.utf8ToString());
            }
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.termBytes).toString();
        }

        @Override
        public int compareKey(Bucket other) {
            return this.termBytes.compareTo(other.termBytes);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            return builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.getKeyAsString());
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.termBytes, ((Bucket)obj).termBytes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termBytes);
        }
    }
}

