/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.ops.DistinctOperation;
import org.apache.solr.client.solrj.io.ops.ReduceOperation;
import org.apache.solr.client.solrj.io.stream.ReducerStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class UniqueStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream originalStream;
    private StreamEqualitor originalEqualitor;
    private ReducerStream reducerStream;

    public UniqueStream(TupleStream stream, StreamEqualitor eq) throws IOException {
        this.init(stream, eq);
    }

    public UniqueStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter overExpression = factory.getNamedOperand(expression, "over");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == overExpression || !(overExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'over' parameter listing fields to unique over but didn't find one", expression));
        }
        this.init(factory.constructStream(streamExpressions.get(0)), factory.constructEqualitor(((StreamExpressionValue)overExpression.getParameter()).getValue(), FieldEqualitor.class));
    }

    private void init(TupleStream stream, StreamEqualitor eq) throws IOException {
        this.originalStream = stream;
        this.originalEqualitor = eq;
        this.reducerStream = new ReducerStream(stream, eq, (ReduceOperation)new DistinctOperation());
        if (!eq.isDerivedFrom(stream.getStreamSort())) {
            throw new IOException("Invalid UniqueStream - substream comparator (sort) must be a superset of this stream's equalitor.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.originalStream instanceof Expressible)) throw new IOException("This UniqueStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.originalStream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        if (!(this.originalEqualitor instanceof Expressible)) {
            throw new IOException("This UniqueStream contains a non-expressible equalitor - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("over", this.originalEqualitor.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.originalStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelper(this.originalEqualitor.toExplanation(factory));
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.originalStream.setStreamContext(context);
        this.reducerStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.originalStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.reducerStream.open();
    }

    @Override
    public void close() throws IOException {
        this.reducerStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.reducerStream.read();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.reducerStream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

