/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.validation.valueextraction.ExtractedValue;
import javax.validation.valueextraction.ValueExtractor;
import javax.validation.valueextraction.ValueExtractorDefinitionException;
import org.apache.bval.util.EmulatedAnnotatedType;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.LazyInt;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public class ContainerElementKey
implements Comparable<ContainerElementKey> {
    public static final Comparator<ContainerElementKey> COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ContainerElementKey::containerClassName).thenComparing(ContainerElementKey::getTypeArgumentIndex, Comparator.nullsFirst(Comparator.naturalOrder())));
    private static Logger log = Logger.getLogger(ContainerElementKey.class.getName());
    private final Integer typeArgumentIndex;
    private final Class<?> containerClass;
    private final LazyInt hashCode = new LazyInt(() -> Objects.hash(this.getContainerClass(), this.getTypeArgumentIndex()));
    private final Lazy<String> toString = new Lazy<String>(() -> String.format("%s: %s<[%d]>", ContainerElementKey.class.getSimpleName(), this.getContainerClass().getName(), this.getTypeArgumentIndex()));
    private final AnnotatedType annotatedType;

    public static ContainerElementKey forValueExtractor(ValueExtractor<?> extractor) {
        Class<?> extractorType = extractor.getClass();
        Lazy<Set> result = new Lazy<Set>(HashSet::new);
        Stream.of(extractorType.getAnnotatedInterfaces()).filter(AnnotatedParameterizedType.class::isInstance).map(AnnotatedParameterizedType.class::cast).filter(apt -> ValueExtractor.class.equals((Object)((ParameterizedType)apt.getType()).getRawType())).forEach(decl -> {
            AnnotatedType containerType = decl.getAnnotatedActualTypeArguments()[0];
            if (containerType.isAnnotationPresent(ExtractedValue.class)) {
                final Class extractedType = containerType.getAnnotation(ExtractedValue.class).type();
                if (Void.TYPE.equals(extractedType)) {
                    Exceptions.raise(ValueExtractorDefinitionException::new, "%s does not specify %s type for %s", extractorType, ExtractedValue.class.getSimpleName(), containerType);
                }
                ((Set)result.get()).add(new ContainerElementKey(containerType, null){

                    @Override
                    public AnnotatedType getAnnotatedType() {
                        return EmulatedAnnotatedType.wrap(extractedType);
                    }
                });
            }
            Optional.of(containerType).filter(AnnotatedParameterizedType.class::isInstance).map(AnnotatedParameterizedType.class::cast).map(AnnotatedParameterizedType::getAnnotatedActualTypeArguments).ifPresent(args -> IntStream.range(0, ((AnnotatedType[])args).length).forEach(n -> {
                if (args[n].isAnnotationPresent(ExtractedValue.class)) {
                    if (!Void.TYPE.equals(args[n].getAnnotation(ExtractedValue.class).type())) {
                        log.warning(String.format("Ignoring non-default %s type specified for %s by %s", ExtractedValue.class.getSimpleName(), containerType.getType(), extractorType));
                    }
                    ((Set)result.get()).add(new ContainerElementKey(containerType, (Integer)n));
                }
            }));
        });
        return (ContainerElementKey)result.optional().filter(s -> s.size() == 1).orElseThrow(() -> new ValueExtractorDefinitionException(extractorType.getName())).iterator().next();
    }

    public static ContainerElementKey forTypeVariable(TypeVariable<?> var) {
        Class container = (Class)var.getGenericDeclaration();
        int argIndex = ObjectUtils.indexOf(container.getTypeParameters(), var);
        return new ContainerElementKey(container, (Integer)argIndex);
    }

    private static Integer validTypeArgumentIndex(Integer typeArgumentIndex, Class<?> containerClass) {
        if (typeArgumentIndex != null) {
            int i = typeArgumentIndex;
            Validate.isTrue(i >= 0 && i < containerClass.getTypeParameters().length, "type argument index %d is invalid for container type %s", typeArgumentIndex, containerClass);
        }
        return typeArgumentIndex;
    }

    public ContainerElementKey(AnnotatedType containerType, Integer typeArgumentIndex) {
        Validate.notNull(containerType, "containerType", new Object[0]);
        this.containerClass = TypeUtils.getRawType(containerType.getType(), null);
        this.typeArgumentIndex = ContainerElementKey.validTypeArgumentIndex(typeArgumentIndex, this.containerClass);
        this.annotatedType = typeArgumentIndex == null ? containerType : ((AnnotatedParameterizedType)containerType).getAnnotatedActualTypeArguments()[typeArgumentIndex];
    }

    public ContainerElementKey(Class<?> containerClass, Integer typeArgumentIndex) {
        Validate.notNull(containerClass, "containerClass", new Object[0]);
        this.containerClass = containerClass;
        this.typeArgumentIndex = ContainerElementKey.validTypeArgumentIndex(typeArgumentIndex, containerClass);
        this.annotatedType = typeArgumentIndex == null ? null : EmulatedAnnotatedType.wrap(containerClass.getTypeParameters()[typeArgumentIndex]);
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public Integer getTypeArgumentIndex() {
        return this.typeArgumentIndex;
    }

    public AnnotatedType getAnnotatedType() {
        return Optional.ofNullable(this.annotatedType).orElseThrow(UnsupportedOperationException::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!Optional.ofNullable(obj).filter(ContainerElementKey.class::isInstance).map(ContainerElementKey.class::cast).filter(cek -> Objects.equals(this.containerClass, cek.containerClass) && Objects.equals(this.typeArgumentIndex, cek.typeArgumentIndex)).isPresent()) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode.getAsInt();
    }

    public String toString() {
        return this.toString.get();
    }

    @Override
    public int compareTo(ContainerElementKey o) {
        return COMPARATOR.compare(this, o);
    }

    public Set<ContainerElementKey> getAssignableKeys() {
        Lazy<Set> result = new Lazy<Set>(LinkedHashSet::new);
        this.hierarchy(result.consumer(Set::add));
        return result.optional().map(Collections::unmodifiableSet).orElseGet(Collections::emptySet);
    }

    public boolean represents(TypeVariable<?> var) {
        return Stream.concat(Stream.of(this), this.getAssignableKeys().stream()).anyMatch(cek -> cek.typeArgumentIndex != null && cek.containerClass.getTypeParameters()[cek.typeArgumentIndex].equals(var));
    }

    private void hierarchy(Consumer<ContainerElementKey> sink) {
        TypeVariable<Class<?>> var = this.typeArgumentIndex == null ? null : this.containerClass.getTypeParameters()[this.typeArgumentIndex];
        Lazy<Set> round = new Lazy<Set>(LinkedHashSet::new);
        Stream.concat(Stream.of(this.containerClass.getAnnotatedSuperclass()), Stream.of(this.containerClass.getAnnotatedInterfaces())).filter(AnnotatedParameterizedType.class::isInstance).map(AnnotatedParameterizedType.class::cast).forEach(t -> {
            AnnotatedType[] args = t.getAnnotatedActualTypeArguments();
            for (int i = 0; i < args.length; ++i) {
                Type boundArgumentType = args[i].getType();
                if (!(boundArgumentType instanceof Class) && !boundArgumentType.equals(var)) continue;
                ((Set)round.get()).add(new ContainerElementKey((AnnotatedType)t, (Integer)i));
            }
        });
        round.optional().ifPresent(s -> {
            s.forEach(sink);
            s.forEach(k -> k.hierarchy(sink));
        });
    }

    private String containerClassName() {
        return this.getContainerClass().getName();
    }
}

