/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.kms.v20190118.KmsClient;
import com.tencentcloudapi.kms.v20190118.models.DecryptRequest;
import com.tencentcloudapi.kms.v20190118.models.DecryptResponse;
import com.tencentcloudapi.kms.v20190118.models.DescribeKeyRequest;
import com.tencentcloudapi.kms.v20190118.models.DescribeKeyResponse;
import com.tencentcloudapi.kms.v20190118.models.EncryptRequest;
import com.tencentcloudapi.kms.v20190118.models.EncryptResponse;
import com.tencentcloudapi.kms.v20190118.models.KeyMetadata;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerTencentKMSProvider
implements RangerKMSMKI {
    static final Logger logger = LoggerFactory.getLogger(RangerTencentKMSProvider.class);
    static final String TENCENT_MASTER_KEY_ID = "ranger.kms.tencent.masterkey.id";
    static final String TENCENT_CLIENT_ID = "ranger.kms.tencent.client.id";
    static final String TENCENT_CLIENT_SECRET = "ranger.kms.tencent.client.secret";
    static final String TENCENT_CLIENT_REGION = "ranger.kms.tencent.client.region";
    private String masterKeyId;
    private KeyMetadata masterKeyMetadata;
    private KmsClient keyVaultClient;

    protected RangerTencentKMSProvider(Configuration conf, KmsClient client) {
        this.masterKeyId = conf.get(TENCENT_MASTER_KEY_ID);
        this.keyVaultClient = client;
    }

    public RangerTencentKMSProvider(Configuration conf) throws Exception {
        this(conf, RangerTencentKMSProvider.createKMSClient(conf));
    }

    public static KmsClient createKMSClient(Configuration conf) throws Exception {
        String tencentClientId = conf.get(TENCENT_CLIENT_ID);
        if (StringUtils.isEmpty((String)tencentClientId)) {
            throw new Exception("Tencent KMS is enabled, but client id is not configured");
        }
        String tencentClientSecret = conf.get(TENCENT_CLIENT_SECRET);
        String tencentClientRegion = conf.get(TENCENT_CLIENT_REGION);
        return new KmsClient(new Credential(tencentClientId, tencentClientSecret), tencentClientRegion);
    }

    @Override
    public boolean generateMasterKey(String password) throws Exception {
        if (this.keyVaultClient == null) {
            throw new Exception("Key Vault Client is null. Please check the azure related configuration.");
        }
        try {
            DescribeKeyRequest desckey_req = new DescribeKeyRequest();
            desckey_req.setKeyId(this.masterKeyId);
            DescribeKeyResponse desckey_resp = this.keyVaultClient.DescribeKey(desckey_req);
            if (desckey_resp == null || !desckey_resp.getKeyMetadata().getKeyId().equals(this.masterKeyId)) {
                throw new Exception("KeyMetadata is invalid");
            }
            this.masterKeyMetadata = desckey_resp.getKeyMetadata();
        }
        catch (TencentCloudSDKException ex) {
            throw new Exception("Error while getting existing master key from Tencent.  Master Key Id : " + this.masterKeyId + " . Error : " + ex.getMessage());
        }
        if (this.masterKeyMetadata == null) {
            throw new NoSuchMethodException("generateMasterKey is not implemented for Tencent KMS");
        }
        logger.info("Tencent Master key exist with KeyId :" + this.masterKeyId + " with Alias: " + this.masterKeyMetadata.getAlias() + " with Description : " + this.masterKeyMetadata.getDescription() + " with ResourceId : " + this.masterKeyMetadata.getResourceId());
        return true;
    }

    @Override
    public byte[] encryptZoneKey(Key zoneKey) throws Exception {
        try {
            EncryptRequest req = new EncryptRequest();
            req.setKeyId(this.masterKeyId);
            req.setPlaintext(Base64.getEncoder().encodeToString(zoneKey.getEncoded()));
            EncryptResponse resp = this.keyVaultClient.Encrypt(req);
            return resp.getCiphertextBlob().getBytes(StandardCharsets.US_ASCII);
        }
        catch (TencentCloudSDKException e) {
            throw (Exception)new Exception("Error while encrypting zone key.").initCause(e);
        }
    }

    @Override
    public byte[] decryptZoneKey(byte[] encryptedByte) throws Exception {
        try {
            DecryptRequest req = new DecryptRequest();
            req.setCiphertextBlob(new String(encryptedByte, StandardCharsets.US_ASCII));
            DecryptResponse resp = this.keyVaultClient.Decrypt(req);
            return Base64.getDecoder().decode(resp.getPlaintext());
        }
        catch (TencentCloudSDKException e) {
            throw (Exception)new Exception("Error while decrypting zone key.").initCause(e);
        }
    }

    @Override
    public String getMasterKey(String masterKeySecretName) {
        return null;
    }
}

