/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.solr.authorizer.FieldToAttributeMapping;
import org.apache.ranger.authorization.solr.authorizer.RangerSolrAuditHandler;
import org.apache.ranger.authorization.solr.authorizer.SolrAuthzUtil;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.services.solr.RangerSolrConstants;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSolrAuthorizer
extends SearchComponent
implements AuthorizationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(RangerSolrAuthorizer.class);
    private List<FieldToAttributeMapping> fieldAttributeMappings = new LinkedList<FieldToAttributeMapping>();
    private String andQParserName;
    private static volatile RangerBasePlugin solrPlugin = null;
    boolean useProxyIP = false;
    String proxyIPHeader = "HTTP_X_FORWARDED_FOR";
    String solrAppName = "Client";
    private String authField;
    private String allRolesToken;
    private boolean enabled;
    private RangerSolrConstants.MatchType matchMode;
    private String tokenCountField;
    private boolean allowMissingValue;
    private String qParserName;
    private boolean attrsEnabled;

    public RangerSolrAuthorizer() {
        logger.info("RangerSolrAuthorizer()");
    }

    public void init(NamedList args) {
        SolrParams params = args.toSolrParams();
        this.authField = params.get("rangerAuthField", "ranger_auth");
        this.allRolesToken = params.get("allRolesToken", "");
        this.enabled = params.getBool("enabled", false);
        this.matchMode = RangerSolrConstants.MatchType.valueOf(params.get("matchMode", RangerSolrConstants.DEFAULT_MODE_PROP).toUpperCase());
        if (this.matchMode == RangerSolrConstants.MatchType.CONJUNCTIVE) {
            this.qParserName = params.get("qParser", "subset").trim();
            this.allowMissingValue = params.getBool("allow_missing_val", false);
            this.tokenCountField = params.get("tokenCountField", "ranger_auth_count");
        }
        this.attrsEnabled = params.getBool("attrs_enabled", false);
        logger.info("RangerSolrAuthorizer.init(): authField={" + this.authField + "}, allRolesToken={" + this.allRolesToken + "}, enabled={" + this.enabled + "}, matchType={" + (Object)((Object)this.matchMode) + "}, qParserName={" + this.qParserName + "}, allowMissingValue={" + this.allowMissingValue + "}, tokenCountField={" + this.tokenCountField + "}, attrsEnabled={" + this.attrsEnabled + "}");
        if (this.attrsEnabled) {
            if (params.get("field_attr_mappings") != null) {
                logger.info("Solr params = " + params.get("field_attr_mappings"));
                NamedList mappings = (NamedList)this.checkAndGet(args, "field_attr_mappings");
                for (Map.Entry entry : mappings) {
                    String solrFieldName = (String)entry.getKey();
                    String attributeNames = (String)this.checkAndGet((NamedList)entry.getValue(), "attr_names");
                    String filterType = (String)this.checkAndGet((NamedList)entry.getValue(), "filter_type");
                    boolean acceptEmpty = false;
                    if (((NamedList)entry.getValue()).getBooleanArg("permit_empty") != null) {
                        acceptEmpty = ((NamedList)entry.getValue()).getBooleanArg("permit_empty");
                    }
                    String allUsersValue = this.getWithDefault((NamedList)entry.getValue(), "all_users_value", "");
                    String regex = this.getWithDefault((NamedList)entry.getValue(), "value_filter_regex", "");
                    String extraOpts = this.getWithDefault((NamedList)entry.getValue(), "extra_opts", "");
                    FieldToAttributeMapping mapping = new FieldToAttributeMapping(solrFieldName, attributeNames, filterType, acceptEmpty, allUsersValue, regex, extraOpts);
                    this.fieldAttributeMappings.add(mapping);
                }
            }
            this.andQParserName = ((String)this.checkAndGet(args, "andQParser")).trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Map<String, Object> initInfo) {
        logger.info("init()");
        try {
            RangerBasePlugin me = solrPlugin;
            if (me == null) {
                Class<RangerSolrAuthorizer> clazz = RangerSolrAuthorizer.class;
                // MONITORENTER : org.apache.ranger.authorization.solr.authorizer.RangerSolrAuthorizer.class
                me = solrPlugin;
                logger.info("RangerSolrAuthorizer(): init called");
                if (me == null) {
                    this.authToJAASFile();
                    logger.info("Creating RangerSolrPlugin");
                    me = solrPlugin = new RangerBasePlugin("solr", "solr");
                }
                logger.info("Calling solrPlugin.init()");
                solrPlugin.init();
                solrPlugin.setResultProcessor((RangerAccessResultProcessor)new RangerSolrAuditHandler((Configuration)solrPlugin.getConfig()));
                // MONITOREXIT : clazz
            }
            this.useProxyIP = solrPlugin.getConfig().getBoolean("xasecure.solr.use_proxy_ip", this.useProxyIP);
            this.proxyIPHeader = solrPlugin.getConfig().get("xasecure.solr.proxy_ip_header", this.proxyIPHeader);
            this.solrAppName = System.getProperty("solr.kerberos.jaas.appname", this.solrAppName);
            this.solrAppName = solrPlugin.getConfig().get("xasecure.solr.app.name", this.solrAppName);
            logger.info("init(): useProxyIP=" + this.useProxyIP);
            logger.info("init(): proxyIPHeader=" + this.proxyIPHeader);
            logger.info("init(): solrAppName=" + this.solrAppName);
            logger.info("init(): KerberosName.rules=" + MiscUtil.getKerberosNamesRules());
            return;
        }
        catch (Throwable t) {
            logger.error("Error creating and initializing RangerBasePlugin()", t);
        }
    }

    public void close() throws IOException {
        logger.info("close() called");
        try {
            solrPlugin.cleanup();
            if (solrPlugin.getAuditProviderFactory() != null) {
                solrPlugin.getAuditProviderFactory().shutdown();
            }
        }
        catch (Throwable t) {
            logger.error("Error cleaning up Ranger plugin. Ignoring error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse authorize(AuthorizationContext context) {
        boolean isDenied = false;
        try {
            ArrayList<RangerAccessRequestImpl> rangerRequests;
            RangerPerfTracer perf;
            RangerSolrAuditHandler auditHandler;
            block35: {
                block34: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("==> RangerSolrAuthorizer.authorize()");
                        this.logAuthorizationContext(context);
                    }
                    auditHandler = new RangerSolrAuditHandler((Configuration)solrPlugin.getConfig());
                    perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled((Logger)RangerSolrConstants.PERF_SOLRAUTH_REQUEST_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer((Logger)RangerSolrConstants.PERF_SOLRAUTH_REQUEST_LOG, (String)"RangerSolrAuthorizer.authorize()");
                    }
                    String userName = this.getUserName(context);
                    Set<String> userGroups = this.getGroupsForUser(userName);
                    String ip = null;
                    Date eventTime = new Date();
                    if (this.useProxyIP) {
                        ip = context.getHttpHeader(this.proxyIPHeader);
                    }
                    if (ip == null) {
                        ip = context.getHttpHeader("REMOTE_ADDR");
                    }
                    if (ip == null) {
                        ip = context.getRemoteAddr();
                    }
                    rangerRequests = new ArrayList<RangerAccessRequestImpl>();
                    if (!(context.getHandler() instanceof PermissionNameProvider)) break block34;
                    PermissionNameProvider.Name perm = ((PermissionNameProvider)context.getHandler()).getPermissionName(context);
                    switch (perm) {
                        case READ_PERM: 
                        case UPDATE_PERM: {
                            RangerSolrConstants.ACCESS_TYPE accessType = perm == PermissionNameProvider.Name.READ_PERM ? RangerSolrConstants.ACCESS_TYPE.QUERY : RangerSolrConstants.ACCESS_TYPE.UPDATE;
                            for (AuthorizationContext.CollectionRequest req : context.getCollectionRequests()) {
                                rangerRequests.add(this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.COLLECTION, req.collectionName, accessType));
                            }
                            break block35;
                        }
                        case SECURITY_EDIT_PERM: {
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.ADMIN_TYPE.SECURITY, RangerSolrConstants.ACCESS_TYPE.UPDATE));
                            break;
                        }
                        case SECURITY_READ_PERM: {
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.ADMIN_TYPE.SECURITY, RangerSolrConstants.ACCESS_TYPE.QUERY));
                            break;
                        }
                        case CORE_READ_PERM: 
                        case CORE_EDIT_PERM: 
                        case COLL_READ_PERM: 
                        case COLL_EDIT_PERM: {
                            RangerSolrConstants.ADMIN_TYPE adminType = perm == PermissionNameProvider.Name.COLL_READ_PERM || perm == PermissionNameProvider.Name.COLL_EDIT_PERM ? RangerSolrConstants.ADMIN_TYPE.COLLECTIONS : RangerSolrConstants.ADMIN_TYPE.CORES;
                            RangerSolrConstants.ACCESS_TYPE accessType = perm == PermissionNameProvider.Name.COLL_READ_PERM || perm == PermissionNameProvider.Name.CORE_READ_PERM ? RangerSolrConstants.ACCESS_TYPE.QUERY : RangerSolrConstants.ACCESS_TYPE.UPDATE;
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, adminType, accessType));
                            Map<String, RangerSolrConstants.ACCESS_TYPE> collectionsForAdminOpMap = SolrAuthzUtil.getCollectionsForAdminOp(context);
                            String finalIp = ip;
                            collectionsForAdminOpMap.forEach((k, v) -> rangerRequests.add(this.createRequest(userName, userGroups, finalIp, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.COLLECTION, (String)k, (RangerSolrConstants.ACCESS_TYPE)((Object)v))));
                            break;
                        }
                        case CONFIG_EDIT_PERM: {
                            for (String s : SolrAuthzUtil.getConfigAuthorizables(context)) {
                                rangerRequests.add(this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.CONFIG, s, RangerSolrConstants.ACCESS_TYPE.UPDATE));
                            }
                            break block35;
                        }
                        case CONFIG_READ_PERM: {
                            for (String s : SolrAuthzUtil.getConfigAuthorizables(context)) {
                                rangerRequests.add(this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.CONFIG, s, RangerSolrConstants.ACCESS_TYPE.QUERY));
                            }
                            break block35;
                        }
                        case SCHEMA_EDIT_PERM: {
                            for (String s : SolrAuthzUtil.getSchemaAuthorizables(context)) {
                                rangerRequests.add(this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.SCHEMA, s, RangerSolrConstants.ACCESS_TYPE.UPDATE));
                            }
                            break block35;
                        }
                        case SCHEMA_READ_PERM: {
                            for (String s : SolrAuthzUtil.getSchemaAuthorizables(context)) {
                                rangerRequests.add(this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.SCHEMA, s, RangerSolrConstants.ACCESS_TYPE.QUERY));
                            }
                            break block35;
                        }
                        case METRICS_HISTORY_READ_PERM: 
                        case METRICS_READ_PERM: {
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.ADMIN_TYPE.METRICS, RangerSolrConstants.ACCESS_TYPE.QUERY));
                            break;
                        }
                        case AUTOSCALING_READ_PERM: 
                        case AUTOSCALING_HISTORY_READ_PERM: {
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.ADMIN_TYPE.AUTOSCALING, RangerSolrConstants.ACCESS_TYPE.QUERY));
                            break;
                        }
                        case AUTOSCALING_WRITE_PERM: {
                            rangerRequests.add(this.createAdminRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.ADMIN_TYPE.AUTOSCALING, RangerSolrConstants.ACCESS_TYPE.UPDATE));
                            break;
                        }
                        case ALL: {
                            logger.debug("Not adding anything to the requested privileges, since permission is ALL");
                        }
                    }
                    break block35;
                }
                logger.warn("Request Handler: " + context.getHandler().getClass().getName() + " is not an instance of PermissionNameProvider and so we are not able to authenticate the request. Check SOLR-11623 for more information.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("rangerRequests.size()=" + rangerRequests.size());
            }
            try {
                for (RangerAccessRequestImpl rangerRequest : rangerRequests) {
                    RangerAccessResult result = solrPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest, (RangerAccessResultProcessor)auditHandler);
                    if (logger.isDebugEnabled()) {
                        logger.debug("rangerRequest=" + result);
                    }
                    if (result != null && result.getIsAllowed()) continue;
                    isDenied = true;
                    break;
                }
            }
            finally {
                auditHandler.flushAudit();
                RangerPerfTracer.log((RangerPerfTracer)perf);
            }
        }
        catch (Throwable t) {
            isDenied = true;
            MiscUtil.logErrorMessageByInterval((Logger)logger, (String)t.getMessage(), (Throwable)t);
        }
        AuthorizationResponse response = null;
        response = isDenied ? new AuthorizationResponse(403) : new AuthorizationResponse(200);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerSolrAuthorizer.authorize() result: " + isDenied + "Response : " + response.getMessage());
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(ResponseBuilder rb) throws IOException {
        if (solrPlugin == null || !this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug("Solr Ranger Authorization or Solr Document level Authorization is not enabled!");
            }
            return;
        }
        String userName = this.getUserName(rb.req);
        if (RangerSolrConstants.SUPERUSER.equals(userName)) {
            return;
        }
        RangerSolrAuditHandler auditHandler = new RangerSolrAuditHandler((Configuration)solrPlugin.getConfig());
        boolean isDenied = false;
        if (this.attrsEnabled) {
            Map userAttrMapping;
            if (logger.isDebugEnabled()) {
                logger.debug("Checking Ldap attributes to be added to the query filter");
            }
            if (this.getUserStoreEnricher() == null || this.getUserStoreEnricher().getRangerUserStore() == null) {
                logger.error("No User store enricher to read the ldap attributes");
                isDenied = true;
            }
            if (MapUtils.isNotEmpty((Map)(userAttrMapping = this.getUserStoreEnricher().getRangerUserStore().getUserAttrMapping()))) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
                Map userAttributes = (Map)userAttrMapping.get(userName);
                for (FieldToAttributeMapping mapping : this.fieldAttributeMappings) {
                    String filterQuery = this.buildFilterQueryString(userName, userAttributes, mapping);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Adding filter clause : {}" + filterQuery);
                    }
                    newParams.add("fq", new String[]{filterQuery});
                }
                rb.req.setParams((SolrParams)newParams);
            }
        } else {
            Set<String> roles;
            if (logger.isDebugEnabled()) {
                logger.debug("Checking User roles to be added to the query filter");
            }
            if ((roles = this.getRolesForUser(userName)) != null && !roles.isEmpty()) {
                String filterQuery = this.matchMode == RangerSolrConstants.MatchType.DISJUNCTIVE ? this.getDisjunctiveFilterQueryStr(roles) : this.getConjunctiveFilterQueryStr(roles);
                ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
                newParams.add("fq", new String[]{filterQuery});
                rb.req.setParams((SolrParams)newParams);
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding filter query {" + filterQuery + "} for user {" + userName + "} with roles {" + roles + "}");
                }
            } else {
                isDenied = true;
            }
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)rb.req.getContext().get("httpRequest");
        if (httpServletRequest == null) {
            SolrCore solrCore = rb.req.getCore();
            StringBuilder builder = new StringBuilder("Unable to locate HttpServletRequest");
            if (solrCore != null && !solrCore.getSolrConfig().get("requestDispatcher/requestParsers/@addHttpRequestToContext").boolVal(true)) {
                builder.append(", ensure requestDispatcher/requestParsers/@addHttpRequestToContext is set to true in solrconfig.xml");
            }
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, builder.toString());
        }
        String ip = null;
        Date eventTime = new Date();
        if (this.useProxyIP) {
            ip = httpServletRequest.getHeader("X-Forwarded-For");
        }
        if (ip == null) {
            ip = httpServletRequest.getRemoteAddr();
        }
        try {
            RangerAccessResult result;
            RangerAccessRequestImpl rangerRequest = this.createQueryRequest(userName, this.getGroupsForUser(userName), ip, eventTime, rb.req);
            if (isDenied) {
                result = new RangerAccessResult(0, solrPlugin.getServiceName(), solrPlugin.getServiceDef(), (RangerAccessRequest)rangerRequest);
                result.setIsAllowed(false);
                result.setPolicyId(-1L);
                result.setIsAccessDetermined(true);
                result.setIsAudited(true);
                auditHandler.processResult(result);
            } else {
                result = solrPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest, (RangerAccessResultProcessor)auditHandler);
                if (logger.isDebugEnabled()) {
                    logger.debug("rangerRequest=" + result);
                }
                if (result == null) {
                    isDenied = true;
                }
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        if (isDenied) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Permission denied for user: " + userName);
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Document Authorization";
    }

    private void authToJAASFile() {
        try {
            MiscUtil.setUGIFromJAASConfig((String)this.solrAppName);
            logger.info("LoginUser=" + MiscUtil.getUGILoginUser());
        }
        catch (Throwable t) {
            logger.error("Error authenticating for appName=" + this.solrAppName, t);
        }
    }

    private void logAuthorizationContext(AuthorizationContext context) {
        try {
            String collections = "";
            int i = -1;
            for (AuthorizationContext.CollectionRequest collectionRequest : context.getCollectionRequests()) {
                if (++i > 0) {
                    collections = collections + ",";
                }
                collections = collections + collectionRequest.collectionName;
            }
            String headers = "";
            i = -1;
            Enumeration eList = context.getHeaderNames();
            while (eList.hasMoreElements()) {
                if (++i > 0) {
                    headers = headers + ",";
                }
                String header = (String)eList.nextElement();
                String value = context.getHttpHeader(header);
                headers = headers + header + "=" + value;
            }
            String ipAddress = context.getHttpHeader("HTTP_X_FORWARDED_FOR");
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_HOST");
            }
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_ADDR");
            }
            if (ipAddress == null) {
                ipAddress = context.getRemoteAddr();
            }
            String userName = this.getUserName(context);
            Set<String> groups = this.getGroupsForUser(userName);
            String resource = context.getResource();
            String solrParams = "";
            try {
                solrParams = context.getParams().toQueryString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AuthorizationContext.RequestType requestType = context.getRequestType();
            Principal principal = context.getUserPrincipal();
            String contextString = new String("AuthorizationContext: ");
            contextString = contextString + "context.getResource()= " + (resource != null ? resource : "");
            contextString = contextString + ", solarParams= " + (solrParams != null ? solrParams : "");
            contextString = contextString + ", requestType= " + (requestType != null ? requestType : "");
            contextString = contextString + ", userPrincipal= " + (principal != null ? principal : "");
            contextString = contextString + ", userName= " + userName;
            contextString = contextString + ", groups= " + groups;
            contextString = contextString + ", ipAddress= " + ipAddress;
            contextString = contextString + ", collections= " + collections;
            contextString = contextString + ", headers= " + headers;
            logger.debug(contextString);
        }
        catch (Throwable t) {
            logger.error("Error getting request context!!!", t);
        }
    }

    private RangerAccessRequestImpl createRequest(String userName, Set<String> userGroups, String ip, Date eventTime, AuthorizationContext context, RangerSolrConstants.RESOURCE_TYPE resourceType, String resourceName, RangerSolrConstants.ACCESS_TYPE accessType) {
        String action = accessType.toString();
        RangerAccessRequestImpl rangerRequest = this.createBaseRequest(userName, userGroups, ip, eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        rangerResource.setValue(resourceType.toString(), (Object)resourceName);
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType.toString());
        rangerRequest.setAction(action);
        return rangerRequest;
    }

    private RangerAccessRequestImpl createAdminRequest(String userName, Set<String> userGroups, String ip, Date eventTime, AuthorizationContext context, RangerSolrConstants.ADMIN_TYPE adminType, RangerSolrConstants.ACCESS_TYPE accessType) {
        return this.createRequest(userName, userGroups, ip, eventTime, context, RangerSolrConstants.RESOURCE_TYPE.ADMIN, adminType.toString(), accessType);
    }

    private RangerAccessRequestImpl createQueryRequest(String userName, Set<String> userGroups, String ip, Date eventTime, SolrQueryRequest queryRequest) {
        String accessType = RangerSolrConstants.ACCESS_TYPE.QUERY.toString();
        String action = RangerSolrConstants.ACCESS_TYPE.QUERY.toString();
        RangerAccessRequestImpl rangerRequest = this.createBaseRequest(userName, userGroups, ip, eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        rangerResource.setServiceDef(solrPlugin.getServiceDef());
        rangerResource.setValue(RangerSolrConstants.RESOURCE_TYPE.COLLECTION.toString(), (Object)queryRequest.getCore().getCoreDescriptor().getCollectionName());
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(action);
        rangerRequest.setRequestData(queryRequest.getParams().toLocalParamsString());
        rangerRequest.setClusterName(solrPlugin.getClusterName());
        return rangerRequest;
    }

    private RangerAccessRequestImpl createBaseRequest(String userName, Set<String> userGroups, String ip, Date eventTime) {
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        if (userName != null && !userName.isEmpty()) {
            rangerRequest.setUser(userName);
        }
        if (userGroups != null && userGroups.size() > 0) {
            rangerRequest.setUserGroups(userGroups);
        }
        if (ip != null && !ip.isEmpty()) {
            rangerRequest.setClientIPAddress(ip);
        }
        rangerRequest.setAccessTime(eventTime);
        return rangerRequest;
    }

    private String getUserName(AuthorizationContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal != null) {
            return MiscUtil.getShortNameFromPrincipalName((String)principal.getName());
        }
        return null;
    }

    private Set<String> getGroupsForUser(String name) {
        return MiscUtil.getGroupsForRequestUser((String)name);
    }

    private void addDisjunctiveRawClause(StringBuilder builder, String value) {
        builder.append(" {!raw f=").append(this.authField).append(" v=").append(value).append("}");
    }

    private String getDisjunctiveFilterQueryStr(Set<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String role : roles) {
                this.addDisjunctiveRawClause(builder, "\"" + role + "\"");
            }
            if (this.allRolesToken != null && !this.allRolesToken.isEmpty()) {
                this.addDisjunctiveRawClause(builder, this.allRolesToken);
            }
            return builder.toString();
        }
        return null;
    }

    private String getConjunctiveFilterQueryStr(Set<String> roles) {
        StringBuilder filterQuery = new StringBuilder();
        filterQuery.append(" {!").append(this.qParserName).append(" set_field=\"").append(this.authField).append("\"").append(" set_value=\"").append(Joiner.on((char)',').join(roles.iterator())).append("\"").append(" count_field=\"").append(this.tokenCountField).append("\"");
        if (this.allRolesToken != null && !this.allRolesToken.equals("")) {
            filterQuery.append(" wildcard_token=\"").append(this.allRolesToken).append("\"");
        }
        filterQuery.append(" allow_missing_val=").append(this.allowMissingValue).append(" }");
        return filterQuery.toString();
    }

    private Set<String> getRolesForUser(String name) {
        if (solrPlugin.getCurrentRangerAuthContext() != null) {
            return solrPlugin.getRolesFromUserAndGroups(name, this.getGroupsForUser(name));
        }
        logger.info("Current Ranger Auth Context is null!!");
        return null;
    }

    private final String getUserName(SolrQueryRequest req) {
        if (req instanceof LocalSolrQueryRequest) {
            return RangerSolrConstants.SUPERUSER;
        }
        SolrCore solrCore = req.getCore();
        HttpServletRequest httpServletRequest = (HttpServletRequest)req.getContext().get("httpRequest");
        if (httpServletRequest == null) {
            StringBuilder builder = new StringBuilder("Unable to locate HttpServletRequest");
            if (solrCore != null && !solrCore.getSolrConfig().get("requestDispatcher/requestParsers/@addHttpRequestToContext").boolVal(true)) {
                builder.append(", ensure requestDispatcher/requestParsers/@addHttpRequestToContext is set to true in solrconfig.xml");
            }
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, builder.toString());
        }
        String userName = httpServletRequest.getRemoteUser();
        if (userName == null) {
            userName = MiscUtil.getShortNameFromPrincipalName((String)httpServletRequest.getUserPrincipal().getName());
        }
        if (userName == null) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "This request is not authenticated.");
        }
        return userName;
    }

    private RangerUserStoreEnricher getUserStoreEnricher() {
        Map contextEnricherMap;
        RangerUserStoreEnricher ret = null;
        RangerAuthContext authContext = solrPlugin.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty((Map)(contextEnricherMap = authContext.getRequestContextEnrichers()))) {
            Set contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerUserStoreEnricher)) continue;
                ret = (RangerUserStoreEnricher)enricher;
                break;
            }
        }
        return ret;
    }

    private <T> T checkAndGet(NamedList args, String key) {
        logger.info("checkAndGet() " + key);
        return (T)Preconditions.checkNotNull((Object)args.get(key));
    }

    private <T> T getWithDefault(NamedList args, String key, T defaultValue) {
        Object value = args.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private String buildFilterQueryString(String userName, Map<String, String> userAttributes, FieldToAttributeMapping mapping) {
        String fieldName = mapping.getFieldName();
        Collection<String> attributeValues = this.getUserAttributesForField(userName, userAttributes, mapping);
        switch (mapping.getFilterType()) {
            case OR: {
                return this.buildSimpleORFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case AND: {
                return this.buildSubsetFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case GTE: {
                return this.buildGreaterThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case LTE: {
                return this.buildLessThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
        }
        return null;
    }

    private Collection<String> getUserAttributesForField(String userName, Map<String, String> userAttributes, FieldToAttributeMapping mapping) {
        HashSet<String> userAttributesSubset = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(mapping.getAttributes()) && mapping.getAttributes().contains("groups")) {
            userAttributesSubset.addAll(this.getGroupsForUser(userName));
        }
        for (String attributeName : mapping.getAttributes()) {
            userAttributesSubset.add(userAttributes.get(attributeName));
        }
        return userAttributesSubset;
    }

    private String buildSimpleORFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        for (String attributeValue : attributeValues) {
            s.append(fieldName).append(":\"").append(attributeValue).append("\" ");
        }
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(fieldName).append(":\"").append(allUsersValue).append("\" ");
        }
        if (allowEmptyField) {
            s.append("(*:* AND -").append(fieldName).append(":*) ");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(extraOpts + " ");
        }
        s.deleteCharAt(s.length() - 1);
        return s.toString();
    }

    private String buildSubsetFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        s.append("{!").append(this.andQParserName).append(" set_field=").append(fieldName).append(" set_value=").append(Joiner.on((char)',').join(attributeValues));
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(" wildcard_token=").append(allUsersValue);
        }
        if (allowEmptyField) {
            s.append(" allow_missing_val=true");
        } else {
            s.append(" allow_missing_val=false");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(" " + extraOpts);
        }
        s.append("}");
        return s.toString();
    }

    private String buildGreaterThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Greater Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[" + value + " TO *]" + extraClause.toString();
    }

    private String buildLessThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Less Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[* TO " + value + "]" + extraClause.toString();
    }
}

