/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.stats;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.org.slf4j.Logger;

public class MomentStatsItem {
    private final AtomicLong value = new AtomicLong(0L);
    private final String statsName;
    private final String statsKey;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger log;

    public MomentStatsItem(String statsName, String statsKey, ScheduledExecutorService scheduledExecutorService, Logger log) {
        this.statsName = statsName;
        this.statsKey = statsKey;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MomentStatsItem.this.printAtMinutes();
                    MomentStatsItem.this.value.set(0L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computeNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    public void printAtMinutes() {
        this.log.info(String.format("[%s] [%s] Stats Every 5 Minutes, Value: %d", this.statsName, this.statsKey, this.value.get()));
    }

    public AtomicLong getValue() {
        return this.value;
    }

    public String getStatsKey() {
        return this.statsKey;
    }

    public String getStatsName() {
        return this.statsName;
    }
}

