/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import io.openmessaging.storage.dledger.utils.ResettableCountDownLatch;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public abstract class ShutdownAbleThread
extends Thread {
    protected final ResettableCountDownLatch waitPoint = new ResettableCountDownLatch(1);
    protected Logger logger;
    protected volatile AtomicBoolean hasNotified = new AtomicBoolean(false);
    private AtomicBoolean running = new AtomicBoolean(true);
    private CountDownLatch latch = new CountDownLatch(1);

    public ShutdownAbleThread(String name, Logger logger) {
        super(name);
        this.logger = logger;
    }

    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            block4: {
                try {
                    this.wakeup();
                    this.latch.await(10L, TimeUnit.SECONDS);
                }
                catch (Throwable t) {
                    if (this.logger == null) break block4;
                    this.logger.error("Unexpected Error in shutting down {} ", (Object)this.getName(), (Object)t);
                }
            }
            if (this.latch.getCount() != 0L && this.logger != null) {
                this.logger.error("The {} failed to shutdown in {} seconds", (Object)this.getName(), (Object)10);
            }
        }
    }

    public abstract void doWork();

    public void wakeup() {
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
    }

    public void waitForRunning(long interval) throws InterruptedException {
        if (this.hasNotified.compareAndSet(true, false)) {
            return;
        }
        this.waitPoint.reset();
        try {
            this.waitPoint.await(interval, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("The {} is interrupted", (Object)this.getName(), (Object)e);
            throw e;
        }
        finally {
            this.hasNotified.set(false);
        }
    }

    @Override
    public void run() {
        while (this.running.get()) {
            try {
                this.doWork();
            }
            catch (Throwable t) {
                if (this.logger == null) continue;
                this.logger.error("Unexpected Error in running {} ", (Object)this.getName(), (Object)t);
            }
        }
        this.latch.countDown();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

