/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.openmessaging;

import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.consumer.PushConsumer;

public class SimplePushConsumer {
    public static final String URL = "oms:rocketmq://localhost:9876/default:default";
    public static final String QUEUE = "OMS_HELLO_TOPIC";

    public static void main(String[] args) {
        MessagingAccessPoint messagingAccessPoint = OMS.getMessagingAccessPoint((String)URL);
        PushConsumer consumer = messagingAccessPoint.createPushConsumer(OMS.newKeyValue().put("CONSUMER_ID", "OMS_CONSUMER"));
        messagingAccessPoint.startup();
        System.out.printf("MessagingAccessPoint startup OK%n", new Object[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            consumer.shutdown();
            messagingAccessPoint.shutdown();
        }));
        consumer.attachQueue(QUEUE, (message, context) -> {
            System.out.printf("Received one message: %s%n", message.sysHeaders().getString("MESSAGE_ID"));
            context.ack();
        });
        consumer.startup();
        System.out.printf("Consumer startup OK%n", new Object[0]);
    }
}

