/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.Pair;

public class BrokerReplicaInfo {
    private final String clusterName;
    private final String brokerName;
    private final AtomicLong nextAssignBrokerId;
    private final Map<Long, Pair<String, String>> brokerIdInfo;

    public BrokerReplicaInfo(String clusterName, String brokerName) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.nextAssignBrokerId = new AtomicLong(1L);
        this.brokerIdInfo = new ConcurrentHashMap<Long, Pair<String, String>>();
    }

    public void removeBrokerId(Long brokerId) {
        this.brokerIdInfo.remove(brokerId);
    }

    public Long getNextAssignBrokerId() {
        return this.nextAssignBrokerId.get();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void addBroker(Long brokerId, String ipAddress, String registerCheckCode) {
        this.brokerIdInfo.put(brokerId, (Pair<String, String>)new Pair((Object)ipAddress, (Object)registerCheckCode));
        this.nextAssignBrokerId.incrementAndGet();
    }

    public boolean isBrokerExist(Long brokerId) {
        return this.brokerIdInfo.containsKey(brokerId);
    }

    public Set<Long> getAllBroker() {
        return new HashSet<Long>(this.brokerIdInfo.keySet());
    }

    public Map<Long, String> getBrokerIdTable() {
        HashMap<Long, String> map = new HashMap<Long, String>(this.brokerIdInfo.size());
        this.brokerIdInfo.forEach((id, pair) -> map.put((Long)id, (String)pair.getObject1()));
        return map;
    }

    public String getBrokerAddress(Long brokerId) {
        if (brokerId == null) {
            return null;
        }
        Pair<String, String> pair = this.brokerIdInfo.get(brokerId);
        if (pair != null) {
            return (String)pair.getObject1();
        }
        return null;
    }

    public String getBrokerRegisterCheckCode(Long brokerId) {
        if (brokerId == null) {
            return null;
        }
        Pair<String, String> pair = this.brokerIdInfo.get(brokerId);
        if (pair != null) {
            return (String)pair.getObject2();
        }
        return null;
    }

    public void updateBrokerAddress(Long brokerId, String brokerAddress) {
        if (brokerId == null) {
            return;
        }
        Pair<String, String> oldPair = this.brokerIdInfo.get(brokerId);
        if (oldPair != null) {
            this.brokerIdInfo.put(brokerId, (Pair<String, String>)new Pair((Object)brokerAddress, oldPair.getObject2()));
        }
    }
}

