/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.controller.elect.ElectPolicy;
import org.apache.rocketmq.controller.helper.BrokerValidPredicate;
import org.apache.rocketmq.controller.impl.event.AlterSyncStateSetEvent;
import org.apache.rocketmq.controller.impl.event.ApplyBrokerIdEvent;
import org.apache.rocketmq.controller.impl.event.CleanBrokerDataEvent;
import org.apache.rocketmq.controller.impl.event.ControllerResult;
import org.apache.rocketmq.controller.impl.event.ElectMasterEvent;
import org.apache.rocketmq.controller.impl.event.EventMessage;
import org.apache.rocketmq.controller.impl.event.EventType;
import org.apache.rocketmq.controller.impl.event.UpdateBrokerAddressEvent;
import org.apache.rocketmq.controller.impl.manager.BrokerReplicaInfo;
import org.apache.rocketmq.controller.impl.manager.SyncStateInfo;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.BrokerMemberGroup;
import org.apache.rocketmq.remoting.protocol.body.BrokerReplicasInfo;
import org.apache.rocketmq.remoting.protocol.body.ElectMasterResponseBody;
import org.apache.rocketmq.remoting.protocol.body.SyncStateSet;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.AlterSyncStateSetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.ElectMasterResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.GetReplicaInfoResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.admin.CleanControllerBrokerDataRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.ApplyBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.GetNextBrokerIdResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.controller.register.RegisterBrokerToControllerResponseHeader;

public class ReplicasInfoManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqController");
    private final ControllerConfig controllerConfig;
    private final Map<String, BrokerReplicaInfo> replicaInfoTable;
    private final Map<String, SyncStateInfo> syncStateSetInfoTable;

    public ReplicasInfoManager(ControllerConfig config) {
        this.controllerConfig = config;
        this.replicaInfoTable = new ConcurrentHashMap<String, BrokerReplicaInfo>();
        this.syncStateSetInfoTable = new ConcurrentHashMap<String, SyncStateInfo>();
    }

    public ControllerResult<AlterSyncStateSetResponseHeader> alterSyncStateSet(AlterSyncStateSetRequestHeader request, SyncStateSet syncStateSet, BrokerValidPredicate brokerAlivePredicate) {
        String brokerName = request.getBrokerName();
        ControllerResult<AlterSyncStateSetResponseHeader> result = new ControllerResult<AlterSyncStateSetResponseHeader>(new AlterSyncStateSetResponseHeader());
        AlterSyncStateSetResponseHeader response = result.getResponse();
        if (!this.isContainsBroker(brokerName)) {
            result.setCodeAndRemark(2013, "Broker metadata is not existed");
            return result;
        }
        Set newSyncStateSet = syncStateSet.getSyncStateSet();
        SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        Set<Long> oldSyncStateSet = syncStateInfo.getSyncStateSet();
        if (oldSyncStateSet.size() == newSyncStateSet.size() && oldSyncStateSet.containsAll(newSyncStateSet)) {
            String err = "The newSyncStateSet is equal with oldSyncStateSet, no needed to update syncStateSet";
            LOGGER.warn("{}", (Object)err);
            result.setCodeAndRemark(2013, err);
            return result;
        }
        if (!syncStateInfo.getMasterBrokerId().equals(request.getMasterBrokerId())) {
            String err = String.format("Rejecting alter syncStateSet request because the current leader is:{%s}, not {%s}", syncStateInfo.getMasterBrokerId(), request.getMasterBrokerId());
            LOGGER.error("{}", (Object)err);
            result.setCodeAndRemark(2002, err);
            return result;
        }
        if (request.getMasterEpoch().intValue() != syncStateInfo.getMasterEpoch()) {
            String err = String.format("Rejecting alter syncStateSet request because the current master epoch is:{%d}, not {%d}", syncStateInfo.getMasterEpoch(), request.getMasterEpoch());
            LOGGER.error("{}", (Object)err);
            result.setCodeAndRemark(2000, err);
            return result;
        }
        if (syncStateSet.getSyncStateSetEpoch() != syncStateInfo.getSyncStateSetEpoch()) {
            String err = String.format("Rejecting alter syncStateSet request because the current syncStateSet epoch is:{%d}, not {%d}", syncStateInfo.getSyncStateSetEpoch(), syncStateSet.getSyncStateSetEpoch());
            LOGGER.error("{}", (Object)err);
            result.setCodeAndRemark(2001, err);
            return result;
        }
        for (Long replica : newSyncStateSet) {
            if (!brokerReplicaInfo.isBrokerExist(replica)) {
                String err = String.format("Rejecting alter syncStateSet request because the replicas {%s} don't exist", replica);
                LOGGER.error("{}", (Object)err);
                result.setCodeAndRemark(2003, err);
                return result;
            }
            if (brokerAlivePredicate.check(brokerReplicaInfo.getClusterName(), brokerReplicaInfo.getBrokerName(), replica)) continue;
            String err = String.format("Rejecting alter syncStateSet request because the replicas {%s} don't alive", replica);
            LOGGER.error(err);
            result.setCodeAndRemark(2006, err);
            return result;
        }
        if (!newSyncStateSet.contains(syncStateInfo.getMasterBrokerId())) {
            String err = String.format("Rejecting alter syncStateSet request because the newSyncStateSet don't contains origin leader {%s}", syncStateInfo.getMasterBrokerId());
            LOGGER.error(err);
            result.setCodeAndRemark(2013, err);
            return result;
        }
        int epoch = syncStateInfo.getSyncStateSetEpoch() + 1;
        response.setNewSyncStateSetEpoch(epoch);
        result.setBody(new SyncStateSet(newSyncStateSet, epoch).encode());
        AlterSyncStateSetEvent event = new AlterSyncStateSetEvent(brokerName, newSyncStateSet);
        result.addEvent(event);
        return result;
    }

    public ControllerResult<ElectMasterResponseHeader> electMaster(ElectMasterRequestHeader request, ElectPolicy electPolicy) {
        String brokerName = request.getBrokerName();
        Long brokerId = request.getBrokerId();
        ControllerResult<ElectMasterResponseHeader> result = new ControllerResult<ElectMasterResponseHeader>(new ElectMasterResponseHeader());
        ElectMasterResponseHeader response = result.getResponse();
        if (!this.isContainsBroker(brokerName)) {
            result.setCodeAndRemark(2010, "Broker hasn't been registered");
            return result;
        }
        SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        Set<Long> syncStateSet = syncStateInfo.getSyncStateSet();
        Long oldMaster = syncStateInfo.getMasterBrokerId();
        Set<Long> allReplicaBrokers = this.controllerConfig.isEnableElectUncleanMaster() ? brokerReplicaInfo.getAllBroker() : null;
        Long newMaster = null;
        if (syncStateInfo.isFirstTimeForElect()) {
            newMaster = brokerId;
        }
        if (newMaster == null) {
            Long assignedBrokerId = request.getDesignateElect() ? brokerId : null;
            newMaster = electPolicy.elect(brokerReplicaInfo.getClusterName(), brokerReplicaInfo.getBrokerName(), syncStateSet, allReplicaBrokers, oldMaster, assignedBrokerId);
        }
        if (newMaster != null && newMaster.equals(oldMaster)) {
            String err = String.format("The old master %s is still alive, not need to elect new master for broker %s", oldMaster, brokerReplicaInfo.getBrokerName());
            LOGGER.warn("{}", (Object)err);
            response.setMasterEpoch(Integer.valueOf(syncStateInfo.getMasterEpoch()));
            response.setSyncStateSetEpoch(Integer.valueOf(syncStateInfo.getSyncStateSetEpoch()));
            response.setMasterBrokerId(oldMaster);
            response.setMasterAddress(brokerReplicaInfo.getBrokerAddress(oldMaster));
            result.setBody(new ElectMasterResponseBody(syncStateSet).encode());
            result.setCodeAndRemark(2011, err);
            return result;
        }
        if (newMaster != null) {
            int masterEpoch = syncStateInfo.getMasterEpoch();
            int syncStateSetEpoch = syncStateInfo.getSyncStateSetEpoch();
            HashSet<Long> newSyncStateSet = new HashSet<Long>();
            newSyncStateSet.add(newMaster);
            response.setMasterBrokerId(newMaster);
            response.setMasterAddress(brokerReplicaInfo.getBrokerAddress(newMaster));
            response.setMasterEpoch(Integer.valueOf(masterEpoch + 1));
            response.setSyncStateSetEpoch(Integer.valueOf(syncStateSetEpoch + 1));
            ElectMasterResponseBody responseBody = new ElectMasterResponseBody(newSyncStateSet);
            BrokerMemberGroup brokerMemberGroup = this.buildBrokerMemberGroup(brokerReplicaInfo);
            if (null != brokerMemberGroup) {
                responseBody.setBrokerMemberGroup(brokerMemberGroup);
            }
            result.setBody(responseBody.encode());
            ElectMasterEvent event = new ElectMasterEvent(brokerName, newMaster);
            result.addEvent(event);
            return result;
        }
        if (request.getBrokerId() == null) {
            ElectMasterEvent event = new ElectMasterEvent(false, brokerName);
            result.addEvent(event);
            result.setCodeAndRemark(2004, "Old master has down and failed to elect a new broker master");
        } else {
            result.setCodeAndRemark(2012, "Failed to elect a new master");
        }
        return result;
    }

    private BrokerMemberGroup buildBrokerMemberGroup(BrokerReplicaInfo brokerReplicaInfo) {
        if (brokerReplicaInfo != null) {
            BrokerMemberGroup group = new BrokerMemberGroup(brokerReplicaInfo.getClusterName(), brokerReplicaInfo.getBrokerName());
            Map<Long, String> brokerIdTable = brokerReplicaInfo.getBrokerIdTable();
            HashMap memberGroup = new HashMap();
            brokerIdTable.forEach((id, addr) -> memberGroup.put(id, addr));
            group.setBrokerAddrs(memberGroup);
            return group;
        }
        return null;
    }

    public ControllerResult<GetNextBrokerIdResponseHeader> getNextBrokerId(GetNextBrokerIdRequestHeader request) {
        String clusterName = request.getClusterName();
        String brokerName = request.getBrokerName();
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        ControllerResult<GetNextBrokerIdResponseHeader> result = new ControllerResult<GetNextBrokerIdResponseHeader>(new GetNextBrokerIdResponseHeader(clusterName, brokerName));
        GetNextBrokerIdResponseHeader response = result.getResponse();
        if (brokerReplicaInfo == null) {
            response.setNextBrokerId(Long.valueOf(1L));
        } else {
            response.setNextBrokerId(brokerReplicaInfo.getNextAssignBrokerId());
        }
        return result;
    }

    public ControllerResult<ApplyBrokerIdResponseHeader> applyBrokerId(ApplyBrokerIdRequestHeader request) {
        String clusterName = request.getClusterName();
        String brokerName = request.getBrokerName();
        Long brokerId = request.getAppliedBrokerId();
        String registerCheckCode = request.getRegisterCheckCode();
        String brokerAddress = registerCheckCode.split(";")[0];
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        ControllerResult<ApplyBrokerIdResponseHeader> result = new ControllerResult<ApplyBrokerIdResponseHeader>(new ApplyBrokerIdResponseHeader(clusterName, brokerName));
        ApplyBrokerIdEvent event = new ApplyBrokerIdEvent(clusterName, brokerName, brokerAddress, brokerId, registerCheckCode);
        if (brokerReplicaInfo == null) {
            if (brokerId == 1L) {
                result.addEvent(event);
            } else {
                result.setCodeAndRemark(2014, String.format("Broker-set: %s hasn't been registered in controller, but broker try to apply brokerId: %d", brokerName, brokerId));
            }
            return result;
        }
        if (!brokerReplicaInfo.isBrokerExist(brokerId) || registerCheckCode.equals(brokerReplicaInfo.getBrokerRegisterCheckCode(brokerId))) {
            result.addEvent(event);
            return result;
        }
        result.setCodeAndRemark(2014, String.format("Fail to apply brokerId: %d in broker-set: %s", brokerId, brokerName));
        return result;
    }

    public ControllerResult<RegisterBrokerToControllerResponseHeader> registerBroker(RegisterBrokerToControllerRequestHeader request, BrokerValidPredicate alivePredicate) {
        String brokerAddress = request.getBrokerAddress();
        String brokerName = request.getBrokerName();
        String clusterName = request.getClusterName();
        Long brokerId = request.getBrokerId();
        ControllerResult<RegisterBrokerToControllerResponseHeader> result = new ControllerResult<RegisterBrokerToControllerResponseHeader>(new RegisterBrokerToControllerResponseHeader(clusterName, brokerName));
        RegisterBrokerToControllerResponseHeader response = result.getResponse();
        if (!this.isContainsBroker(brokerName)) {
            result.setCodeAndRemark(2010, String.format("Broker-set: %s hasn't been registered in controller", brokerName));
            return result;
        }
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
        if (!brokerReplicaInfo.isBrokerExist(brokerId)) {
            result.setCodeAndRemark(2010, String.format("BrokerId: %d hasn't been registered in broker-set: %s", brokerId, brokerName));
            return result;
        }
        if (syncStateInfo.isMasterExist() && alivePredicate.check(clusterName, brokerName, syncStateInfo.getMasterBrokerId())) {
            response.setMasterBrokerId(syncStateInfo.getMasterBrokerId());
            response.setMasterAddress(brokerReplicaInfo.getBrokerAddress(response.getMasterBrokerId()));
            response.setMasterEpoch(Integer.valueOf(syncStateInfo.getMasterEpoch()));
            response.setSyncStateSetEpoch(Integer.valueOf(syncStateInfo.getSyncStateSetEpoch()));
        }
        result.setBody(new SyncStateSet(syncStateInfo.getSyncStateSet(), syncStateInfo.getSyncStateSetEpoch()).encode());
        if (!brokerAddress.equals(brokerReplicaInfo.getBrokerAddress(brokerId))) {
            UpdateBrokerAddressEvent event = new UpdateBrokerAddressEvent(clusterName, brokerName, brokerAddress, brokerId);
            result.addEvent(event);
        }
        return result;
    }

    public ControllerResult<GetReplicaInfoResponseHeader> getReplicaInfo(GetReplicaInfoRequestHeader request) {
        String brokerName = request.getBrokerName();
        ControllerResult<GetReplicaInfoResponseHeader> result = new ControllerResult<GetReplicaInfoResponseHeader>(new GetReplicaInfoResponseHeader());
        GetReplicaInfoResponseHeader response = result.getResponse();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
            Long masterBrokerId = syncStateInfo.getMasterBrokerId();
            response.setMasterBrokerId(masterBrokerId);
            response.setMasterAddress(brokerReplicaInfo.getBrokerAddress(masterBrokerId));
            response.setMasterEpoch(Integer.valueOf(syncStateInfo.getMasterEpoch()));
            result.setBody(new SyncStateSet(syncStateInfo.getSyncStateSet(), syncStateInfo.getSyncStateSetEpoch()).encode());
            return result;
        }
        result.setCodeAndRemark(2008, "Broker metadata is not existed");
        return result;
    }

    public ControllerResult<Void> getSyncStateData(List<String> brokerNames, BrokerValidPredicate brokerAlivePredicate) {
        ControllerResult<Void> result = new ControllerResult<Void>();
        BrokerReplicasInfo brokerReplicasInfo = new BrokerReplicasInfo();
        for (String brokerName : brokerNames) {
            if (!this.isContainsBroker(brokerName)) continue;
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
            Set<Long> syncStateSet = syncStateInfo.getSyncStateSet();
            Long masterBrokerId = syncStateInfo.getMasterBrokerId();
            ArrayList inSyncReplicas = new ArrayList();
            ArrayList notInSyncReplicas = new ArrayList();
            if (brokerReplicaInfo == null) continue;
            brokerReplicaInfo.getBrokerIdTable().forEach((brokerId, brokerAddress) -> {
                Boolean isAlive = brokerAlivePredicate.check(brokerReplicaInfo.getClusterName(), brokerName, (Long)brokerId);
                BrokerReplicasInfo.ReplicaIdentity replica = new BrokerReplicasInfo.ReplicaIdentity(brokerName, brokerId, brokerAddress);
                replica.setAlive(isAlive);
                if (syncStateSet.contains(brokerId)) {
                    inSyncReplicas.add(replica);
                } else {
                    notInSyncReplicas.add(replica);
                }
            });
            BrokerReplicasInfo.ReplicasInfo inSyncState = new BrokerReplicasInfo.ReplicasInfo(masterBrokerId, brokerReplicaInfo.getBrokerAddress(masterBrokerId), syncStateInfo.getMasterEpoch(), syncStateInfo.getSyncStateSetEpoch(), inSyncReplicas, notInSyncReplicas);
            brokerReplicasInfo.addReplicaInfo(brokerName, inSyncState);
        }
        result.setBody(brokerReplicasInfo.encode());
        return result;
    }

    public ControllerResult<Void> cleanBrokerData(CleanControllerBrokerDataRequestHeader requestHeader, BrokerValidPredicate validPredicate) {
        ControllerResult<Void> result = new ControllerResult<Void>();
        String clusterName = requestHeader.getClusterName();
        String brokerName = requestHeader.getBrokerName();
        String brokerControllerIdsToClean = requestHeader.getBrokerControllerIdsToClean();
        Set brokerIdSet = null;
        if (!requestHeader.isCleanLivingBroker()) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            if (StringUtils.isBlank((CharSequence)brokerControllerIdsToClean) && null != syncStateInfo && syncStateInfo.getMasterBrokerId() != null) {
                String remark = String.format("Broker %s is still alive, clean up failure", requestHeader.getBrokerName());
                result.setCodeAndRemark(2009, remark);
                return result;
            }
            if (StringUtils.isNotBlank((CharSequence)brokerControllerIdsToClean)) {
                try {
                    brokerIdSet = Stream.of(brokerControllerIdsToClean.split(";")).map(idStr -> Long.valueOf(idStr)).collect(Collectors.toSet());
                }
                catch (NumberFormatException numberFormatException) {
                    String remark = String.format("Please set the option <brokerControllerIdsToClean> according to the format, exception: %s", numberFormatException);
                    result.setCodeAndRemark(2009, remark);
                    return result;
                }
                for (Long brokerId : brokerIdSet) {
                    if (!validPredicate.check(clusterName, brokerName, brokerId)) continue;
                    String remark = String.format("Broker [%s,  %s] is still alive, clean up failure", requestHeader.getBrokerName(), brokerId);
                    result.setCodeAndRemark(2009, remark);
                    return result;
                }
            }
        }
        if (this.isContainsBroker(brokerName)) {
            CleanBrokerDataEvent event = new CleanBrokerDataEvent(brokerName, brokerIdSet);
            result.addEvent(event);
            return result;
        }
        result.setCodeAndRemark(2009, String.format("Broker %s is not existed,clean broker data failure.", brokerName));
        return result;
    }

    public List<String> scanNeedReelectBrokerSets(BrokerValidPredicate validPredicate) {
        LinkedList<String> needReelectBrokerSets = new LinkedList<String>();
        this.syncStateSetInfoTable.forEach((brokerName, syncStateInfo) -> {
            Set<Long> brokerIds;
            boolean alive;
            Long masterBrokerId = syncStateInfo.getMasterBrokerId();
            String clusterName = syncStateInfo.getClusterName();
            if (masterBrokerId != null && !validPredicate.check(clusterName, (String)brokerName, masterBrokerId) && (alive = (brokerIds = this.replicaInfoTable.get(brokerName).getBrokerIdTable().keySet()).stream().anyMatch(id -> validPredicate.check(clusterName, (String)brokerName, (Long)id)))) {
                needReelectBrokerSets.add((String)brokerName);
            }
        });
        return needReelectBrokerSets;
    }

    public void applyEvent(EventMessage event) {
        EventType type = event.getEventType();
        switch (type) {
            case ALTER_SYNC_STATE_SET_EVENT: {
                this.handleAlterSyncStateSet((AlterSyncStateSetEvent)event);
                break;
            }
            case APPLY_BROKER_ID_EVENT: {
                this.handleApplyBrokerId((ApplyBrokerIdEvent)event);
                break;
            }
            case ELECT_MASTER_EVENT: {
                this.handleElectMaster((ElectMasterEvent)event);
                break;
            }
            case CLEAN_BROKER_DATA_EVENT: {
                this.handleCleanBrokerDataEvent((CleanBrokerDataEvent)event);
                break;
            }
            case UPDATE_BROKER_ADDRESS: {
                this.handleUpdateBrokerAddress((UpdateBrokerAddressEvent)event);
                break;
            }
        }
    }

    private void handleAlterSyncStateSet(AlterSyncStateSetEvent event) {
        String brokerName = event.getBrokerName();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            syncStateInfo.updateSyncStateSetInfo(event.getNewSyncStateSet());
        }
    }

    private void handleApplyBrokerId(ApplyBrokerIdEvent event) {
        String brokerName = event.getBrokerName();
        if (this.isContainsBroker(brokerName)) {
            BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
            if (!brokerReplicaInfo.isBrokerExist(event.getNewBrokerId())) {
                brokerReplicaInfo.addBroker(event.getNewBrokerId(), event.getBrokerAddress(), event.getRegisterCheckCode());
            }
        } else {
            String clusterName = event.getClusterName();
            BrokerReplicaInfo brokerReplicaInfo = new BrokerReplicaInfo(clusterName, brokerName);
            brokerReplicaInfo.addBroker(event.getNewBrokerId(), event.getBrokerAddress(), event.getRegisterCheckCode());
            this.replicaInfoTable.put(brokerName, brokerReplicaInfo);
            SyncStateInfo syncStateInfo = new SyncStateInfo(clusterName, brokerName);
            this.syncStateSetInfoTable.put(brokerName, syncStateInfo);
        }
    }

    private void handleUpdateBrokerAddress(UpdateBrokerAddressEvent event) {
        String brokerName = event.getBrokerName();
        String brokerAddress = event.getBrokerAddress();
        Long brokerId = event.getBrokerId();
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        brokerReplicaInfo.updateBrokerAddress(brokerId, brokerAddress);
    }

    private void handleElectMaster(ElectMasterEvent event) {
        String brokerName = event.getBrokerName();
        Long newMaster = event.getNewMasterBrokerId();
        if (this.isContainsBroker(brokerName)) {
            SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
            if (event.getNewMasterElected()) {
                syncStateInfo.updateMasterInfo(newMaster);
                HashSet<Long> newSyncStateSet = new HashSet<Long>();
                newSyncStateSet.add(newMaster);
                syncStateInfo.updateSyncStateSetInfo(newSyncStateSet);
            } else {
                syncStateInfo.updateMasterInfo(null);
            }
            return;
        }
        LOGGER.error("Receive an ElectMasterEvent which contains the un-registered broker, event = {}", (Object)event);
    }

    private void handleCleanBrokerDataEvent(CleanBrokerDataEvent event) {
        String brokerName = event.getBrokerName();
        Set<Long> brokerIdSetToClean = event.getBrokerIdSetToClean();
        if (null == brokerIdSetToClean || brokerIdSetToClean.isEmpty()) {
            this.replicaInfoTable.remove(brokerName);
            this.syncStateSetInfoTable.remove(brokerName);
            return;
        }
        if (!this.isContainsBroker(brokerName)) {
            return;
        }
        BrokerReplicaInfo brokerReplicaInfo = this.replicaInfoTable.get(brokerName);
        SyncStateInfo syncStateInfo = this.syncStateSetInfoTable.get(brokerName);
        for (Long brokerId : brokerIdSetToClean) {
            brokerReplicaInfo.removeBrokerId(brokerId);
            syncStateInfo.removeFromSyncState(brokerId);
        }
        if (brokerReplicaInfo.getBrokerIdTable().isEmpty()) {
            this.replicaInfoTable.remove(brokerName);
        }
        if (syncStateInfo.getSyncStateSet().isEmpty()) {
            this.syncStateSetInfoTable.remove(brokerName);
        }
    }

    private boolean isContainsBroker(String brokerName) {
        return this.replicaInfoTable.containsKey(brokerName) && this.syncStateSetInfoTable.containsKey(brokerName);
    }
}

