/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.store.ha.autoswitch.BrokerMetadata;

public class TempBrokerMetadata
extends BrokerMetadata {
    private String registerCheckCode;

    public TempBrokerMetadata(String filePath) {
        this(filePath, null, null, null, null);
    }

    public TempBrokerMetadata(String filePath, String clusterName, String brokerName, Long brokerId, String registerCheckCode) {
        super(filePath);
        this.clusterName = clusterName;
        this.brokerId = brokerId;
        this.brokerName = brokerName;
        this.registerCheckCode = registerCheckCode;
    }

    public void updateAndPersist(String clusterName, String brokerName, Long brokerId, String registerCheckCode) throws Exception {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerId = brokerId;
        this.registerCheckCode = registerCheckCode;
        this.writeToFile();
    }

    @Override
    public String encodeToStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clusterName).append("#");
        sb.append(this.brokerName).append("#");
        sb.append(this.brokerId).append("#");
        sb.append(this.registerCheckCode);
        return sb.toString();
    }

    @Override
    public void decodeFromStr(String dataStr) {
        if (dataStr == null) {
            return;
        }
        String[] dataArr = dataStr.split("#");
        this.clusterName = dataArr[0];
        this.brokerName = dataArr[1];
        this.brokerId = Long.valueOf(dataArr[2]);
        this.registerCheckCode = dataArr[3];
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() && StringUtils.isNotEmpty((CharSequence)this.registerCheckCode);
    }

    @Override
    public void clearInMem() {
        super.clearInMem();
        this.registerCheckCode = null;
    }

    @Override
    public Long getBrokerId() {
        return this.brokerId;
    }

    public String getRegisterCheckCode() {
        return this.registerCheckCode;
    }

    @Override
    public String toString() {
        return "TempBrokerMetadata{registerCheckCode='" + this.registerCheckCode + '\'' + ", clusterName='" + this.clusterName + '\'' + ", brokerName='" + this.brokerName + '\'' + ", brokerId=" + this.brokerId + ", filePath='" + this.filePath + '\'' + '}';
    }
}

