/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.body;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class BrokerReplicasInfo
extends RemotingSerializable {
    private Map<String, ReplicasInfo> replicasInfoTable = new HashMap<String, ReplicasInfo>();

    public void addReplicaInfo(String brokerName, ReplicasInfo replicasInfo) {
        this.replicasInfoTable.put(brokerName, replicasInfo);
    }

    public Map<String, ReplicasInfo> getReplicasInfoTable() {
        return this.replicasInfoTable;
    }

    public void setReplicasInfoTable(Map<String, ReplicasInfo> replicasInfoTable) {
        this.replicasInfoTable = replicasInfoTable;
    }

    public static class ReplicaIdentity
    extends RemotingSerializable {
        private String brokerName;
        private Long brokerId;
        private String brokerAddress;
        private Boolean alive;

        public ReplicaIdentity(String brokerName, Long brokerId, String brokerAddress) {
            this.brokerName = brokerName;
            this.brokerId = brokerId;
            this.brokerAddress = brokerAddress;
            this.alive = false;
        }

        public ReplicaIdentity(String brokerName, Long brokerId, String brokerAddress, Boolean alive) {
            this.brokerName = brokerName;
            this.brokerId = brokerId;
            this.brokerAddress = brokerAddress;
            this.alive = alive;
        }

        public String getBrokerName() {
            return this.brokerName;
        }

        public void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public String getBrokerAddress() {
            return this.brokerAddress;
        }

        public void setBrokerAddress(String brokerAddress) {
            this.brokerAddress = brokerAddress;
        }

        public Long getBrokerId() {
            return this.brokerId;
        }

        public void setBrokerId(Long brokerId) {
            this.brokerId = brokerId;
        }

        public Boolean getAlive() {
            return this.alive;
        }

        public void setAlive(Boolean alive) {
            this.alive = alive;
        }

        public String toString() {
            return "ReplicaIdentity{brokerName='" + this.brokerName + '\'' + ", brokerId=" + this.brokerId + ", brokerAddress='" + this.brokerAddress + '\'' + ", alive=" + this.alive + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaIdentity that = (ReplicaIdentity)o;
            return this.brokerName.equals(that.brokerName) && this.brokerId.equals(that.brokerId) && this.brokerAddress.equals(that.brokerAddress);
        }

        public int hashCode() {
            return Objects.hash(this.brokerName, this.brokerId, this.brokerAddress);
        }
    }

    public static class ReplicasInfo
    extends RemotingSerializable {
        private Long masterBrokerId;
        private String masterAddress;
        private Integer masterEpoch;
        private Integer syncStateSetEpoch;
        private List<ReplicaIdentity> inSyncReplicas;
        private List<ReplicaIdentity> notInSyncReplicas;

        public ReplicasInfo(Long masterBrokerId, String masterAddress, int masterEpoch, int syncStateSetEpoch, List<ReplicaIdentity> inSyncReplicas, List<ReplicaIdentity> notInSyncReplicas) {
            this.masterBrokerId = masterBrokerId;
            this.masterAddress = masterAddress;
            this.masterEpoch = masterEpoch;
            this.syncStateSetEpoch = syncStateSetEpoch;
            this.inSyncReplicas = inSyncReplicas;
            this.notInSyncReplicas = notInSyncReplicas;
        }

        public String getMasterAddress() {
            return this.masterAddress;
        }

        public void setMasterAddress(String masterAddress) {
            this.masterAddress = masterAddress;
        }

        public int getMasterEpoch() {
            return this.masterEpoch;
        }

        public void setMasterEpoch(int masterEpoch) {
            this.masterEpoch = masterEpoch;
        }

        public int getSyncStateSetEpoch() {
            return this.syncStateSetEpoch;
        }

        public void setSyncStateSetEpoch(int syncStateSetEpoch) {
            this.syncStateSetEpoch = syncStateSetEpoch;
        }

        public List<ReplicaIdentity> getInSyncReplicas() {
            return this.inSyncReplicas;
        }

        public void setInSyncReplicas(List<ReplicaIdentity> inSyncReplicas) {
            this.inSyncReplicas = inSyncReplicas;
        }

        public List<ReplicaIdentity> getNotInSyncReplicas() {
            return this.notInSyncReplicas;
        }

        public void setNotInSyncReplicas(List<ReplicaIdentity> notInSyncReplicas) {
            this.notInSyncReplicas = notInSyncReplicas;
        }

        public void setMasterBrokerId(Long masterBrokerId) {
            this.masterBrokerId = masterBrokerId;
        }

        public Long getMasterBrokerId() {
            return this.masterBrokerId;
        }

        public boolean isExistInSync(String brokerName, Long brokerId, String brokerAddress) {
            return this.getInSyncReplicas().contains(new ReplicaIdentity(brokerName, brokerId, brokerAddress));
        }

        public boolean isExistInNotSync(String brokerName, Long brokerId, String brokerAddress) {
            return this.getNotInSyncReplicas().contains(new ReplicaIdentity(brokerName, brokerId, brokerAddress));
        }

        public boolean isExistInAllReplicas(String brokerName, Long brokerId, String brokerAddress) {
            return this.isExistInSync(brokerName, brokerId, brokerAddress) || this.isExistInNotSync(brokerName, brokerId, brokerAddress);
        }
    }
}

