/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor.channel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannel;

public class RemoteChannelSerializer {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final String REMOTE_PROXY_IP_KEY = "remoteProxyIp";
    private static final String REMOTE_ADDRESS_KEY = "remoteAddress";
    private static final String LOCAL_ADDRESS_KEY = "localAddress";
    private static final String TYPE_KEY = "type";
    private static final String EXTEND_ATTRIBUTE_KEY = "extendAttribute";

    public static String toJson(RemoteChannel remoteChannel) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(REMOTE_PROXY_IP_KEY, remoteChannel.getRemoteProxyIp());
        data.put(REMOTE_ADDRESS_KEY, remoteChannel.getRemoteAddress());
        data.put(LOCAL_ADDRESS_KEY, remoteChannel.getLocalAddress());
        data.put(TYPE_KEY, (Object)remoteChannel.getType());
        data.put(EXTEND_ATTRIBUTE_KEY, remoteChannel.getChannelExtendAttribute());
        return JSON.toJSONString(data);
    }

    public static RemoteChannel decodeFromJson(String jsonData) {
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            return null;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)jsonData);
            return new RemoteChannel(jsonObject.getString(REMOTE_PROXY_IP_KEY), jsonObject.getString(REMOTE_ADDRESS_KEY), jsonObject.getString(LOCAL_ADDRESS_KEY), (ChannelProtocolType)((Object)jsonObject.getObject(TYPE_KEY, ChannelProtocolType.class)), (String)jsonObject.getObject(EXTEND_ATTRIBUTE_KEY, String.class));
        }
        catch (Throwable t) {
            log.error("decode remote channel data failed. data:{}", (Object)jsonData, (Object)t);
            return null;
        }
    }
}

