/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageEntry;
import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.FilterExpression;
import apache.rocketmq.v2.FilterType;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.ReceiveMessageResponse;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.impl.consumer.ReceiveMessageResult;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcInvocation;
import org.apache.rocketmq.shaded.com.google.common.base.Stopwatch;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.rocketmq.shaded.com.google.protobuf.Duration;
import org.apache.rocketmq.shaded.com.google.protobuf.Timestamp;
import org.apache.rocketmq.shaded.com.google.protobuf.util.Durations;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

abstract class ConsumerImpl
extends ClientImpl {
    static final Pattern CONSUMER_GROUP_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerImpl.class);
    private final String consumerGroup;

    ConsumerImpl(ClientConfiguration clientConfiguration, String consumerGroup, Set<String> topics) {
        super(clientConfiguration, topics);
        this.consumerGroup = consumerGroup;
    }

    protected ListenableFuture<ReceiveMessageResult> receiveMessage(ReceiveMessageRequest request, MessageQueueImpl mq, java.time.Duration awaitDuration) {
        ArrayList messages = new ArrayList();
        try {
            Metadata metadata = this.sign();
            Endpoints endpoints = mq.getBroker().getEndpoints();
            java.time.Duration tolerance = this.clientConfiguration.getRequestTimeout();
            java.time.Duration timeout = java.time.Duration.ofNanos(awaitDuration.toNanos() + tolerance.toNanos());
            ListenableFuture<RpcInvocation<Iterator<ReceiveMessageResponse>>> future = this.clientManager.receiveMessage(endpoints, metadata, request, timeout);
            return Futures.transformAsync(future, context -> {
                Iterator it = (Iterator)context.getResponse();
                Status status = Status.newBuilder().setCode(Code.INTERNAL_SERVER_ERROR).setMessage("status was not set by server").build();
                Timestamp deliveryTimestampFromRemote = null;
                ArrayList<Message> messageList = new ArrayList<Message>();
                block5: while (it.hasNext()) {
                    ReceiveMessageResponse response = (ReceiveMessageResponse)it.next();
                    switch (response.getContentCase()) {
                        case STATUS: {
                            status = response.getStatus();
                            continue block5;
                        }
                        case MESSAGE: {
                            messageList.add(response.getMessage());
                            continue block5;
                        }
                        case DELIVERY_TIMESTAMP: {
                            deliveryTimestampFromRemote = response.getDeliveryTimestamp();
                            continue block5;
                        }
                    }
                    LOGGER.warn("[Bug] Not recognized content for receive message response, mq={}, clientId={}, resp={}", mq, this.clientId, response);
                }
                for (Message message : messageList) {
                    MessageViewImpl view = MessageViewImpl.fromProtobuf(message, mq, deliveryTimestampFromRemote);
                    messages.add(view);
                }
                ReceiveMessageResult receiveMessageResult = new ReceiveMessageResult(endpoints, context.getContext().getRequestId(), status, messages);
                return Futures.immediateFuture(receiveMessageResult);
            }, MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            return Futures.immediateFailedFuture(t);
        }
    }

    private AckMessageRequest wrapAckMessageRequest(MessageViewImpl messageView) {
        Resource topicResource = Resource.newBuilder().setName(messageView.getTopic()).build();
        AckMessageEntry entry = AckMessageEntry.newBuilder().setMessageId(messageView.getMessageId().toString()).setReceiptHandle(messageView.getReceiptHandle()).build();
        return AckMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setGroup(this.getProtobufGroup()).addEntries(entry).build();
    }

    private ChangeInvisibleDurationRequest wrapChangeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        Resource topicResource = Resource.newBuilder().setName(messageView.getTopic()).build();
        return ChangeInvisibleDurationRequest.newBuilder().setGroup(this.getProtobufGroup()).setTopic(topicResource).setReceiptHandle(messageView.getReceiptHandle()).setInvisibleDuration(Durations.fromNanos(invisibleDuration.toNanos())).setMessageId(messageView.getMessageId().toString()).build();
    }

    protected ListenableFuture<RpcInvocation<AckMessageResponse>> ackMessage(MessageViewImpl messageView) {
        SettableFuture<RpcInvocation<AckMessageResponse>> future;
        Endpoints endpoints = messageView.getEndpoints();
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final List<MessageCommon> messageCommons = Collections.singletonList(messageView.getMessageCommon());
        this.doBefore(MessageHookPoints.ACK, messageCommons);
        try {
            AckMessageRequest request = this.wrapAckMessageRequest(messageView);
            Metadata metadata = this.sign();
            future = this.clientManager.ackMessage(endpoints, metadata, request, this.clientConfiguration.getRequestTimeout());
        }
        catch (Throwable t) {
            SettableFuture future0 = SettableFuture.create();
            future0.setException(t);
            future = future0;
        }
        Futures.addCallback(future, new FutureCallback<RpcInvocation<AckMessageResponse>>(){

            @Override
            public void onSuccess(RpcInvocation<AckMessageResponse> invocation) {
                AckMessageResponse response = invocation.getResponse();
                Status status = response.getStatus();
                Code code = status.getCode();
                java.time.Duration duration = stopwatch.elapsed();
                MessageHookPointsStatus messageHookPointsStatus = Code.OK.equals(code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                ConsumerImpl.this.doAfter(MessageHookPoints.ACK, messageCommons, duration, messageHookPointsStatus);
            }

            @Override
            public void onFailure(Throwable t) {
                java.time.Duration duration = stopwatch.elapsed();
                ConsumerImpl.this.doAfter(MessageHookPoints.ACK, messageCommons, duration, MessageHookPointsStatus.ERROR);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    public ListenableFuture<RpcInvocation<ChangeInvisibleDurationResponse>> changeInvisibleDuration(MessageViewImpl messageView, java.time.Duration invisibleDuration) {
        SettableFuture<RpcInvocation<ChangeInvisibleDurationResponse>> future;
        final Endpoints endpoints = messageView.getEndpoints();
        final Stopwatch stopwatch = Stopwatch.createStarted();
        final List<MessageCommon> messageCommons = Collections.singletonList(messageView.getMessageCommon());
        this.doBefore(MessageHookPoints.CHANGE_INVISIBLE_DURATION, messageCommons);
        try {
            ChangeInvisibleDurationRequest request = this.wrapChangeInvisibleDuration(messageView, invisibleDuration);
            Metadata metadata = this.sign();
            future = this.clientManager.changeInvisibleDuration(endpoints, metadata, request, this.clientConfiguration.getRequestTimeout());
        }
        catch (Throwable t) {
            SettableFuture future0 = SettableFuture.create();
            future0.setException(t);
            future = future0;
        }
        final MessageId messageId = messageView.getMessageId();
        Futures.addCallback(future, new FutureCallback<RpcInvocation<ChangeInvisibleDurationResponse>>(){

            @Override
            public void onSuccess(RpcInvocation<ChangeInvisibleDurationResponse> invocation) {
                MessageHookPointsStatus messageHookPointsStatus;
                ChangeInvisibleDurationResponse response = invocation.getResponse();
                Status status = response.getStatus();
                Code code = status.getCode();
                java.time.Duration duration = stopwatch.elapsed();
                MessageHookPointsStatus messageHookPointsStatus2 = messageHookPointsStatus = Code.OK.equals(code) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
                if (!Code.OK.equals(code)) {
                    LOGGER.error("Failed to change message invisible duration, messageId={}, endpoints={}, code={}, status message=[{}], clientId={}", messageId, endpoints, code, status.getMessage(), ConsumerImpl.this.clientId);
                }
                ConsumerImpl.this.doAfter(MessageHookPoints.CHANGE_INVISIBLE_DURATION, messageCommons, duration, messageHookPointsStatus);
            }

            @Override
            public void onFailure(Throwable t) {
                java.time.Duration duration = stopwatch.elapsed();
                ConsumerImpl.this.doAfter(MessageHookPoints.ACK, messageCommons, duration, MessageHookPointsStatus.ERROR);
                LOGGER.error("Exception raised during message acknowledgement, messageId={}, endpoints={}, clientId={}", messageId, endpoints, ConsumerImpl.this.clientId, t);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    @Override
    public HeartbeatRequest wrapHeartbeatRequest() {
        return HeartbeatRequest.newBuilder().setGroup(this.getProtobufGroup()).build();
    }

    protected Resource getProtobufGroup() {
        return Resource.newBuilder().setName(this.consumerGroup).build();
    }

    @Override
    public NotifyClientTerminationRequest wrapNotifyClientTerminationRequest() {
        return NotifyClientTerminationRequest.newBuilder().setGroup(this.getProtobufGroup()).build();
    }

    private apache.rocketmq.v2.FilterExpression wrapFilterExpression(FilterExpression filterExpression) {
        FilterExpression.Builder expressionBuilder = apache.rocketmq.v2.FilterExpression.newBuilder();
        expressionBuilder.setExpression(filterExpression.getExpression());
        switch (filterExpression.getFilterExpressionType()) {
            case SQL92: {
                expressionBuilder.setType(FilterType.SQL);
                break;
            }
            default: {
                expressionBuilder.setType(FilterType.TAG);
            }
        }
        return expressionBuilder.build();
    }

    public ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression) {
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setBatchSize(batchSize).setAutoRenew(true).build();
    }

    public ReceiveMessageRequest wrapReceiveMessageRequest(int batchSize, MessageQueueImpl mq, FilterExpression filterExpression, java.time.Duration invisibleDuration) {
        Duration duration = Durations.fromNanos(invisibleDuration.toNanos());
        return ReceiveMessageRequest.newBuilder().setGroup(this.getProtobufGroup()).setMessageQueue(mq.toProtobuf()).setFilterExpression(this.wrapFilterExpression(filterExpression)).setBatchSize(batchSize).setAutoRenew(false).setInvisibleDuration(duration).build();
    }
}

