// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.19.4
// source: service.proto

package v2

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MessagingServiceClient is the client API for MessagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MessagingServiceClient interface {
	// Queries the route entries of the requested topic in the perspective of the
	// given endpoints. On success, servers should return a collection of
	// addressable message-queues. Note servers may return customized route
	// entries based on endpoints provided.
	//
	// If the requested topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryRoute(ctx context.Context, in *QueryRouteRequest, opts ...grpc.CallOption) (*QueryRouteResponse, error)
	// Producer or consumer sends HeartbeatRequest to servers periodically to
	// keep-alive. Additionally, it also reports client-side configuration,
	// including topic subscription, load-balancing group name, etc.
	//
	// Returns `OK` if success.
	//
	// If a client specifies a language that is not yet supported by servers,
	// returns `INVALID_ARGUMENT`
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// Delivers messages to brokers.
	// Clients may further:
	// 1. Refine a message destination to message-queues which fulfills parts of
	// FIFO semantic;
	// 2. Flag a message as transactional, which keeps it invisible to consumers
	// until it commits;
	// 3. Time a message, making it invisible to consumers till specified
	// time-point;
	// 4. And more...
	//
	// Returns message-id or transaction-id with status `OK` on success.
	//
	// If the destination topic doesn't exist, returns `NOT_FOUND`.
	SendMessage(ctx context.Context, in *SendMessageRequest, opts ...grpc.CallOption) (*SendMessageResponse, error)
	// Queries the assigned route info of a topic for current consumer,
	// the returned assignment result is decided by server-side load balancer.
	//
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryAssignment(ctx context.Context, in *QueryAssignmentRequest, opts ...grpc.CallOption) (*QueryAssignmentResponse, error)
	// Receives messages from the server in batch manner, returns a set of
	// messages if success. The received messages should be acked or redelivered
	// after processed.
	//
	// If the pending concurrent receive requests exceed the quota of the given
	// consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
	// return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
	// or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
	// message in the specific topic, returns `OK` with an empty message set.
	// Please note that client may suffer from false empty responses.
	//
	// If failed to receive message from remote, server must return only one
	// `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
	// the specific reason of failure, otherwise, the reply is considered successful.
	ReceiveMessage(ctx context.Context, in *ReceiveMessageRequest, opts ...grpc.CallOption) (MessagingService_ReceiveMessageClient, error)
	// Acknowledges the message associated with the `receipt_handle` or `offset`
	// in the `AckMessageRequest`, it means the message has been successfully
	// processed. Returns `OK` if the message server remove the relevant message
	// successfully.
	//
	// If the given receipt_handle is illegal or out of date, returns
	// `INVALID_ARGUMENT`.
	AckMessage(ctx context.Context, in *AckMessageRequest, opts ...grpc.CallOption) (*AckMessageResponse, error)
	// Forwards one message to dead letter queue if the max delivery attempts is
	// exceeded by this message at client-side, return `OK` if success.
	ForwardMessageToDeadLetterQueue(ctx context.Context, in *ForwardMessageToDeadLetterQueueRequest, opts ...grpc.CallOption) (*ForwardMessageToDeadLetterQueueResponse, error)
	// Commits or rollback one transactional message.
	EndTransaction(ctx context.Context, in *EndTransactionRequest, opts ...grpc.CallOption) (*EndTransactionResponse, error)
	// Once a client starts, it would immediately establishes bi-lateral stream
	// RPCs with brokers, reporting its settings as the initiative command.
	//
	// When servers have need of inspecting client status, they would issue
	// telemetry commands to clients. After executing received instructions,
	// clients shall report command execution results through client-side streams.
	Telemetry(ctx context.Context, opts ...grpc.CallOption) (MessagingService_TelemetryClient, error)
	// Notify the server that the client is terminated.
	NotifyClientTermination(ctx context.Context, in *NotifyClientTerminationRequest, opts ...grpc.CallOption) (*NotifyClientTerminationResponse, error)
	// Once a message is retrieved from consume queue on behalf of the group, it
	// will be kept invisible to other clients of the same group for a period of
	// time. The message is supposed to be processed within the invisible
	// duration. If the client, which is in charge of the invisible message, is
	// not capable of processing the message timely, it may use
	// ChangeInvisibleDuration to lengthen invisible duration.
	ChangeInvisibleDuration(ctx context.Context, in *ChangeInvisibleDurationRequest, opts ...grpc.CallOption) (*ChangeInvisibleDurationResponse, error)
}

type messagingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMessagingServiceClient(cc grpc.ClientConnInterface) MessagingServiceClient {
	return &messagingServiceClient{cc}
}

func (c *messagingServiceClient) QueryRoute(ctx context.Context, in *QueryRouteRequest, opts ...grpc.CallOption) (*QueryRouteResponse, error) {
	out := new(QueryRouteResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/QueryRoute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/Heartbeat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) SendMessage(ctx context.Context, in *SendMessageRequest, opts ...grpc.CallOption) (*SendMessageResponse, error) {
	out := new(SendMessageResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/SendMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) QueryAssignment(ctx context.Context, in *QueryAssignmentRequest, opts ...grpc.CallOption) (*QueryAssignmentResponse, error) {
	out := new(QueryAssignmentResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/QueryAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ReceiveMessage(ctx context.Context, in *ReceiveMessageRequest, opts ...grpc.CallOption) (MessagingService_ReceiveMessageClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessagingService_ServiceDesc.Streams[0], "/apache.rocketmq.v2.MessagingService/ReceiveMessage", opts...)
	if err != nil {
		return nil, err
	}
	x := &messagingServiceReceiveMessageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type MessagingService_ReceiveMessageClient interface {
	Recv() (*ReceiveMessageResponse, error)
	grpc.ClientStream
}

type messagingServiceReceiveMessageClient struct {
	grpc.ClientStream
}

func (x *messagingServiceReceiveMessageClient) Recv() (*ReceiveMessageResponse, error) {
	m := new(ReceiveMessageResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messagingServiceClient) AckMessage(ctx context.Context, in *AckMessageRequest, opts ...grpc.CallOption) (*AckMessageResponse, error) {
	out := new(AckMessageResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/AckMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ForwardMessageToDeadLetterQueue(ctx context.Context, in *ForwardMessageToDeadLetterQueueRequest, opts ...grpc.CallOption) (*ForwardMessageToDeadLetterQueueResponse, error) {
	out := new(ForwardMessageToDeadLetterQueueResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/ForwardMessageToDeadLetterQueue", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) EndTransaction(ctx context.Context, in *EndTransactionRequest, opts ...grpc.CallOption) (*EndTransactionResponse, error) {
	out := new(EndTransactionResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/EndTransaction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) Telemetry(ctx context.Context, opts ...grpc.CallOption) (MessagingService_TelemetryClient, error) {
	stream, err := c.cc.NewStream(ctx, &MessagingService_ServiceDesc.Streams[1], "/apache.rocketmq.v2.MessagingService/Telemetry", opts...)
	if err != nil {
		return nil, err
	}
	x := &messagingServiceTelemetryClient{stream}
	return x, nil
}

type MessagingService_TelemetryClient interface {
	Send(*TelemetryCommand) error
	Recv() (*TelemetryCommand, error)
	grpc.ClientStream
}

type messagingServiceTelemetryClient struct {
	grpc.ClientStream
}

func (x *messagingServiceTelemetryClient) Send(m *TelemetryCommand) error {
	return x.ClientStream.SendMsg(m)
}

func (x *messagingServiceTelemetryClient) Recv() (*TelemetryCommand, error) {
	m := new(TelemetryCommand)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *messagingServiceClient) NotifyClientTermination(ctx context.Context, in *NotifyClientTerminationRequest, opts ...grpc.CallOption) (*NotifyClientTerminationResponse, error) {
	out := new(NotifyClientTerminationResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/NotifyClientTermination", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *messagingServiceClient) ChangeInvisibleDuration(ctx context.Context, in *ChangeInvisibleDurationRequest, opts ...grpc.CallOption) (*ChangeInvisibleDurationResponse, error) {
	out := new(ChangeInvisibleDurationResponse)
	err := c.cc.Invoke(ctx, "/apache.rocketmq.v2.MessagingService/ChangeInvisibleDuration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MessagingServiceServer is the server API for MessagingService service.
// All implementations must embed UnimplementedMessagingServiceServer
// for forward compatibility
type MessagingServiceServer interface {
	// Queries the route entries of the requested topic in the perspective of the
	// given endpoints. On success, servers should return a collection of
	// addressable message-queues. Note servers may return customized route
	// entries based on endpoints provided.
	//
	// If the requested topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryRoute(context.Context, *QueryRouteRequest) (*QueryRouteResponse, error)
	// Producer or consumer sends HeartbeatRequest to servers periodically to
	// keep-alive. Additionally, it also reports client-side configuration,
	// including topic subscription, load-balancing group name, etc.
	//
	// Returns `OK` if success.
	//
	// If a client specifies a language that is not yet supported by servers,
	// returns `INVALID_ARGUMENT`
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// Delivers messages to brokers.
	// Clients may further:
	// 1. Refine a message destination to message-queues which fulfills parts of
	// FIFO semantic;
	// 2. Flag a message as transactional, which keeps it invisible to consumers
	// until it commits;
	// 3. Time a message, making it invisible to consumers till specified
	// time-point;
	// 4. And more...
	//
	// Returns message-id or transaction-id with status `OK` on success.
	//
	// If the destination topic doesn't exist, returns `NOT_FOUND`.
	SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error)
	// Queries the assigned route info of a topic for current consumer,
	// the returned assignment result is decided by server-side load balancer.
	//
	// If the corresponding topic doesn't exist, returns `NOT_FOUND`.
	// If the specific endpoints is empty, returns `INVALID_ARGUMENT`.
	QueryAssignment(context.Context, *QueryAssignmentRequest) (*QueryAssignmentResponse, error)
	// Receives messages from the server in batch manner, returns a set of
	// messages if success. The received messages should be acked or redelivered
	// after processed.
	//
	// If the pending concurrent receive requests exceed the quota of the given
	// consumer group, returns `UNAVAILABLE`. If the upstream store server hangs,
	// return `DEADLINE_EXCEEDED` in a timely manner. If the corresponding topic
	// or consumer group doesn't exist, returns `NOT_FOUND`. If there is no new
	// message in the specific topic, returns `OK` with an empty message set.
	// Please note that client may suffer from false empty responses.
	//
	// If failed to receive message from remote, server must return only one
	// `ReceiveMessageResponse` as the reply to the request, whose `Status` indicates
	// the specific reason of failure, otherwise, the reply is considered successful.
	ReceiveMessage(*ReceiveMessageRequest, MessagingService_ReceiveMessageServer) error
	// Acknowledges the message associated with the `receipt_handle` or `offset`
	// in the `AckMessageRequest`, it means the message has been successfully
	// processed. Returns `OK` if the message server remove the relevant message
	// successfully.
	//
	// If the given receipt_handle is illegal or out of date, returns
	// `INVALID_ARGUMENT`.
	AckMessage(context.Context, *AckMessageRequest) (*AckMessageResponse, error)
	// Forwards one message to dead letter queue if the max delivery attempts is
	// exceeded by this message at client-side, return `OK` if success.
	ForwardMessageToDeadLetterQueue(context.Context, *ForwardMessageToDeadLetterQueueRequest) (*ForwardMessageToDeadLetterQueueResponse, error)
	// Commits or rollback one transactional message.
	EndTransaction(context.Context, *EndTransactionRequest) (*EndTransactionResponse, error)
	// Once a client starts, it would immediately establishes bi-lateral stream
	// RPCs with brokers, reporting its settings as the initiative command.
	//
	// When servers have need of inspecting client status, they would issue
	// telemetry commands to clients. After executing received instructions,
	// clients shall report command execution results through client-side streams.
	Telemetry(MessagingService_TelemetryServer) error
	// Notify the server that the client is terminated.
	NotifyClientTermination(context.Context, *NotifyClientTerminationRequest) (*NotifyClientTerminationResponse, error)
	// Once a message is retrieved from consume queue on behalf of the group, it
	// will be kept invisible to other clients of the same group for a period of
	// time. The message is supposed to be processed within the invisible
	// duration. If the client, which is in charge of the invisible message, is
	// not capable of processing the message timely, it may use
	// ChangeInvisibleDuration to lengthen invisible duration.
	ChangeInvisibleDuration(context.Context, *ChangeInvisibleDurationRequest) (*ChangeInvisibleDurationResponse, error)
	mustEmbedUnimplementedMessagingServiceServer()
}

// UnimplementedMessagingServiceServer must be embedded to have forward compatible implementations.
type UnimplementedMessagingServiceServer struct {
}

func (UnimplementedMessagingServiceServer) QueryRoute(context.Context, *QueryRouteRequest) (*QueryRouteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryRoute not implemented")
}
func (UnimplementedMessagingServiceServer) Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Heartbeat not implemented")
}
func (UnimplementedMessagingServiceServer) SendMessage(context.Context, *SendMessageRequest) (*SendMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendMessage not implemented")
}
func (UnimplementedMessagingServiceServer) QueryAssignment(context.Context, *QueryAssignmentRequest) (*QueryAssignmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryAssignment not implemented")
}
func (UnimplementedMessagingServiceServer) ReceiveMessage(*ReceiveMessageRequest, MessagingService_ReceiveMessageServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveMessage not implemented")
}
func (UnimplementedMessagingServiceServer) AckMessage(context.Context, *AckMessageRequest) (*AckMessageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AckMessage not implemented")
}
func (UnimplementedMessagingServiceServer) ForwardMessageToDeadLetterQueue(context.Context, *ForwardMessageToDeadLetterQueueRequest) (*ForwardMessageToDeadLetterQueueResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ForwardMessageToDeadLetterQueue not implemented")
}
func (UnimplementedMessagingServiceServer) EndTransaction(context.Context, *EndTransactionRequest) (*EndTransactionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EndTransaction not implemented")
}
func (UnimplementedMessagingServiceServer) Telemetry(MessagingService_TelemetryServer) error {
	return status.Errorf(codes.Unimplemented, "method Telemetry not implemented")
}
func (UnimplementedMessagingServiceServer) NotifyClientTermination(context.Context, *NotifyClientTerminationRequest) (*NotifyClientTerminationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NotifyClientTermination not implemented")
}
func (UnimplementedMessagingServiceServer) ChangeInvisibleDuration(context.Context, *ChangeInvisibleDurationRequest) (*ChangeInvisibleDurationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ChangeInvisibleDuration not implemented")
}
func (UnimplementedMessagingServiceServer) mustEmbedUnimplementedMessagingServiceServer() {}

// UnsafeMessagingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MessagingServiceServer will
// result in compilation errors.
type UnsafeMessagingServiceServer interface {
	mustEmbedUnimplementedMessagingServiceServer()
}

func RegisterMessagingServiceServer(s grpc.ServiceRegistrar, srv MessagingServiceServer) {
	s.RegisterService(&MessagingService_ServiceDesc, srv)
}

func _MessagingService_QueryRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).QueryRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/QueryRoute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).QueryRoute(ctx, req.(*QueryRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/Heartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_SendMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).SendMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/SendMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).SendMessage(ctx, req.(*SendMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_QueryAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).QueryAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/QueryAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).QueryAssignment(ctx, req.(*QueryAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ReceiveMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MessagingServiceServer).ReceiveMessage(m, &messagingServiceReceiveMessageServer{stream})
}

type MessagingService_ReceiveMessageServer interface {
	Send(*ReceiveMessageResponse) error
	grpc.ServerStream
}

type messagingServiceReceiveMessageServer struct {
	grpc.ServerStream
}

func (x *messagingServiceReceiveMessageServer) Send(m *ReceiveMessageResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _MessagingService_AckMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AckMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).AckMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/AckMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).AckMessage(ctx, req.(*AckMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ForwardMessageToDeadLetterQueue_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForwardMessageToDeadLetterQueueRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).ForwardMessageToDeadLetterQueue(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/ForwardMessageToDeadLetterQueue",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).ForwardMessageToDeadLetterQueue(ctx, req.(*ForwardMessageToDeadLetterQueueRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_EndTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EndTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).EndTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/EndTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).EndTransaction(ctx, req.(*EndTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_Telemetry_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MessagingServiceServer).Telemetry(&messagingServiceTelemetryServer{stream})
}

type MessagingService_TelemetryServer interface {
	Send(*TelemetryCommand) error
	Recv() (*TelemetryCommand, error)
	grpc.ServerStream
}

type messagingServiceTelemetryServer struct {
	grpc.ServerStream
}

func (x *messagingServiceTelemetryServer) Send(m *TelemetryCommand) error {
	return x.ServerStream.SendMsg(m)
}

func (x *messagingServiceTelemetryServer) Recv() (*TelemetryCommand, error) {
	m := new(TelemetryCommand)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _MessagingService_NotifyClientTermination_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NotifyClientTerminationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).NotifyClientTermination(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/NotifyClientTermination",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).NotifyClientTermination(ctx, req.(*NotifyClientTerminationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MessagingService_ChangeInvisibleDuration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ChangeInvisibleDurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MessagingServiceServer).ChangeInvisibleDuration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/apache.rocketmq.v2.MessagingService/ChangeInvisibleDuration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MessagingServiceServer).ChangeInvisibleDuration(ctx, req.(*ChangeInvisibleDurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MessagingService_ServiceDesc is the grpc.ServiceDesc for MessagingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MessagingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "apache.rocketmq.v2.MessagingService",
	HandlerType: (*MessagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryRoute",
			Handler:    _MessagingService_QueryRoute_Handler,
		},
		{
			MethodName: "Heartbeat",
			Handler:    _MessagingService_Heartbeat_Handler,
		},
		{
			MethodName: "SendMessage",
			Handler:    _MessagingService_SendMessage_Handler,
		},
		{
			MethodName: "QueryAssignment",
			Handler:    _MessagingService_QueryAssignment_Handler,
		},
		{
			MethodName: "AckMessage",
			Handler:    _MessagingService_AckMessage_Handler,
		},
		{
			MethodName: "ForwardMessageToDeadLetterQueue",
			Handler:    _MessagingService_ForwardMessageToDeadLetterQueue_Handler,
		},
		{
			MethodName: "EndTransaction",
			Handler:    _MessagingService_EndTransaction_Handler,
		},
		{
			MethodName: "NotifyClientTermination",
			Handler:    _MessagingService_NotifyClientTermination_Handler,
		},
		{
			MethodName: "ChangeInvisibleDuration",
			Handler:    _MessagingService_ChangeInvisibleDuration_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveMessage",
			Handler:       _MessagingService_ReceiveMessage_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Telemetry",
			Handler:       _MessagingService_Telemetry_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "service.proto",
}
