/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;

class WriterThread
extends Thread {
    final OutputStream out;
    private final BlockingQueue<String> queue;

    private static void writeIntLE(OutputStream out, int v) throws IOException {
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 24 & 0xFF);
    }

    WriterThread(OutputStream out, BlockingQueue<String> queue) {
        this.out = out;
        this.queue = queue;
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                if (this.queue.isEmpty()) {
                    this.out.flush();
                }
                this.sendMessage(this.queue.take());
            }
            catch (IOException e) {
                if (this.isInterrupted()) break;
                e.printStackTrace();
                break;
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        WriterThread.writeIntLE(this.out, bytes.length);
        this.out.write(bytes);
    }
}

