/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.royale.compiler.css.FontFaceSourceType;
import org.apache.royale.compiler.css.ICSSFontFace;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSModelTreeType;
import org.apache.royale.compiler.internal.css.CSSNodeBase;
import org.apache.royale.compiler.internal.css.CSSProperty;

public class CSSFontFace
extends CSSNodeBase
implements ICSSFontFace {
    private final CSSFunctionCallPropertyValue source;
    private final ArrayList<ICSSPropertyValue> sources = new ArrayList();
    private final String fontFamily;
    private final String fontStyle;
    private final String fontWeight;
    private final boolean isEmbedAsCFF;
    private final boolean isAdvancedAntiAliasing;

    protected CSSFontFace(List<CSSProperty> properties, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.FONT_FACE);
        assert (properties != null) : "Properties can't be null for @font-face.";
        ICSSNode srcValue = null;
        Object fontFamilyValue = null;
        ICSSPropertyValue fontStyleValue = null;
        ICSSPropertyValue fontWeightValue = null;
        ICSSPropertyValue embedAsCFFValue = null;
        ICSSPropertyValue advancedAAValue = null;
        for (ICSSProperty iCSSProperty : properties) {
            String name = iCSSProperty.getName();
            ICSSPropertyValue value = iCSSProperty.getValue();
            if (name.equals("src")) {
                this.sources.add(value);
                srcValue = value;
                continue;
            }
            if (name.equals("fontFamily")) {
                fontFamilyValue = value;
                continue;
            }
            if (name.equals("fontStyle")) {
                fontStyleValue = value;
                continue;
            }
            if (name.equals("fontWeight")) {
                fontWeightValue = value;
                continue;
            }
            if (name.equals("embedAsCFF")) {
                embedAsCFFValue = value;
                continue;
            }
            if (!name.equals("advancedAntiAliasing")) continue;
            advancedAAValue = value;
        }
        Preconditions.checkNotNull(srcValue, (Object)"'src' is required in @font-face");
        this.source = srcValue instanceof CSSArrayPropertyValue ? (CSSFunctionCallPropertyValue)srcValue.getNthChild(0) : (CSSFunctionCallPropertyValue)srcValue;
        Preconditions.checkNotNull(fontFamilyValue, (Object)"'fontFamily' is required in @font-face");
        this.fontFamily = fontFamilyValue.toString();
        this.fontStyle = fontStyleValue == null ? "normal" : fontStyleValue.toString();
        this.fontWeight = fontWeightValue == null ? "normal" : fontWeightValue.toString();
        this.isEmbedAsCFF = embedAsCFFValue == null || embedAsCFFValue.toString().equalsIgnoreCase("true");
        this.isAdvancedAntiAliasing = advancedAAValue == null || advancedAAValue.toString().equalsIgnoreCase("true");
    }

    public ArrayList<ICSSPropertyValue> getSources() {
        return this.sources;
    }

    @Override
    public FontFaceSourceType getSourceType() {
        return Enum.valueOf(FontFaceSourceType.class, this.source.name.toUpperCase());
    }

    @Override
    public String getSourceValue() {
        String sourceValue = null;
        if (FontFaceSourceType.URL.equals((Object)this.getSourceType()) || FontFaceSourceType.LOCAL.equals((Object)this.getSourceType())) {
            sourceValue = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw(this.source.rawArguments);
        }
        return sourceValue;
    }

    @Override
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Override
    public String getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontWeight() {
        return this.fontWeight;
    }

    public boolean getEmbedAsCFF() {
        return this.isEmbedAsCFF;
    }

    @Override
    public boolean getAdvancedAntiAliasing() {
        return this.isAdvancedAntiAliasing;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("@font-face {\n");
        result.append("    src : ").append(this.source).append(";\n");
        result.append("    fontFamily : ").append(this.fontFamily).append(";\n");
        result.append("    embedAsCFF : ").append(this.isEmbedAsCFF);
        result.append("    advancedAntiAliasing : ").append(this.isAdvancedAntiAliasing).append(";\n");
        result.append("    fontStyle : ").append(this.fontStyle).append(";\n");
        result.append("    fontWeight : ").append(this.fontWeight).append(";\n");
        result.append("}\n");
        return result.toString();
    }
}

