/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoAnyTypeRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IExpressionNode typeNode = variableNode.getVariableTypeNode();
        if (!this.isAnyType(typeNode)) {
            return;
        }
        problems.add(new NoAnyTypeOnVariableLinterProblem(variableNode));
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        for (IParameterNode paramNode : functionNode.getParameterNodes()) {
            IExpressionNode typeNode = paramNode.getVariableTypeNode();
            if (!this.isAnyType(typeNode)) continue;
            problems.add(new NoAnyTypeOnParameterLinterProblem(paramNode));
        }
        if (functionNode.isConstructor()) {
            return;
        }
        IExpressionNode typeNode = functionNode.getReturnTypeNode();
        if (this.isAnyType(typeNode)) {
            problems.add(new NoAnyTypeReturnLinterProblem(functionNode));
        }
    }

    private boolean isAnyType(IExpressionNode typeNode) {
        if (!(typeNode instanceof IIdentifierNode)) {
            return false;
        }
        if (typeNode instanceof IdentifierNode && ((IdentifierNode)typeNode).isImplicit()) {
            return false;
        }
        IIdentifierNode identifierNode = (IIdentifierNode)typeNode;
        return "*".equals(identifierNode.getName());
    }

    public static class NoAnyTypeReturnLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not use the * type for function return type";

        public NoAnyTypeReturnLinterProblem(IFunctionNode node) {
            super((ISourceLocation)node.getReturnTypeNode());
        }
    }

    public static class NoAnyTypeOnParameterLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not use the * type for function parameter '${paramName}'";
        public String paramName;

        public NoAnyTypeOnParameterLinterProblem(IParameterNode node) {
            super((ISourceLocation)node.getVariableTypeNode());
            this.paramName = node.getName();
        }
    }

    public static class NoAnyTypeOnVariableLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Must not use the * type for variable '${varName}'";
        public String varName;

        public NoAnyTypeOnVariableLinterProblem(IVariableNode node) {
            super((ISourceLocation)node.getVariableTypeNode());
            this.varName = node.getName();
        }
    }
}

