/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoIfBooleanLiteralRule
extends LinterRule {
    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.IfStatementID, (node, tokenQuery, problems) -> this.checkIfNode((IIfNode)node, tokenQuery, problems));
        return result;
    }

    private void checkIfNode(IIfNode ifNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IExpressionNode conditionalNode = ifNode.getConditionalExpressionNode();
        if (!(conditionalNode instanceof ILiteralNode)) {
            return;
        }
        ILiteralNode literalNode = (ILiteralNode)conditionalNode;
        if (!ILiteralNode.LiteralType.BOOLEAN.equals((Object)literalNode.getLiteralType())) {
            return;
        }
        problems.add(new NoIfBooleanLiteralLinterProblem(literalNode));
    }

    public static class NoIfBooleanLiteralLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Condition is always '${value}'";
        public String value;

        public NoIfBooleanLiteralLinterProblem(ILiteralNode node) {
            super((ISourceLocation)node);
            this.value = node.getValue();
        }
    }
}

