/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.common.FramesConfiguration;
import flex2.compiler.common.NamespacesConfiguration;
import flex2.compiler.common.RuntimeSharedLibrarySettingsConfiguration;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.tools.LicensesConfiguration;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.internal.ConfigurationConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.util.ObjectList;

public class OEMConfiguration
implements Configuration,
ConfigurationConstants,
Cloneable {
    public ConfigurationBuffer cfgbuf;
    public final ToolsConfiguration configuration;
    private Map<String, Object> args;
    private Map<String, Object> defaults;
    private Map<String, Object> more;
    private Map<String, Object> linker_args;
    private Map<String, Object> linker_more;
    private String[] extras;
    public final Set<String> newLinkerOptionsAfterCompile;
    private boolean keepLinkReport;
    private boolean keepSizeReport;
    private boolean keepConfigurationReport;
    private Map<String, String> tokens;

    OEMConfiguration(ConfigurationBuffer cfgbuf, ToolsConfiguration configuration) {
        this.cfgbuf = cfgbuf;
        this.configuration = configuration;
        this.args = new LinkedHashMap<String, Object>();
        this.more = new LinkedHashMap<String, Object>();
        this.linker_args = new LinkedHashMap<String, Object>();
        this.linker_more = new LinkedHashMap<String, Object>();
        this.newLinkerOptionsAfterCompile = new HashSet<String>();
        if (configuration != null) {
            this.populateDefaults(configuration);
        }
        this.defaults = this.args;
        this.args = new LinkedHashMap<String, Object>();
        this.linker_args = new LinkedHashMap<String, Object>();
        this.newLinkerOptionsAfterCompile.clear();
        this.keepLinkReport = false;
        this.keepSizeReport = false;
        this.keepConfigurationReport = false;
        this.tokens = new TreeMap<String, String>();
    }

    void importDefaults(OEMConfiguration c) {
        this.args.putAll(c.defaults);
    }

    public String[] getCompilerOptions() {
        return this.getOptions(this.args, this.more, true);
    }

    public String[] getLinkerOptions() {
        return this.getOptions(this.linker_args, this.linker_more, false);
    }

    private String[] getOptions(Map<String, Object> args, Map<String, Object> more, boolean processExtras) {
        int length;
        Map m;
        Object value;
        ArrayList<Object> buffer = new ArrayList<Object>();
        for (String key : this.tokens.keySet()) {
            value = this.tokens.get(key);
            buffer.add("+" + key + "=" + (String)value);
        }
        for (String key : args.keySet()) {
            Iterator iter;
            ArrayList valueList;
            int j;
            Object[] a;
            value = args.get(key);
            if (value instanceof Boolean) {
                buffer.add(key + "=" + value);
                continue;
            }
            if (value instanceof Number) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if ("--compiler.context-root".equals(key) && value instanceof String) {
                buffer.add(key);
                buffer.add((String)value);
                continue;
            }
            if (value instanceof String) {
                if (!"".equals(value)) {
                    buffer.add(key);
                    buffer.add((String)value);
                    continue;
                }
                buffer.add(key + "=");
                continue;
            }
            if (value instanceof File) {
                String p = ((File)value).getPath();
                if (!"".equals(p)) {
                    buffer.add(key);
                    buffer.add(p);
                    continue;
                }
                buffer.add(key + "=");
                continue;
            }
            if (value instanceof URL) {
                String u = ((URL)value).toExternalForm();
                if (!"".equals(u)) {
                    buffer.add(key);
                    buffer.add(u);
                    continue;
                }
                buffer.add(key + "=");
                continue;
            }
            if (value instanceof Date) {
                buffer.add(key);
                buffer.add(value.toString());
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (String k : m.keySet()) {
                    Object v = m.get(k);
                    if (v instanceof String) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add((String)v);
                        continue;
                    }
                    if (v instanceof File) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add(((File)v).getPath());
                        continue;
                    }
                    if (v instanceof String[]) {
                        buffer.add(key);
                        buffer.add(k);
                        buffer.add(this.toCommaSeparatedString((String[])v));
                        continue;
                    }
                    if (v instanceof List) {
                        buffer.add(key);
                        buffer.add(k);
                        for (Object next : (List)v) {
                            if (next == null) continue;
                            buffer.add(next.toString());
                        }
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value instanceof int[]) {
                a = (int[])value;
                buffer.add(key);
                buffer.add(String.valueOf(a[0]));
                buffer.add(String.valueOf(a[1]));
                continue;
            }
            if (value instanceof String[]) {
                int length2;
                a = this.merge((String[])args.get(key), (String[])more.get(key));
                int n = length2 = a == null ? 0 : a.length;
                if (length2 > 0) {
                    buffer.add(key);
                } else {
                    buffer.add(key + "=");
                }
                for (j = 0; j < length2; ++j) {
                    if (a[j] == null) continue;
                    buffer.add(a[j]);
                }
                continue;
            }
            if ("--load-config".equals(key) && value instanceof File[]) {
                int length3;
                a = this.merge((File[])args.get(key), (File[])more.get(key));
                int n = length3 = a == null ? 0 : a.length;
                for (int j2 = 0; j2 < length3; ++j2) {
                    if (a[j2] == null) continue;
                    buffer.add(key);
                    buffer.add(a[j2].getPath());
                }
                continue;
            }
            if (value instanceof File[]) {
                int length4;
                a = this.merge((File[])args.get(key), (File[])more.get(key));
                int n = length4 = a == null ? 0 : a.length;
                if (length4 > 0) {
                    buffer.add(key);
                } else {
                    buffer.add(key + "=");
                }
                for (j = 0; j < length4; ++j) {
                    if (a[j] == null) continue;
                    buffer.add(a[j].getPath());
                }
                continue;
            }
            if (value instanceof URL[]) {
                int length5;
                a = this.merge((URL[])args.get(key), (URL[])more.get(key));
                int n = length5 = a == null ? 0 : a.length;
                if (length5 > 0) {
                    buffer.add(key);
                } else {
                    buffer.add(key + "=");
                }
                for (j = 0; j < length5; ++j) {
                    if (a[j] == null) continue;
                    buffer.add(a[j].toExternalForm());
                }
                continue;
            }
            if (value instanceof RslPathList) {
                valueList = (RslPathList)value;
                iter = valueList.iterator();
                while (iter.hasNext()) {
                    StringBuilder sb = new StringBuilder("--runtime-shared-library-path");
                    sb.append("=");
                    String[] cdArgs = (String[])iter.next();
                    sb.append(cdArgs[0]);
                    for (int j3 = 1; j3 < cdArgs.length; ++j3) {
                        sb.append(",");
                        sb.append(cdArgs[j3]);
                    }
                    buffer.add(sb.toString());
                }
                continue;
            }
            if (value instanceof CompilerDefinitionList) {
                CompilerDefinitionList defs = (CompilerDefinitionList)value;
                iter = defs.iterator();
                while (iter.hasNext()) {
                    String name = String.valueOf(iter.next());
                    String val = String.valueOf(iter.next());
                    if (name.length() == 0) {
                        name = "\"\"";
                    }
                    if (val.length() == 0) {
                        val = "\"\"";
                    }
                    buffer.add("--compiler.define+=" + name + "," + val);
                }
                continue;
            }
            if (value instanceof ApplicationDomainsList) {
                valueList = (ApplicationDomainsList)value;
                if (valueList.size() == 0) {
                    buffer.add(key + "=");
                } else {
                    buffer.add(key);
                }
                for (String[] adArgs : valueList) {
                    for (int j4 = 0; j4 < adArgs.length; ++j4) {
                        buffer.add(adArgs[j4]);
                    }
                }
                continue;
            }
            if (value != null) assert (false);
        }
        for (String key : more.keySet()) {
            Object v;
            value = more.get(key);
            if (value instanceof String[]) {
                if (args.containsKey(key)) continue;
                buffer.add(key + "+=" + this.toCommaSeparatedString((String[])value));
                continue;
            }
            if (value instanceof File[]) {
                if (args.containsKey(key)) continue;
                buffer.add(key + "+=" + this.toCommaSeparatedString((File[])value));
                continue;
            }
            if (value instanceof URL[]) {
                if (args.containsKey(key)) continue;
                buffer.add(key + "+=" + this.toCommaSeparatedString((URL[])value));
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (String k : m.keySet()) {
                    v = m.get(k);
                    if (v instanceof List) {
                        for (Object next : (List)v) {
                            if (next == null) continue;
                            buffer.add(key + "+=" + k + "," + next.toString());
                        }
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value instanceof Map) {
                m = (Map)value;
                for (String k : m.keySet()) {
                    v = m.get(k);
                    if (v instanceof List) {
                        for (Object next : (List)v) {
                            if (next == null) continue;
                            buffer.add(key + "+=" + k + "," + next.toString());
                        }
                        continue;
                    }
                    if (v != null) assert (false);
                }
                continue;
            }
            if (value != null) assert (false);
        }
        int n = length = this.extras == null ? 0 : this.extras.length;
        for (int i = 0; processExtras && i < length; ++i) {
            if (this.extras[i] == null) continue;
            buffer.add(this.extras[i]);
        }
        String[] options = new String[buffer.size()];
        buffer.toArray(options);
        return options;
    }

    @Override
    public void enableAccessibility(boolean b) {
        this.args.put("--compiler.accessible", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--compiler.accessible", b ? Boolean.TRUE : Boolean.FALSE);
        this.newLinkerOptionsAfterCompile.add("--compiler.accessible");
    }

    @Override
    public void setActionScriptFileEncoding(String encoding) {
        this.args.put("--compiler.actionscript-file-encoding", encoding);
    }

    @Override
    public void allowSourcePathOverlap(boolean b) {
        this.args.put("--compiler.allow-source-path-overlap", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void useActionScript3(boolean b) {
        this.args.put("--compiler.as3", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setContextRoot(String path) {
        this.args.put("--compiler.context-root", path);
    }

    @Override
    public void enableDebugging(boolean b, String debugPassword) {
        this.args.put("--compiler.debug", b ? Boolean.TRUE : Boolean.FALSE);
        this.args.put("--debug-password", debugPassword);
        this.linker_args.put("--compiler.debug", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--debug-password", debugPassword);
        this.newLinkerOptionsAfterCompile.add("--compiler.debug");
        this.newLinkerOptionsAfterCompile.add("--debug-password");
    }

    @Override
    public void setDefaultCSS(File url) {
        this.args.put("--compiler.defaults-css-url", url);
    }

    @Override
    public void useECMAScript(boolean b) {
        this.args.put("--compiler.es", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setExternalLibraryPath(File[] paths) {
        this.args.put("--compiler.external-library-path", paths);
        this.more.remove("--compiler.external-library-path");
    }

    @Override
    public void addExternalLibraryPath(File[] paths) {
        this.addFiles("--compiler.external-library-path", paths);
    }

    @Override
    public void setFontLanguageRange(String language, String range) {
        if (!this.args.containsKey("--compiler.fonts.languages.language-range")) {
            this.args.put("--compiler.fonts.languages.language-range", new TreeMap());
        }
        Map map = (Map)this.args.get("--compiler.fonts.languages.language-range");
        map.put(language, range);
    }

    @Override
    public void setLocalFontSnapshot(File file) {
        this.args.put("--compiler.fonts.local-fonts-snapshot", file);
    }

    @Override
    public void setLocalFontPaths(String[] paths) {
        this.args.put("--compiler.fonts.local-font-paths", paths);
        this.more.remove("--compiler.fonts.local-font-paths");
    }

    @Override
    public void addLocalFontPaths(String[] paths) {
        this.addStrings("--compiler.fonts.local-font-paths", paths);
    }

    @Override
    public void setFontManagers(String[] classNames) {
        this.args.put("--compiler.fonts.managers", classNames);
        this.more.remove("--compiler.fonts.managers");
    }

    @Override
    public void addFontManagers(String[] classNames) {
        this.addStrings("--compiler.fonts.managers", classNames);
    }

    @Override
    public void setMaximumCachedFonts(int size) {
        if (size > 0) {
            this.args.put("--compiler.fonts.max-cached-fonts", new Integer(size));
        }
    }

    @Override
    public void setMaximumGlyphsPerFace(int size) {
        if (size > 0) {
            this.args.put("--compiler.fonts.max-glyphs-per-face", new Integer(size));
        }
    }

    @Override
    public void useHeadlessServer(boolean b) {
        this.args.put("--compiler.headless-server", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setActionScriptMetadata(String[] md) {
        this.args.put("--compiler.keep-as3-metadata", md);
        this.more.remove("--compiler.keep-as3-metadata");
        this.linker_args.put("--compiler.keep-as3-metadata", md);
        this.linker_more.remove("--compiler.keep-as3-metadata");
        this.newLinkerOptionsAfterCompile.add("--compiler.keep-as3-metadata");
    }

    @Override
    public void addActionScriptMetadata(String[] md) {
        this.addStrings("--compiler.keep-as3-metadata", md);
        this.addStrings(this.linker_more, "--compiler.keep-as3-metadata", md);
        this.newLinkerOptionsAfterCompile.add("--compiler.keep-as3-metadata");
    }

    @Override
    public void keepAllTypeSelectors(boolean b) {
        this.args.put("--compiler.keep-all-type-selectors", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void keepCompilerGeneratedActionScript(boolean b) {
        this.args.put("--compiler.keep-generated-actionscript", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void keepLinkReport(boolean b) {
        this.keepLinkReport = b;
        this.newLinkerOptionsAfterCompile.add("--link-report");
    }

    public boolean keepLinkReport() {
        return this.keepLinkReport;
    }

    @Override
    public void keepSizeReport(boolean b) {
        this.keepSizeReport = b;
        this.newLinkerOptionsAfterCompile.add("--size-report");
    }

    public boolean keepSizeReport() {
        return this.keepSizeReport;
    }

    @Override
    public void keepConfigurationReport(boolean b) {
        this.keepConfigurationReport = b;
    }

    public boolean keepConfigurationReport() {
        return this.keepConfigurationReport;
    }

    @Override
    public void includeLibraries(File[] libraries) {
        this.args.put("--compiler.include-libraries", libraries);
    }

    public void setIncludeResourceBundles(String[] bundles) {
        this.args.put("--include-resource-bundles", bundles);
    }

    public void addIncludeResourceBundles(String[] bundles) {
        this.addStrings("--include-resource-bundles", bundles);
    }

    @Override
    public void setLibraryPath(File[] paths) {
        this.args.put("--compiler.library-path", paths);
        this.more.remove("--compiler.library-path");
    }

    @Override
    public void addLibraryPath(File[] paths) {
        this.addFiles("--compiler.library-path", paths);
    }

    public void setTargets(String[] targets) {
        this.args.put("--compiler.targets", targets);
    }

    @Override
    public void setLocale(String[] locales) {
        this.args.put("--compiler.locale", locales);
    }

    @Override
    public void setLocale(Locale locale) {
        this.setLocale(new String[]{locale.toString()});
    }

    @Override
    public void setComponentManifest(String namespaceURI, File manifest) {
        ArrayList<File> manifests = new ArrayList<File>(2);
        manifests.add(manifest);
        this.setComponentManifests(namespaceURI, manifests);
    }

    public void setComponentManifests(String namespaceURI, List<File> manifests) {
        if (!this.more.containsKey("--compiler.namespaces.namespace")) {
            this.more.put("--compiler.namespaces.namespace", new LinkedHashMap());
        }
        Map map = (Map)this.more.get("--compiler.namespaces.namespace");
        map.put(namespaceURI, manifests);
    }

    @Override
    public void optimize(boolean b) {
        this.args.put("--compiler.optimize", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--compiler.optimize", b ? Boolean.TRUE : Boolean.FALSE);
        this.newLinkerOptionsAfterCompile.add("--compiler.optimize");
    }

    @Override
    public void compress(boolean b) {
        this.args.put("--compiler.compress", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--compiler.compress", b ? Boolean.TRUE : Boolean.FALSE);
        this.newLinkerOptionsAfterCompile.add("--compiler.compress");
    }

    @Override
    public void setServiceConfiguration(File file) {
        this.args.put("--compiler.services", file);
    }

    @Override
    public void showActionScriptWarnings(boolean b) {
        this.args.put("--compiler.show-actionscript-warnings", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void showBindingWarnings(boolean b) {
        this.args.put("--compiler.show-binding-warnings", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void showDeprecationWarnings(boolean b) {
        this.args.put("--compiler.show-deprecation-warnings", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void showShadowedDeviceFontWarnings(boolean b) {
        this.args.put("--compiler.show-shadowed-device-font-warnings", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void showUnusedTypeSelectorWarnings(boolean b) {
        this.args.put("--compiler.show-unused-type-selector-warnings", b ? Boolean.TRUE : Boolean.FALSE);
    }

    public File[] getSourcePath() {
        if (this.args.containsKey("--compiler.source-path")) {
            return (File[])this.args.get("--compiler.source-path");
        }
        if (this.more.containsKey("--compiler.source-path")) {
            return (File[])this.more.get("--compiler.source-path");
        }
        return null;
    }

    @Override
    public void setSourcePath(File[] paths) {
        this.args.put("--compiler.source-path", paths);
        this.more.remove("--compiler.source-path");
    }

    @Override
    public void addSourcePath(File[] paths) {
        this.addFiles("--compiler.source-path", paths);
    }

    @Override
    public void enableStrictChecking(boolean b) {
        this.args.put("--compiler.strict", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setTheme(File[] files) {
        this.args.put("--compiler.theme", files);
        this.more.remove("--compiler.theme");
    }

    @Override
    public void addTheme(File[] files) {
        this.addFiles("--compiler.theme", files);
    }

    @Override
    public void useResourceBundleMetaData(boolean b) {
        this.args.put("--compiler.use-resource-bundle-metadata", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void enableVerboseStacktraces(boolean b) {
        this.args.put("--compiler.verbose-stacktraces", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--compiler.verbose-stacktraces", b ? Boolean.TRUE : Boolean.FALSE);
        this.newLinkerOptionsAfterCompile.add("--compiler.verbose-stacktraces");
    }

    @Override
    public void enableFlashType(boolean b) {
        this.args.put("--compiler.fonts.flash-type", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void enableAdvancedAntiAliasing(boolean b) {
        this.args.put("--compiler.fonts.advanced-anti-aliasing", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void removeUnusedRuntimeSharedLibraryPaths(boolean b) {
        this.args.put("--remove-unused-rsls", b ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void checkActionScriptWarning(int warningCode, boolean b) {
        String key = null;
        switch (warningCode) {
            case 1044: {
                key = "--compiler.warn-array-tostring-changes";
                break;
            }
            case 1100: {
                key = "--compiler.warn-assignment-within-conditional";
                break;
            }
            case 1112: {
                key = "--compiler.warn-bad-array-cast";
                break;
            }
            case 3590: {
                key = "--compiler.warn-bad-bool-assignment";
                break;
            }
            case 3575: {
                key = "--compiler.warn-bad-date-cast";
                break;
            }
            case 3594: {
                key = "--compiler.warn-bad-es3-type-method";
                break;
            }
            case 3592: {
                key = "--compiler.warn-bad-es3-type-prop";
                break;
            }
            case 1098: {
                key = "--compiler.warn-bad-nan-comparison";
                break;
            }
            case 1102: {
                key = "--compiler.warn-bad-null-assignment";
                break;
            }
            case 1096: {
                key = "--compiler.warn-bad-null-comparison";
                break;
            }
            case 1012: {
                key = "--compiler.warn-bad-undefined-comparison";
                break;
            }
            case 1034: {
                key = "--compiler.warn-boolean-constructor-with-no-args";
                break;
            }
            case 1066: {
                key = "--compiler.warn-changes-in-resolve";
                break;
            }
            case 1072: {
                key = "--compiler.warn-class-is-sealed";
                break;
            }
            case 1110: {
                key = "--compiler.warn-const-not-initialized";
                break;
            }
            case 1030: {
                key = "--compiler.warn-constructor-returns-value";
                break;
            }
            case 1090: {
                key = "--compiler.warn-deprecated-event-handler-error";
                break;
            }
            case 1060: {
                key = "--compiler.warn-deprecated-function-error";
                break;
            }
            case 1058: {
                key = "--compiler.warn-deprecated-property-error";
                break;
            }
            case 3583: {
                key = "--compiler.warn-duplicate-argument-names";
                break;
            }
            case 3596: {
                key = "--compiler.warn-duplicate-variable-def";
                break;
            }
            case 1086: {
                key = "--compiler.warn-for-var-in-changes";
                break;
            }
            case 3581: {
                key = "--compiler.warn-import-hides-class";
                break;
            }
            case 3555: {
                key = "--compiler.warn-instance-of-changes";
                break;
            }
            case 1088: {
                key = "--compiler.warn-internal-error";
                break;
            }
            case 1070: {
                key = "--compiler.warn-level-not-supported";
                break;
            }
            case 1084: {
                key = "--compiler.warn-missing-namespace-decl";
                break;
            }
            case 1092: {
                key = "--compiler.warn-negative-uint-literal";
                break;
            }
            case 1104: {
                key = "--compiler.warn-no-constructor";
                break;
            }
            case 1114: {
                key = "--compiler.warn-no-explicit-super-call-in-constructor";
                break;
            }
            case 1008: {
                key = "--compiler.warn-no-type-decl";
                break;
            }
            case 1038: {
                key = "--compiler.warn-number-from-string-changes";
                break;
            }
            case 1082: {
                key = "--compiler.warn-scoping-change-in-this";
                break;
            }
            case 3551: {
                key = "--compiler.warn-slow-text-field-addition";
                break;
            }
            case 3553: {
                key = "--compiler.warn-unlikely-function-value";
                break;
            }
            case 3573: {
                key = "--compiler.warn-xml-class-has-changed";
            }
        }
        if (key != null) {
            this.args.put(key, b ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setDefaultBackgroundColor(int color) {
        this.args.put("--default-background-color", new Integer(color));
        this.linker_args.put("--default-background-color", new Integer(color));
        this.newLinkerOptionsAfterCompile.add("--default-background-color");
    }

    @Override
    public void setDefaultFrameRate(int rate) {
        this.args.put("--default-frame-rate", new Integer(rate));
        this.linker_args.put("--default-frame-rate", new Integer(rate));
        this.newLinkerOptionsAfterCompile.add("--default-frame-rate");
    }

    @Override
    public void setDefaultScriptLimits(int maxRecursionDepth, int maxExecutionTime) {
        this.args.put("--default-script-limits", new int[]{maxRecursionDepth, maxExecutionTime});
        this.linker_args.put("--default-script-limits", new int[]{maxRecursionDepth, maxExecutionTime});
        this.newLinkerOptionsAfterCompile.add("--default-script-limits");
    }

    @Override
    public void setDefaultSize(int width, int height) {
        this.args.put("--default-size", new int[]{width, height});
        this.linker_args.put("--default-size", new int[]{width, height});
        this.newLinkerOptionsAfterCompile.add("--default-size");
    }

    @Override
    public void setExterns(String[] definitions) {
        this.args.put("--externs", definitions);
        this.more.remove("--externs");
        this.linker_args.put("--externs", definitions);
        this.linker_more.remove("--externs");
        this.newLinkerOptionsAfterCompile.add("--externs");
    }

    @Override
    public void addExterns(String[] definitions) {
        this.addStrings("--externs", definitions);
        this.addStrings(this.linker_more, "--externs", definitions);
        this.newLinkerOptionsAfterCompile.add("--externs");
    }

    @Override
    public void setConfiguration(File file) {
        this.args.put("--load-config", new File[]{file});
        this.more.remove("--load-config");
    }

    @Override
    public void addConfiguration(File file) {
        this.addFiles("--load-config", new File[]{file});
    }

    @Override
    public void setConfiguration(String[] args) {
        this.extras = args;
    }

    @Override
    public void setExterns(File[] files) {
        this.args.put("--load-externs", files);
        this.more.remove("--load-externs");
        this.linker_args.put("--load-externs", files);
        this.linker_more.remove("--load-externs");
        this.newLinkerOptionsAfterCompile.add("--load-externs");
    }

    @Override
    public void addExterns(File[] files) {
        this.addFiles("--load-externs", files);
        this.addFiles(this.linker_more, "--load-externs", files);
        this.newLinkerOptionsAfterCompile.add("--load-externs");
    }

    @Override
    public void setFrameLabel(String label, String[] classNames) {
        if (!this.args.containsKey("--frames.frame")) {
            this.args.put("--frames.frame", new TreeMap());
        }
        Map map = (Map)this.args.get("--frames.frame");
        map.put(label, classNames);
        if (!this.linker_args.containsKey("--frames.frame")) {
            this.linker_args.put("--frames.frame", new TreeMap());
        }
        Map map2 = (Map)this.linker_args.get("--frames.frame");
        map2.put(label, classNames);
        this.newLinkerOptionsAfterCompile.add("--frames.frame");
    }

    @Override
    public void setIncludes(String[] definitions) {
        this.args.put("--includes", definitions);
        this.more.remove("--includes");
        this.linker_args.put("--includes", definitions);
        this.linker_more.remove("--includes");
        this.newLinkerOptionsAfterCompile.add("--includes");
    }

    @Override
    public void addIncludes(String[] definitions) {
        this.addStrings("--includes", definitions);
        this.addStrings(this.linker_more, "--includes", definitions);
        this.newLinkerOptionsAfterCompile.add("--includes");
    }

    @Override
    public void setLicense(String productName, String serialNumber) {
        if (!this.args.containsKey("--licenses.license")) {
            this.args.put("--licenses.license", new TreeMap());
        }
        Map map = (Map)this.args.get("--licenses.license");
        map.put(productName, serialNumber);
    }

    @Override
    public void setSWFMetaData(int field, Object value) {
        switch (field) {
            case 1: {
                this.args.put("--metadata.contributor", value);
                break;
            }
            case 2: {
                this.args.put("--metadata.creator", value);
                break;
            }
            case 4: {
                this.args.put("--metadata.date", value);
                break;
            }
            case 8: {
                this.args.put("--metadata.localized-description", value);
                break;
            }
            case 16: {
                this.args.put("--metadata.localized-title", value);
                break;
            }
            case 32: {
                this.args.put("--metadata.language", value);
                break;
            }
            case 64: {
                this.args.put("--metadata.publisher", value);
            }
        }
        switch (field) {
            case 1: {
                this.linker_args.put("--metadata.contributor", value);
                break;
            }
            case 2: {
                this.linker_args.put("--metadata.creator", value);
                break;
            }
            case 4: {
                this.linker_args.put("--metadata.date", value);
                break;
            }
            case 8: {
                this.linker_args.put("--metadata.localized-description", value);
                break;
            }
            case 16: {
                this.linker_args.put("--metadata.localized-title", value);
                break;
            }
            case 32: {
                this.linker_args.put("--metadata.language", value);
                break;
            }
            case 64: {
                this.linker_args.put("--metadata.publisher", value);
            }
        }
        this.newLinkerOptionsAfterCompile.add("--metadata.contributor");
        this.newLinkerOptionsAfterCompile.add("--metadata.creator");
        this.newLinkerOptionsAfterCompile.add("--metadata.date");
        this.newLinkerOptionsAfterCompile.add("--metadata.localized-description");
        this.newLinkerOptionsAfterCompile.add("--metadata.localized-title");
        this.newLinkerOptionsAfterCompile.add("--metadata.language");
        this.newLinkerOptionsAfterCompile.add("--metadata.publisher");
        this.args.remove("--raw-metadata");
        this.linker_args.remove("--raw-metadata");
        this.newLinkerOptionsAfterCompile.remove("--raw-metadata");
    }

    public void setProjector(File file) {
        this.args.put("--projector", file);
    }

    @Override
    public void setSWFMetaData(String xml) {
        this.args.put("--raw-metadata", xml);
        this.linker_args.put("--raw-metadata", xml);
        this.args.remove("--metadata.contributor");
        this.args.remove("--metadata.creator");
        this.args.remove("--metadata.date");
        this.args.remove("--metadata.localized-description");
        this.args.remove("--metadata.localized-title");
        this.args.remove("--metadata.language");
        this.args.remove("--metadata.publisher");
        this.linker_args.remove("--metadata.contributor");
        this.linker_args.remove("--metadata.creator");
        this.linker_args.remove("--metadata.date");
        this.linker_args.remove("--metadata.localized-description");
        this.linker_args.remove("--metadata.localized-title");
        this.linker_args.remove("--metadata.language");
        this.linker_args.remove("--metadata.publisher");
        this.newLinkerOptionsAfterCompile.remove("--metadata.contributor");
        this.newLinkerOptionsAfterCompile.remove("--metadata.creator");
        this.newLinkerOptionsAfterCompile.remove("--metadata.date");
        this.newLinkerOptionsAfterCompile.remove("--metadata.localized-description");
        this.newLinkerOptionsAfterCompile.remove("--metadata.localized-title");
        this.newLinkerOptionsAfterCompile.remove("--metadata.language");
        this.newLinkerOptionsAfterCompile.remove("--metadata.publisher");
    }

    @Override
    public void setRuntimeSharedLibraries(String[] libraries) {
        this.args.put("--runtime-shared-libraries", libraries);
        this.more.remove("--runtime-shared-libraries");
    }

    @Override
    public void addRuntimeSharedLibraries(String[] libraries) {
        this.addStrings("--runtime-shared-libraries", libraries);
    }

    @Override
    public void useNetwork(boolean b) {
        this.args.put("--use-network", b ? Boolean.TRUE : Boolean.FALSE);
        this.linker_args.put("--use-network", b ? Boolean.TRUE : Boolean.FALSE);
        this.newLinkerOptionsAfterCompile.add("--use-network");
    }

    @Override
    public void setToken(String name, String value) {
        this.tokens.put(name, value);
    }

    private void addFiles(String key, File[] files) {
        this.addFiles(this.more, key, files);
    }

    private void addFiles(Map<String, Object> more, String key, File[] files) {
        File[] existing = null;
        if (more.containsKey(key)) {
            existing = (File[])more.get(key);
        }
        if (existing != null) {
            int length1 = existing.length;
            int length2 = files == null ? 0 : files.length;
            File[] newPaths = new File[length1 + length2];
            System.arraycopy(existing, 0, newPaths, 0, length1);
            System.arraycopy(files, 0, newPaths, length1, length2);
            files = newPaths;
        }
        more.put(key, files);
    }

    private String[] merge(String[] a1, String[] a2) {
        int l1 = a1 == null ? 0 : a1.length;
        int l2 = a2 == null ? 0 : a2.length;
        String[] a3 = new String[l1 + l2];
        if (a1 != null) {
            System.arraycopy(a1, 0, a3, 0, l1);
        }
        if (a2 != null) {
            System.arraycopy(a2, 0, a3, l1, l2);
        }
        return a3;
    }

    private File[] merge(File[] a1, File[] a2) {
        int l1 = a1 == null ? 0 : a1.length;
        int l2 = a2 == null ? 0 : a2.length;
        File[] a3 = new File[l1 + l2];
        if (a1 != null) {
            System.arraycopy(a1, 0, a3, 0, l1);
        }
        if (a2 != null) {
            System.arraycopy(a2, 0, a3, l1, l2);
        }
        return a3;
    }

    private URL[] merge(URL[] a1, URL[] a2) {
        int l1 = a1 == null ? 0 : a1.length;
        int l2 = a2 == null ? 0 : a2.length;
        URL[] a3 = new URL[l1 + l2];
        if (a1 != null) {
            System.arraycopy(a1, 0, a3, 0, l1);
        }
        if (a2 != null) {
            System.arraycopy(a2, 0, a3, l1, l2);
        }
        return a3;
    }

    private void addStrings(String key, String[] strings) {
        this.addStrings(this.more, key, strings);
    }

    private void addStrings(Map<String, Object> more, String key, String[] strings) {
        String[] existing = null;
        if (more.containsKey(key)) {
            existing = (String[])more.get(key);
        }
        if (existing != null) {
            int length1 = existing.length;
            int length2 = strings == null ? 0 : strings.length;
            String[] newStrings = new String[length1 + length2];
            System.arraycopy(existing, 0, newStrings, 0, length1);
            System.arraycopy(strings, 0, newStrings, length1, length2);
            strings = newStrings;
        }
        more.put(key, strings);
    }

    public String toString() {
        String[] args = this.getCompilerOptions();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            b.append(args[i]);
            b.append(' ');
        }
        return b.toString();
    }

    private File toFile(VirtualFile f) {
        return f instanceof LocalFile ? new File(f.getName()) : null;
    }

    private URL toURL(VirtualFile f) {
        try {
            return f instanceof LocalFile ? new File(f.getName()).toURL() : null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private File[] toFiles(VirtualFile[] files) {
        File[] newFiles = new File[files == null ? 0 : files.length];
        int length = newFiles.length;
        for (int i = 0; i < length; ++i) {
            newFiles[i] = this.toFile(files[i]);
        }
        return newFiles;
    }

    private String[] toStrings(List list) {
        String[] strings = new String[list == null ? 0 : list.size()];
        int length = strings.length;
        for (int i = 0; i < length; ++i) {
            strings[i] = (String)list.get(i);
        }
        return strings;
    }

    private String[] toStrings(Set set) {
        String[] strings = new String[set == null ? 0 : set.size()];
        if (set != null) {
            int k = 0;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                strings[k] = (String)i.next();
                ++k;
            }
        }
        return strings;
    }

    private int toInteger(String num) {
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private String toCommaSeparatedString(String[] strings) {
        int length;
        StringBuilder b = new StringBuilder();
        int n = length = strings == null ? 0 : strings.length;
        for (int i = 0; i < length; ++i) {
            b.append(strings[i]);
            if (i >= length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    private String toCommaSeparatedString(File[] files) {
        int length;
        StringBuilder b = new StringBuilder();
        int n = length = files == null ? 0 : files.length;
        for (int i = 0; i < length; ++i) {
            b.append(files[i].getPath());
            if (i >= length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    private String toCommaSeparatedString(URL[] urls) {
        int length;
        StringBuilder b = new StringBuilder();
        int n = length = urls == null ? 0 : urls.length;
        for (int i = 0; i < length; ++i) {
            b.append(urls[i].toExternalForm());
            if (i >= length - 1) continue;
            b.append(',');
        }
        return b.toString();
    }

    private void populateDefaults(ToolsConfiguration c) {
        this.setDefaultBackgroundColor(c.backgroundColor());
        this.setDefaultFrameRate(c.getFrameRate());
        this.setDefaultScriptLimits(c.getScriptRecursionLimit(), c.getScriptTimeLimit());
        this.setDefaultSize(c.defaultWidth(), c.defaultHeight());
        this.setExterns(this.toStrings(c.getExterns()));
        this.setIncludes(this.toStrings(c.getIncludes()));
        this.setTargetPlayer(c.getTargetPlayerMajorVersion(), c.getTargetPlayerMinorVersion(), c.getTargetPlayerRevision());
        this.enableDigestVerification(c.getVerifyDigests());
        this.removeUnusedRuntimeSharedLibraryPaths(c.getRemoveUnusedRsls());
        List<Configuration.RslPathInfo> rslList = c.getRslPathInfo();
        boolean first = true;
        for (Configuration.RslPathInfo info : rslList) {
            String[] rslUrls = info.getRslUrls().toArray(new String[0]);
            String[] policyUrls = info.getPolicyFileUrls().toArray(new String[0]);
            if (first) {
                this.setRuntimeSharedLibraryPath(info.getSwcPath(), rslUrls, policyUrls);
                first = false;
                continue;
            }
            this.addRuntimeSharedLibraryPath(info.getSwcPath(), rslUrls, policyUrls);
        }
        this.setSWFMetaData(c.getMetadata());
        this.setRuntimeSharedLibraries(this.toStrings(c.getRuntimeSharedLibraries()));
        this.useNetwork(c.useNetwork());
        this.populateDefaults(c.getCompilerConfiguration());
        this.populateDefaults(c.getFramesConfiguration());
        this.populateDefaults(c.getLicensesConfiguration());
        this.populateDefaults(c.getRuntimeSharedLibrarySettingsConfiguration());
    }

    private void populateDefaults(CompilerConfiguration cc) {
        this.enableAccessibility(cc.accessible());
        this.setActionScriptMetadata(cc.getKeepAs3Metadata());
        this.setActionScriptFileEncoding(cc.getActionscriptFileEncoding());
        this.allowSourcePathOverlap(cc.allowSourcePathOverlap());
        this.useActionScript3(cc.dialect() == 10);
        this.setContextRoot(cc.getContextRoot());
        this.enableDebugging(cc.debug(), this.configuration.debugPassword());
        if (cc.getDefaultsCssUrl() != null) {
            this.setDefaultCSS(FileUtil.openFile(cc.getDefaultsCssUrl().getName()));
        }
        this.useECMAScript(cc.dialect() == 9);
        this.setExternalLibraryPath(this.toFiles(cc.getExternalLibraryPath()));
        this.useHeadlessServer(cc.headlessServer());
        this.keepAllTypeSelectors(cc.keepAllTypeSelectors());
        this.keepCompilerGeneratedActionScript(cc.keepGeneratedActionScript());
        this.includeLibraries(this.toFiles(cc.getIncludeLibraries()));
        this.setLibraryPath(this.toFiles(cc.getLibraryPath()));
        this.setLocale(cc.getLocales());
        this.optimize(cc.optimize());
        this.setServiceConfiguration(this.toFile(cc.getServices()));
        this.showActionScriptWarnings(cc.warnings());
        this.showBindingWarnings(cc.showBindingWarnings());
        this.showDeprecationWarnings(cc.showDeprecationWarnings());
        this.showShadowedDeviceFontWarnings(cc.showShadowedDeviceFontWarnings());
        this.showUnusedTypeSelectorWarnings(cc.showUnusedTypeSelectorWarnings());
        this.setSourcePath(cc.getUnexpandedSourcePath());
        this.enableStrictChecking(cc.strict());
        this.setTheme(this.toFiles(cc.getThemeFiles()));
        this.useResourceBundleMetaData(cc.useResourceBundleMetadata());
        this.enableVerboseStacktraces(cc.debug());
        this.setDefineDirective(cc.getDefine());
        this.setCompatibilityVersion(cc.getMxmlConfiguration().getMajorCompatibilityVersion(), cc.getMxmlConfiguration().getMinorCompatibilityVersion(), cc.getMxmlConfiguration().getRevisionCompatibilityVersion());
        this.checkActionScriptWarning(1044, cc.warn_array_tostring_changes());
        this.checkActionScriptWarning(1100, cc.warn_assignment_within_conditional());
        this.checkActionScriptWarning(1112, cc.warn_bad_array_cast());
        this.checkActionScriptWarning(3590, cc.warn_bad_bool_assignment());
        this.checkActionScriptWarning(3575, cc.warn_bad_date_cast());
        this.checkActionScriptWarning(3594, cc.warn_bad_es3_type_method());
        this.checkActionScriptWarning(3592, cc.warn_bad_es3_type_prop());
        this.checkActionScriptWarning(1098, cc.warn_bad_nan_comparison());
        this.checkActionScriptWarning(1102, cc.warn_bad_null_assignment());
        this.checkActionScriptWarning(1096, cc.warn_bad_null_comparison());
        this.checkActionScriptWarning(1012, cc.warn_bad_undefined_comparison());
        this.checkActionScriptWarning(1034, cc.warn_boolean_constructor_with_no_args());
        this.checkActionScriptWarning(1066, cc.warn_changes_in_resolve());
        this.checkActionScriptWarning(1072, cc.warn_class_is_sealed());
        this.checkActionScriptWarning(1110, cc.warn_const_not_initialized());
        this.checkActionScriptWarning(1030, cc.warn_constructor_returns_value());
        this.checkActionScriptWarning(1090, cc.warn_deprecated_event_handler_error());
        this.checkActionScriptWarning(1060, cc.warn_deprecated_function_error());
        this.checkActionScriptWarning(1058, cc.warn_deprecated_property_error());
        this.checkActionScriptWarning(3583, cc.warn_duplicate_argument_names());
        this.checkActionScriptWarning(3596, cc.warn_duplicate_variable_def());
        this.checkActionScriptWarning(1086, cc.warn_for_var_in_changes());
        this.checkActionScriptWarning(3581, cc.warn_import_hides_class());
        this.checkActionScriptWarning(3555, cc.warn_instance_of_changes());
        this.checkActionScriptWarning(1088, cc.warn_internal_error());
        this.checkActionScriptWarning(1070, cc.warn_level_not_supported());
        this.checkActionScriptWarning(1084, cc.warn_missing_namespace_decl());
        this.checkActionScriptWarning(1092, cc.warn_negative_uint_literal());
        this.checkActionScriptWarning(1104, cc.warn_no_constructor());
        this.checkActionScriptWarning(1114, cc.warn_no_explicit_super_call_in_constructor());
        this.checkActionScriptWarning(1008, cc.warn_no_type_decl());
        this.checkActionScriptWarning(1038, cc.warn_number_from_string_changes());
        this.checkActionScriptWarning(1082, cc.warn_scoping_change_in_this());
        this.checkActionScriptWarning(3551, cc.warn_slow_text_field_addition());
        this.checkActionScriptWarning(3553, cc.warn_unlikely_function_value());
        this.checkActionScriptWarning(3573, cc.warn_xml_class_has_changed());
        this.populateDefaults(cc.getFontsConfiguration());
        this.populateDefaults(cc.getNamespacesConfiguration());
    }

    private void populateDefaults(FontsConfiguration fc) {
        FontsConfiguration.Languages lc = fc.getLanguagesConfiguration();
        for (String string : lc.keySet()) {
            this.setFontLanguageRange(string, lc.getProperty(string));
        }
        this.setLocalFontSnapshot(this.toFile(fc.getLocalFontsSnapshot()));
        this.setLocalFontPaths(this.toStrings(fc.getLocalFontPaths()));
        this.setFontManagers(this.toStrings(fc.getManagers()));
        this.setMaximumCachedFonts(this.toInteger(fc.getMaxCachedFonts()));
        this.setMaximumGlyphsPerFace(this.toInteger(fc.getMaxGlyphsPerFace()));
        this.enableAdvancedAntiAliasing(fc.getFlashType());
    }

    private void populateDefaults(NamespacesConfiguration nc) {
        Map<String, List<VirtualFile>> manifestMappings = nc.getManifestMappings();
        if (manifestMappings != null) {
            for (Map.Entry<String, List<VirtualFile>> entry : manifestMappings.entrySet()) {
                String uri = entry.getKey();
                List<VirtualFile> virtualFiles = entry.getValue();
                ArrayList<File> files = new ArrayList<File>(virtualFiles.size());
                Iterator<VirtualFile> vi = virtualFiles.iterator();
                while (vi.hasNext()) {
                    files.add(this.toFile(vi.next()));
                }
                this.setComponentManifests(uri, files);
            }
        }
    }

    private void populateDefaults(FramesConfiguration frc) {
        int length;
        List<FramesConfiguration.FrameInfo> frList = frc.getFrameList();
        int n = length = frList == null ? 0 : frList.size();
        for (int i = 0; i < length; ++i) {
            FramesConfiguration.FrameInfo info = frList.get(i);
            this.setFrameLabel(info.label, this.toStrings(info.frameClasses));
        }
    }

    private void populateDefaults(LicensesConfiguration lic) {
        Map<String, String> licenseMap = lic.getLicenseMap();
        if (licenseMap != null) {
            for (String name : licenseMap.keySet()) {
                this.setLicense(name, licenseMap.get(name));
            }
        }
    }

    private void populateDefaults(RuntimeSharedLibrarySettingsConfiguration configuration) {
        this.setForceRuntimeSharedLibraryPaths(this.toFiles(configuration.getForceRsls()));
        Map<VirtualFile, String> adMap = configuration.getApplicationDomains();
        boolean first = true;
        for (Map.Entry<VirtualFile, String> entry : adMap.entrySet()) {
            File file = this.toFile(entry.getKey());
            if (first) {
                this.setApplicationDomainForRuntimeSharedLibraryPath(file, entry.getValue());
                first = false;
                continue;
            }
            this.addApplicationDomainForRuntimeSharedLibraryPath(file, entry.getValue());
        }
    }

    public boolean hasChanged() {
        return this.newLinkerOptionsAfterCompile.size() > 0;
    }

    public void reset() {
        this.newLinkerOptionsAfterCompile.clear();
    }

    @Override
    public void setTargetPlayer(int major, int minor, int revision) {
        this.args.put("--target-player", major + "." + minor + "." + revision);
    }

    @Override
    public void setCompatibilityVersion(int major, int minor, int revision) {
        if (major != 0 || minor != 0 || revision != 0) {
            this.args.put("--compiler.mxml.compatibility-version", major + "." + minor + "." + revision);
        }
    }

    private String[] createCrossDomainArray(String swc, String[] rslUrls, String[] policyFileUrls) {
        if (swc == null || rslUrls == null || policyFileUrls == null) {
            throw new NullPointerException();
        }
        if (rslUrls.length != policyFileUrls.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> rslList = new ArrayList<String>();
        rslList.add(swc);
        int argCount = rslUrls.length;
        for (int i = 0; i < argCount; ++i) {
            rslList.add(rslUrls[i]);
            rslList.add(policyFileUrls[i]);
        }
        return rslList.toArray(new String[0]);
    }

    @Override
    public void enableDigestComputation(boolean compute) {
        this.args.put("--compute-digest", compute ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void addRuntimeSharedLibraryPath(String swc, String[] rslUrls, String[] policyFileUrls) {
        String[] rslArray = this.createCrossDomainArray(swc, rslUrls, policyFileUrls);
        RslPathList value = (RslPathList)this.args.get("--runtime-shared-library-path");
        if (value == null) {
            value = new RslPathList();
            this.args.put("--runtime-shared-library-path", value);
        }
        value.add(rslArray);
    }

    @Override
    public void setRuntimeSharedLibraryPath(String swc, String[] rslUrls, String[] policyFileUrls) {
        String[] rslArray = this.createCrossDomainArray(swc, rslUrls, policyFileUrls);
        RslPathList list = new RslPathList();
        list.add(rslArray);
        this.args.put("--runtime-shared-library-path", list);
    }

    @Override
    public void enableDigestVerification(boolean verify) {
        this.args.put("--verify-digests", verify ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void addDefineDirective(String name, String value) {
        CompilerDefinitionList defs = (CompilerDefinitionList)this.args.get("--compiler.define");
        if (defs == null) {
            defs = new CompilerDefinitionList();
            this.args.put("--compiler.define", defs);
        }
        defs.add(name);
        defs.add(value);
    }

    @Override
    public void setDefineDirective(String[] names, String[] values) {
        if (names == null || values == null || names.length != values.length) {
            this.args.remove("--compiler.define");
        } else {
            CompilerDefinitionList defs = new CompilerDefinitionList();
            this.args.put("--compiler.define", defs);
            for (int i = 0; i < values.length; ++i) {
                defs.add(names[i]);
                defs.add(values[i]);
            }
        }
    }

    private void setDefineDirective(ObjectList<ConfigVar> configVars) {
        if (configVars != null) {
            CompilerDefinitionList defs = new CompilerDefinitionList();
            this.args.put("--compiler.define", defs);
            for (ConfigVar var : configVars) {
                assert (var != null && var.ns != null && var.name != null && var.value != null && var.ns.length() > 0 && var.name.length() > 0 && var.value.length() > 0);
                defs.add(var.ns + "::" + var.name);
                defs.add(var.value);
            }
        }
    }

    public Map<String, List<String>> getExtensions() {
        if (!this.args.containsKey("--compiler.extensions.extension")) {
            this.args.put("--compiler.extensions.extension", new LinkedHashMap());
        }
        return (Map)this.args.get("--compiler.extensions.extension");
    }

    @Override
    public void addExtensionLibraries(File extension, List<String> parameter) {
        this.getExtensions().put(extension.getAbsolutePath(), parameter);
    }

    @Override
    public void setExtensionLibraries(Map<File, List<String>> extensions) {
        this.getExtensions().clear();
        Set<File> keys = extensions.keySet();
        for (File key : keys) {
            this.addExtensionLibraries(key, extensions.get(key));
        }
    }

    public OEMConfiguration clone() {
        OEMConfiguration cloneConfig;
        try {
            cloneConfig = (OEMConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        cloneConfig.args = new LinkedHashMap<String, Object>(this.args);
        cloneConfig.defaults = new LinkedHashMap<String, Object>(this.defaults);
        cloneConfig.more = new LinkedHashMap<String, Object>(this.more);
        cloneConfig.linker_args = new LinkedHashMap<String, Object>(this.linker_args);
        cloneConfig.linker_more = new LinkedHashMap<String, Object>(this.linker_more);
        return cloneConfig;
    }

    @Override
    public void addForceRuntimeSharedLibraryPaths(File[] paths) {
        if (paths == null) {
            throw new NullPointerException("paths may not be null");
        }
        this.addFiles("--runtime-shared-library-settings.force-rsls", paths);
    }

    @Override
    public void setForceRuntimeSharedLibraryPaths(File[] paths) {
        if (paths == null) {
            throw new NullPointerException("paths may not be null");
        }
        this.args.put("--runtime-shared-library-settings.force-rsls", paths);
        this.more.remove("--runtime-shared-library-settings.force-rsls");
    }

    @Override
    public void addApplicationDomainForRuntimeSharedLibraryPath(File path, String applicationDomainTarget) {
        this.validateApplicationDomainArguments(path, applicationDomainTarget);
        ApplicationDomainsList value = (ApplicationDomainsList)this.args.get("--runtime-shared-library-settings.application-domain");
        if (value == null) {
            value = new ApplicationDomainsList();
            this.args.put("--runtime-shared-library-settings.application-domain", value);
        }
        value.add(new String[]{path.getPath(), applicationDomainTarget});
    }

    @Override
    public void setApplicationDomainForRuntimeSharedLibraryPath(File path, String applicationDomainTarget) {
        ApplicationDomainsList list = new ApplicationDomainsList();
        if (path == null) {
            this.args.put("--runtime-shared-library-settings.application-domain", list);
            return;
        }
        this.validateApplicationDomainArguments(path, applicationDomainTarget);
        list.add(new String[]{path.getPath(), applicationDomainTarget});
        this.args.put("--runtime-shared-library-settings.application-domain", list);
    }

    private void validateApplicationDomainArguments(File path, String applicationDomainTarget) {
        if (path == null) {
            throw new NullPointerException("paths may not be null");
        }
        if (applicationDomainTarget == null) {
            throw new NullPointerException("applicationDomains may not be null");
        }
    }

    class ApplicationDomainsList
    extends ArrayList<String[]> {
        private static final long serialVersionUID = 0L;

        ApplicationDomainsList() {
        }
    }

    class CompilerDefinitionList
    extends ArrayList<String> {
        private static final long serialVersionUID = 0L;

        CompilerDefinitionList() {
        }
    }

    class RslPathList
    extends ArrayList<String[]> {
        private static final long serialVersionUID = 0L;

        RslPathList() {
        }
    }
}

