/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.Deque;

abstract class GuardedCallback<T>
implements NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    private final SetMultimap<Node, T> registeredGuards = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Multiset<T> guarded = HashMultiset.create();
    private final ListMultimap<Node, T> installedGuards = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Deque<Context> contextStack = new ArrayDeque<Context>();
    private static final ImmutableSet<String> PROPERTY_TEST_FUNCTIONS = ImmutableSet.of("String", "Boolean");
    private static final ImmutableSet<Token> CAN_HAVE_GUARDS = Sets.immutableEnumSet((Enum)Token.AND, (Enum[])new Token[]{Token.OR, Token.HOOK, Token.IF, Token.BLOCK, Token.SCRIPT});

    GuardedCallback(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public final boolean shouldTraverse(NodeTraversal traversal, Node n, Node parent) {
        if (parent == null) {
            this.contextStack.push(Context.EMPTY);
        } else {
            this.contextStack.push(this.contextStack.peek().descend(this.compiler, parent, n));
            if (parent != null && CAN_HAVE_GUARDS.contains((Object)parent.getToken()) && this.registeredGuards.containsKey(parent)) {
                for (Object resource : this.registeredGuards.removeAll(parent)) {
                    this.guarded.add(resource);
                    this.installedGuards.put(parent, resource);
                }
            }
        }
        return true;
    }

    @Override
    public final void visit(NodeTraversal traversal, Node n, Node parent) {
        if (parent != null && CAN_HAVE_GUARDS.contains((Object)n.getToken()) && this.installedGuards.containsKey(n)) {
            this.guarded.removeAll(this.installedGuards.removeAll(n));
        }
        if (GuardedCallback.isAbrupt(n)) {
            this.promoteAbruptReturns(parent);
        }
        this.visitGuarded(traversal, n, parent);
        this.contextStack.pop();
    }

    private void promoteAbruptReturns(Node parent) {
        Node grandparent;
        if (parent.isBlock()) {
            parent = parent.getParent();
        }
        if (parent.isIf() && this.installedGuards.containsKey(parent) && ((grandparent = parent.getParent()).isBlock() || grandparent.isScript())) {
            this.registeredGuards.putAll(grandparent, this.installedGuards.get((Object)parent));
        }
    }

    abstract void visitGuarded(NodeTraversal var1, Node var2, Node var3);

    boolean isGuarded(T resource) {
        if (this.guarded.contains(resource)) {
            return true;
        }
        Context context = this.contextStack.peek();
        if (!context.safe) {
            return false;
        }
        while (context != null && context.conditional != null) {
            this.registeredGuards.put(context.conditional, resource);
            context = context.linked;
        }
        return true;
    }

    private static boolean isAbrupt(Node n) {
        return n.isReturn() || n.isThrow();
    }

    private static boolean isPropertyTestFunction(AbstractCompiler compiler, Node n) {
        if (compiler.getCodingConvention().isPropertyTestFunction(n)) {
            return true;
        }
        Node target = n.getFirstChild();
        return target.isName() && PROPERTY_TEST_FUNCTIONS.contains(target.getString());
    }

    private static class Context {
        static final Context EMPTY = new Context(null, false, null);
        final Node conditional;
        final boolean safe;
        final Context linked;

        Context(Node conditional, boolean safe, Context linked) {
            this.conditional = conditional;
            this.safe = safe;
            this.linked = linked;
        }

        Context link(Node newConditional, boolean newSafe) {
            return new Context(newConditional, newSafe, this.conditional != null ? this : null);
        }

        Context propagate(boolean newSafe) {
            return newSafe == this.safe ? this : new Context(this.conditional, newSafe, this.linked);
        }

        Context descend(AbstractCompiler compiler, Node parent, Node child) {
            boolean first = child == parent.getFirstChild();
            switch (parent.getToken()) {
                case CAST: {
                    return this;
                }
                case COMMA: {
                    return child == parent.getLastChild() ? this : this.propagate(true);
                }
                case AND: {
                    return first ? this.link(parent, true) : this;
                }
                case OR: {
                    return first ? this.link(parent, false) : this;
                }
                case HOOK: {
                    return first ? this.link(parent, true) : this;
                }
                case IF: {
                    return first ? this.link(parent, true) : EMPTY;
                }
                case INSTANCEOF: 
                case ASSIGN: {
                    return this.propagate(first);
                }
                case TYPEOF: 
                case NOT: 
                case EQ: 
                case NE: 
                case SHEQ: 
                case SHNE: {
                    return this.propagate(true);
                }
                case CALL: {
                    return this.propagate(!first && GuardedCallback.isPropertyTestFunction(compiler, parent));
                }
                case ROOT: {
                    return EMPTY;
                }
            }
            return NodeUtil.isStatement(parent) ? EMPTY : this.propagate(false);
        }
    }
}

