/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.debug;

import flash.swf.Action;
import flash.swf.ActionHandler;

public class RegisterRecord
extends Action {
    public int[] registerNumbers;
    public String[] variableNames;
    public int offset;
    int next;

    public RegisterRecord(int offset, int numRegisters) {
        super(258);
        int size = numRegisters;
        this.registerNumbers = new int[size];
        this.variableNames = new String[size];
        this.offset = offset;
        this.next = 0;
    }

    public void addRegister(int regNbr, String variableName) {
        this.registerNumbers[this.next] = regNbr;
        this.variableNames[this.next] = variableName;
        ++this.next;
    }

    public int indexOf(int regNbr) {
        int at = -1;
        for (int i = 0; at < 0 && i < this.registerNumbers.length; ++i) {
            if (this.registerNumbers[i] != regNbr) continue;
            at = i;
        }
        return at;
    }

    @Override
    public void visit(ActionHandler h) {
        h.registerRecord(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.offset);
        sb.append(" ");
        for (int i = 0; i < this.registerNumbers.length; ++i) {
            sb.append("$" + this.registerNumbers[i] + "='" + this.variableNames[i] + "' ");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        boolean isIt = object instanceof RegisterRecord;
        if (isIt) {
            RegisterRecord other = (RegisterRecord)object;
            isIt = super.equals(other);
            for (int i = 0; isIt && i < this.registerNumbers.length; ++i) {
                isIt = other.registerNumbers[i] == this.registerNumbers[i] && other.variableNames[i] == this.variableNames[i] ? isIt : false;
            }
        }
        return isIt;
    }
}

